/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
ab_C(int n,int p)
{
int      i;
int      j;
fraction a;
fraction b;
fraction ab;

double pbC   [MXR][MXC*TWOCOL];matrix mC   ={MXR,MXC*TWOCOL,&pbC   [0][0]};
double pbbC  [MXR][MXC*TWOCOL];matrix mbC  ={MXR,MXC*TWOCOL,&pbbC  [0][0]};
double pba_bC[MXR][MXC*TWOCOL];matrix ma_bC={MXR,MXC*TWOCOL,&pba_bC[0][0]};
double pab_C [MXR][MXC*TWOCOL];matrix mab_C={MXR, MXC*TWOCOL,&pab_C[0][0]};

double pa_bC_mns_ab_C   [MXR][MXC*TWOCOL];
matrix ma_bC_mns_ab_C    ={MXR,MXC*TWOCOL,&pa_bC_mns_ab_C   [0][0]};

                     mC.rows=n;                   mC.cols=p*TWOCOL;
                    mbC.rows=n;                  mbC.cols=p*TWOCOL;
                  ma_bC.rows=n;                ma_bC.cols=p*TWOCOL;
                  mab_C.rows=n;                mab_C.cols=p*TWOCOL;

         ma_bC_mns_ab_C.rows=n;
         ma_bC_mns_ab_C.cols=p*TWOCOL;

/*-------------------------------- PROGRAM ---------------------------------- */
  a = rndF(9,5);
  b = rndF(9,5);

  rndmF(&mC,10,9);

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                      ");
  printf("b = %.0f/%.0f\n\n",
          b.numer,
          b.denom);
  printf("                                                      C  :");
  printmF4(&mC);
  getchar();


  clrscrn();
  printf("                                                      ");
  printf("b = %.0f/%.0f\n\n",
          b.numer,
          b.denom);
  printf("                                                       C :");
  printmF4( &mC);
  printf("                                                      bC :\n");
  smultmF(b,&mC,&mbC);
  printmF4(     &mbC);
  getchar();


  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                     bC  :");
  printmF4( &mbC);
  printf("                                                   a(bC) :\n");
  smultmF(a,&mbC,&ma_bC);
  printmF4(      &ma_bC);
  getchar();


  clrscrn();
  ab = multF(a,b);
  printf("                                      ");
  printf(" ab = %.0f/%.0f * (%.0f/%.0f) = %.0f/%.0f\n\n",
              a.numer,    a.denom,
              b.numer,    b.denom,
          ab.numer,ab.denom);
  printf("                                                       C :");
  printmF4( &mC);
  printf("                                                   (ab)C :\n");
  smultmF(ab,&mC,&mab_C);
  printmF4(      &mab_C);
  getchar();

  clrscrn();
  printf("                                                 a(bC)   :");
  printmF4(&ma_bC);
  printf("                                                 (ab)C   :");
  printmF4(&mab_C);
  printf("\n");
  printf("                                       (a(bC)) - ((ab)C) :");
  submF(&ma_bC,&mab_C,&ma_bC_mns_ab_C);
  printmF4(           &ma_bC_mns_ab_C);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            a(bC) = (ab)C                         ");
  printf("\n            *************                       \n");
  printf("\n The size of  mC         : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"plf.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"plf.exe 2 3\" -> 2x3                  ");
  printf("\n          \"plf.exe 1 5\" -> 1x5                  ");
  printf("\n          \"plf.exe 4 2\" -> 4x2                  ");
  printf("\n          \"plf.exe 5 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 4 && atoi(argv[1])&& atoi(argv[2]) && atoi(argv[3]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;} }
else
 {    n=rndpI(5);       p=rndpI(5); }
   if(n<1){n=1;}     if(p<1){p=1;}


  ab_C(n,p);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












