/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"


/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invAB(int n)
{
int x;

double pbA      [n][n*TWOCOL]; matrix mA       ={n,n*TWOCOL,&pbA      [0][0]};
double pbB      [n][n*TWOCOL]; matrix mB       ={n,n*TWOCOL,&pbB      [0][0]};
double pbAB     [n][n*TWOCOL]; matrix mAB      ={n,n*TWOCOL,&pbAB     [0][0]};

double pbinvA    [n][n*TWOCOL]; matrix minvA    ={n,n*TWOCOL,&pbinvA    [0][0]};
double pbinvB    [n][n*TWOCOL]; matrix minvB    ={n,n*TWOCOL,&pbinvB    [0][0]};
double pbinv_AB  [n][n*TWOCOL]; matrix minv_AB  ={n,n*TWOCOL,&pbinv_AB  [0][0]};
double pinvBinvA [n][n*TWOCOL]; matrix minvBinvA={n,n*TWOCOL,&pinvBinvA [0][0]};
double pbAID    [n][n*2*TWOCOL]; matrix mAID   ={n,n*2*TWOCOL,&pbAID  [0][0]};
double pbAIDT   [n][n*2*TWOCOL]; matrix mAIDT  ={n,n*2*TWOCOL,&pbAIDT [0][0]};
double pbT   [n][n*TWOCOL]; matrix mT       ={n,n*TWOCOL,&pbT   [0][0]};
double pbT2  [n][n*TWOCOL]; matrix mT2      ={n,n*TWOCOL,&pbT2  [0][0]};
double pbT3  [n][n*TWOCOL]; matrix mT3      ={n,n*TWOCOL,&pbT3  [0][0]};
double pbID  [n][n*TWOCOL]; matrix mID      ={n,n*TWOCOL,&pbID  [0][0]};
double pbIDT1[n][n*TWOCOL]; matrix mIDT1    ={n,n*TWOCOL,&pbIDT1[0][0]};
double pbIDT2[n][n*TWOCOL]; matrix mIDT2    ={n,n*TWOCOL,&pbIDT2[0][0]};

double pinv_AB_mns_invBinvA   [n][n*TWOCOL];
matrix minv_AB_mns_invBinvA  ={n, n*TWOCOL,&pinv_AB_mns_invBinvA    [0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */

             x =  6;
   if(n== 3){x =  8;}
   if(n== 2){x = 10;}

  randmI(&mA,x);
  randmI(&mB,x);

 clrscrn();
 printf("                                                        A :\n");
 printmF(&mA);
 printf("                                                        B :\n");
 printmF(&mB);
 getchar();

/* mA */
 copymF(&mA,&mT3);
 mid(&mID);
 copymAID (&mA,&mID,&mAID);

 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mA);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&mA);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mA);
 multmF(&mID,&mAIDT,&mAID);
 copyinv(&mAID, &minvA);

 clrscrn();
 printf("                                                     invA :\n");
 printmF(&minvA);
 copymF(&mT3,&mA);

/* mB */
 copymF(&mB,&mT3);
 mid(&mID);
 copymAID (&mB,&mID,&mAID);

 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mB);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&mB);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mB);
 multmF(&mID,&mAIDT,&mAID);
 copyinv(&mAID, &minvB);

 printf("                                                     invB :\n");
 printmF(&minvB);
 copymF(&mT3,&mB);
 getchar();

/* mAB */
 multmF(&mA,&mB,&mAB);

 clrscrn();
 printf("                                                        A :\n");
 printmF(&mA);
 printf("                                                        B :\n");
 printmF(&mB);
 printf("                                                       AB :\n");
 printmF(&mAB);
 getchar();

 copymF(&mAB,&mT3);
 mid(&mID);
 copymAID (&mAB,&mID,&mAID);

 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mAB);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&mAB);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mAB);
 multmF(&mID,&mAIDT,&mAID);
 copyinv(&mAID, &minv_AB);

 clrscrn();
 printf("                                                   invAB :\n");
 printmF(&minv_AB);
 printf("                                               invB invA : \n");
 multmF(&minvB,&minvA,&minvBinvA);
 printmF(&minvBinvA);
 printf("\n                                      invAB - (invB invA) :");
   submF(&minv_AB,&minvBinvA,&minv_AB_mns_invBinvA);
  printmF(                   &minv_AB_mns_invBinvA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            invAB = invB invA                     ");
  printf("\n            *****************                   \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"invabi.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invabi.exe 2\" -> mA 2x2        ");
  printf("\n                \"invabi.exe 3\" -> mA 3x3        ");
  printf("\n                \"invabi.exe 4\" -> mA 4x4        ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invAB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

