/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invB(int n)
{
int x;

double pb       [n][n*TWOCOL];  matrix m        ={n,n*TWOCOL,&pb      [0][0]};
double pTrps     [n][n*TWOCOL];  matrix mTrps    ={n,n*TWOCOL,&pTrps    [0][0]};
double pinvTrps  [n][n*TWOCOL];  matrix minvTrps ={n,n*TWOCOL,&pinvTrps [0][0]};
double pinv      [n][n*TWOCOL];  matrix minv     ={n,n*TWOCOL,&pinv     [0][0]};
double pTrpsinv  [n][n*TWOCOL];  matrix mTrpsinv ={n,n*TWOCOL,&pTrpsinv [0][0]};
double pbAID    [n][n*2*TWOCOL];matrix mAID     ={n,n*2*TWOCOL,&pbAID  [0][0]};
double pbAIDT   [n][n*2*TWOCOL];matrix mAIDT    ={n,n*2*TWOCOL,&pbAIDT [0][0]};
double pbT   [n][n*TWOCOL];  matrix mT       ={n,n*TWOCOL,&pbT   [0][0]};
double pbT2  [n][n*TWOCOL];  matrix mT2      ={n,n*TWOCOL,&pbT2  [0][0]};
double pbT3  [n][n*TWOCOL];  matrix mT3      ={n,n*TWOCOL,&pbT3  [0][0]};
double pbT4  [n][n*TWOCOL];  matrix mT4      ={n,n*TWOCOL,&pbT4  [0][0]};
double pbID  [n][n*TWOCOL];  matrix mID      ={n,n*TWOCOL,&pbID  [0][0]};
double pbIDT1[n][n*TWOCOL];  matrix mIDT1    ={n,n*TWOCOL,&pbIDT1[0][0]};
double pbIDT2[n][n*TWOCOL];  matrix mIDT2    ={n,n*TWOCOL,&pbIDT2[0][0]};

double pinvTrps_mns_Trpsinv [n][n*TWOCOL];
matrix minvTrps_mns_Trpsinv={n, n*TWOCOL,&pinvTrps_mns_Trpsinv[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
         x =   6;
 if(n<4){x =  10;}
 if(n<3){x = 100;}

 randmI(&m,x);

 copymF(&m,&mT3);

 clrscrn();
 printf("                                                         m :\n");
 printmF(&m);
 printf("                                              transpose(m) :\n");
 transposeF(&m,&mTrps);
 printmF(      &mTrps);
 copymF(&mTrps,&mT4);
 mid(&mID);
 copymAID (&mTrps,&mID,&mAID);
 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mTrps);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT4,&mTrps);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mTrps);
 multmF(&mID,&mAIDT,&mAID);
 printf("                                    inverse(transpose(m)) :\n");
 copyinv(&mAID,&minvTrps);
 printmF(      &minvTrps);
 getchar();

 clrscrn();
 printf("                                                         m :\n");
 printmF(&m);
 mid(         &mID);
 copymAID (&m,&mID,&mAID);
 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&m);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 multmF(&mID,&mAIDT,&mAID);
 printf("                                                 inverse(m) :\n");
 copyinv(&mAID, &minv);
 printmF(      &minv);
 printf("                                      transpose(inverse(m)) :\n");
 transposeF(&minv,&mTrpsinv);
 printmF(         &mTrpsinv);
 getchar();

 clrscrn();
 printf("                                     inverse(transpose(m)) :\n");
 printmF(&minvTrps);
 printf("                                     transpose(inverse(m)) :\n");
 printmF(&mTrpsinv);
 printf("\n           inverse(transpose(m)) - transpose(inverse(m)) :");
 submF(&minvTrps,&mTrpsinv,&minvTrps_mns_Trpsinv);
 printmF(                  &minvTrps_mns_Trpsinv);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n  Inverse(Transpose(m)) = Transpose(Inverse(m))   ");
  printf("\n  ********************************************* \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpinvi.exe\"                 \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpinvi.exe 2\" -> mA 2x2       ");
  printf("\n                \"trpinvi.exe 3\" -> mA 3x3       ");
  printf("\n                \"trpinvi.exe 4\" -> mA 4x4       ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

