/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
AplsB_BplsA(int n)
{
double pbA       [n][n*TWOCOL];matrix mA        ={n,n*TWOCOL,&pbA       [0][0]};
double pbB       [n][n*TWOCOL];matrix mB        ={n,n*TWOCOL,&pbB       [0][0]};
double pbAplsB   [n][n*TWOCOL];matrix mAplsB    ={n,n*TWOCOL,&pbAplsB   [0][0]};
double pbAmnsB   [n][n*TWOCOL];matrix mAmnsB    ={n,n*TWOCOL,&pbAmnsB   [0][0]};
double pAmnsB_AplsB  [n][n*TWOCOL];
matrix mAmnsB_AplsB ={n, n*TWOCOL,&pAmnsB_AplsB   [0][0]};

double pbA_p2    [n][n*TWOCOL];matrix mA_p2     ={n,n*TWOCOL,&pbA_p2    [0][0]};
double pbB_p2    [n][n*TWOCOL];matrix mB_p2     ={n,n*TWOCOL,&pbB_p2    [0][0]};
double pbAB      [n][n*TWOCOL];matrix mAB       ={n,n*TWOCOL,&pbAB      [0][0]};
double pbBA      [n][n*TWOCOL];matrix mBA       ={n,n*TWOCOL,&pbBA      [0][0]};

double pbT1      [n][n*TWOCOL];matrix mT1       ={n,n*TWOCOL,&pbT1      [0][0]};
double pbT2      [n][n*TWOCOL];matrix mT2       ={n,n*TWOCOL,&pbT2      [0][0]};



/*-------------------------------- PROGRAM ---------------------------------- */
  randmI(&mA, 9);
  randmI(&mB, 9);

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                     A+B :\n");
  addmF(&mA,&mB,&mAplsB);
  printmI(      &mAplsB);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                     A-B :\n");
  submF(&mA,&mB,&mAmnsB);
  printmI(      &mAmnsB);
  getchar();

  clrscrn();
  printf("                                                     A-B :\n");
  printmI(       &mAmnsB);
  printf("                                                     A+B :\n");
  printmI(       &mAplsB);
  printf("                                             (A-B) (A+B) :\n");
  multmF(&mAmnsB,&mAplsB,&mAmnsB_AplsB);
  printmI(              &mAmnsB_AplsB);
  getchar();


  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                    A**2 :\n");
  multmF(&mA,&mA,&mA_p2);
  printmI(       &mA_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                      AB :\n");
  multmF(&mA,&mB,&mAB);
  printmI(       &mAB);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                      BA :\n");
  multmF(&mB,&mA,&mBA);
  printmI(       &mBA);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                    B**2 :\n");
  multmF(&mB,&mB,&mB_p2);
  printmI(       &mB_p2);
  getchar();

  clrscrn();
  printf("                                        A**2+AB-BA-B**2  :\n");
  addmF(&mA_p2,&mAB,&mT1);
  submF(&mT1,&mBA,  &mT2);
  submF(&mT2,&mB_p2,&mT1);
  printmI(          &mT1);
  printf("                                              (A-B)(A+B) :\n");
  printmI(              &mAmnsB_AplsB);
  printf("\n                        (A-B)(A+B) - (A**2+AB-BA-B**2) :\n");
  submF(&mT1, &mAmnsB_AplsB,&mT2);
  printmI(                  &mT2);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n        (A-B)(A+B) = A**2+AB-BA-B**2              ");
  printf("\n        ****************************            \n");
  printf("\n The size of mA, mB      : 1x1 ... 4x4.         \n");
  printf("\n     ex : \"idmci.exe\"                         \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"idmci.exe 2\" -> 2x2                  ");
  printf("\n          \"idmci.exe 1\" -> 1x1                  ");
  printf("\n          \"idmci.exe 4\" -> 4x4                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

  srand(time(&t));
  hello();

do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]);

  if( n < 1){n=1;}
  if( n > 4){n=4;}
 }
else
 {
  n = (int) fabs(randF(4)+1);
 }

  AplsB_BplsA(n);

  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












