/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invAB(int n)
{
int x;

double pbA      [n][n*TWOCOL]; matrix mA      ={n,n*TWOCOL,&pbA      [0][0]};
double pbinvA   [n][n*TWOCOL]; matrix minvA   ={n,n*TWOCOL,&pbinvA   [0][0]};
double pbinvinvA[n][n*TWOCOL]; matrix minvinvA={n,n*TWOCOL,&pbinvinvA[0][0]};
double pbAID    [n][n*2*TWOCOL];matrix mAID   ={n,n*2*TWOCOL,&pbAID  [0][0]};
double pbAIDT   [n][n*2*TWOCOL];matrix mAIDT  ={n,n*2*TWOCOL,&pbAIDT [0][0]};
double pbT      [n][n*TWOCOL]; matrix mT      ={n,n*TWOCOL,&pbT      [0][0]};
double pbT2     [n][n*TWOCOL]; matrix mT2     ={n,n*TWOCOL,&pbT2     [0][0]};
double pbT3     [n][n*TWOCOL]; matrix mT3     ={n,n*TWOCOL,&pbT3     [0][0]};
double pbID     [n][n*TWOCOL]; matrix mID     ={n,n*TWOCOL,&pbID     [0][0]};
double pbIDT1   [n][n*TWOCOL]; matrix mIDT1   ={n,n*TWOCOL,&pbIDT1   [0][0]};
double pbIDT2   [n][n*TWOCOL]; matrix mIDT2   ={n,n*TWOCOL,&pbIDT2   [0][0]};


/*-------------------------------- PROGRAM ---------------------------------- */
          x = 100;
 if(n==3){x =  20;}

 randmI(&mA,x);

 clrscrn();
 printf("                                                        A :\n");
 printmF(&mA);

/* invA */
 copymF(&mA,&mT3);
 mid(&mID);
 copymAID (&mA,&mID,&mAID);

 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mA);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&mA);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mA);
 multmF(&mID,&mAIDT,&mAID);
 copyinv(&mAID, &minvA);

 printf("                                              inverse(A)  :\n");
 printmF(&minvA);
 copymF(&mT3,&mA);

/* minvinvA */
 copymF(&minvA,&mT3);
 mid(&mID);
 copymAID (&minvA,&mID,&mAID);

 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&minvA);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&minvA);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&minvA);
 multmF(&mID,&mAIDT,&mAID);
 copyinv(&mAID, &minvinvA);

 printf("                                      inverse(inverse(A)) :\n");
 printmF(&minvinvA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n         inverse(inverse(A)) = A                  ");
  printf("\n         ***********************                \n");
  printf("\n The size of mA : 2x2 ... 3x3.                  \n");
  printf("\n           ex : \"invai.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invai.exe 2\" -> mA 2x2         ");
  printf("\n                \"invai.exe 3\" -> mA 3x3         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 3){n=3;}
    }
  else
    {
    n = (int) fabs(randF(4));
    if(n<2){n=2;}
    }

  invAB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

