/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 4
#define mxc 4

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
AmnsB_BmnsA(int n)
{
double pbA    [mxr][mxc*TWOCOL];matrix mA    ={mxr,mxc*TWOCOL,&pbA    [0][0]};
double pbTrpsA[mxr][mxc*TWOCOL];matrix mTrpsA={mxr,mxc*TWOCOL,&pbTrpsA[0][0]};

double pAmnsTrpsA [mxr][mxc*TWOCOL];
matrix mAmnsTrpsA={mxr, mxc*TWOCOL,&pAmnsTrpsA[0][0]};

                     mA.rows=n;                  mA.cols=n*TWOCOL;
                 mTrpsA.rows=n;              mTrpsA.cols=n*TWOCOL;
             mAmnsTrpsA.rows=n;          mAmnsTrpsA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  randmI(&mA, 100);

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  getchar();

  clrscrn();
  printf("                                                      A  :");
  printmI(&mA);
  printf("                                            Transpose(A) :");
  transposeF(&mA,&mTrpsA);
  printmI(       &mTrpsA);
  getchar();

  clrscrn();
  printf("                                                       A :\n");
  printmI(&mA);
  printf("\n                                            Transpose(A) :\n");
  printmI(&mTrpsA);
  printf("\n                    A - Transpose(A) : Is Skew-Symmetric :\n");
  submF(&mA,&mTrpsA,&mAmnsTrpsA);
  printmI(&mAmnsTrpsA);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n        A - Transpose(A) : Is Skew-Symmetric      ");
  printf("\n        ************************************    \n");
  printf("\n The size of mA, mB      : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"symci.exe\"                         \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"symci.exe 2\" -> 2x2                  ");
  printf("\n          \"symci.exe 1\" -> 1x1                  ");
  printf("\n          \"symci.exe 4\" -> 2x2                  ");
  printf("\n          \"symci.exe 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

  srand(time(&t));
  hello();

do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]);

  if( n > mxr){n=mxr;}
 }
else
 {
  n = (int) fabs(randF(mxr));
 }

  if(n<2){n=2;}

  AmnsB_BmnsA(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












