/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 5
#define mxc 5

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
int m = n + 2;
int p = n + 1;

double pbA   [mxr][mxc  *TWOCOL];  matrix mA   ={mxr,mxc    *TWOCOL,&pbA   [0][0]};
double pbb1  [mxr][      TWOCOL];  matrix mb1  ={mxr,        TWOCOL,&pbb1  [0][0]};
double pbb2  [mxr][      TWOCOL];  matrix mb2  ={mxr,        TWOCOL,&pbb2  [0][0]};
double pbA_bn[mxr][(mxc+2)*TWOCOL];matrix mA_bn={mxr,(mxc+2)*TWOCOL,&pbA_bn[0][0]};
double pbA_b1[mxr][(mxc+1)*TWOCOL];matrix mA_b1={mxr,(mxc+1)*TWOCOL,&pbA_b1[0][0]};
double pbA_b2[mxr][(mxc+1)*TWOCOL];matrix mA_b2={mxr,(mxc+1)*TWOCOL,&pbA_b2[0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                    mb1.rows=n;                  mb1.cols=  TWOCOL;
                    mb2.rows=n;                  mb2.cols=  TWOCOL;
                  mA_bn.rows=n;                mA_bn.cols=m*TWOCOL;
                  mA_b1.rows=n;                mA_b1.cols=p*TWOCOL;
                  mA_b2.rows=n;                mA_b2.cols=p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 10;}

  randmI(&mA, x);
  randmI(&mb1,x);
  randmI(&mb2,x);

  copymF(  &mA,   &mA_b1    );
  copycolF(&mb1,0,&mA_b1,n  );
  copymF(  &mA,   &mA_b2    );
  copycolF(&mb2,0,&mA_b2,n  );
  copymF(  &mA,   &mA_bn    );
  copycolF(&mb1,0,&mA_bn,n  );
  copymF(  &mA,   &mA_bn    );
  copycolF(&mb2,0,&mA_bn,n+1);

  clrscrn();
  printf("\n Linear systems with a common coefficient matrix : Ax = A|b1|b2 \n");
  printf("\n                                              A  :\n");
  printmI(&mA);
  printf("\n                                              b1 :\n");
  printmI(&mb1);
  printf("\n                                              b2 :\n");
  printmI(&mb2);
  getchar();

  clrscrn();
  printf("\n                                         A|b1|b2 :\n");
  printmI(     &mA_bn);
  printf("\n      Gauss Jordan elimination of matrix A|b1|b2 :\n");
  gaussjordanF(&mA_bn);
  printm2IF(   &mA_bn);
  getchar();

  clrscrn();
  printf("\n      Gauss Jordan elimination of matrix A|b1|b2 :\n");
  printm2IF(   &mA_bn);
  printf("\n                                            A|b1 :\n");
  printmI(     &mA_b1);
  printf("\n         Gauss Jordan elimination of matrix A|b1 :\n");
  gaussjordanF(&mA_b1);
  printmIF(    &mA_b1);
  getchar();

  clrscrn();
  printf("\n      Gauss Jordan elimination of matrix A|b1|b2 :\n");
  printm2IF(   &mA_bn);
  printf("\n                                            A|b2 :\n");
  printmI(     &mA_b2);
  printf("\n         Gauss Jordan elimination of matrix A|b2 :\n");
  gaussjordanF(&mA_b2);
  printmIF(    &mA_b2);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            GaussJordan : A|b1|b2                 ");
  printf("\n            *********************               \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"gausx2i.exe\"                 \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"gausx2i.exe 2\" -> mA 2x2       ");
  printf("\n                \"gausx2i.exe 3\" -> mA 3x3       ");
  printf("\n                \"gausx2i.exe 4\" -> mA 4x4       ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n> mxr){n=mxr;}
    }
  else
    {
    n = (int) fabs(randF(mxr));
    }

    if(n<2){n=2;}

  invb(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

