/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
gjA(
int n)
{
int    m = n - 1;

double pbA    [n][n*TWOCOL]; matrix mA    ={n,n*TWOCOL,&pbA    [0][0]};
double pbTA   [n][n*TWOCOL]; matrix mTA   ={n,n*TWOCOL,&pbTA   [0][0]};
double pbInvA [n][n*TWOCOL]; matrix mInvA ={n,n*TWOCOL,&pbInvA [0][0]};
double pbAInvA[n][n*TWOCOL]; matrix mAInvA={n,n*TWOCOL,&pbAInvA[0][0]};
double pbT1   [m][m*TWOCOL]; matrix mT1   ={m,m*TWOCOL,&pbT1   [0][0]};
double pbT2   [n][n*TWOCOL]; matrix mT2   ={n,n*TWOCOL,&pbT2   [0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
  clrscrn();
  printf("     Inverses of symmetric matrices are symmetric \n");
  msymetricF(&mA,8,4);
  copymF(&mA,&mTA);
  printf("                                                        A  :");
  printmF5(&mA);
  printf("                                                      InvA :");
  inverseF(&mA,&mT1,&mT2,&mInvA);
  printmF5(&mInvA);
  printf("                                                    A*InvA :");
  copymF(&mTA,&mA);
  multmF(&mA,&mInvA,&mAInvA);
  printmF5(&mAInvA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France \n");
  printf("\n                                                  ");
  printf("\n   Inverses of symmetric matrices are symmetric   ");
  printf("\n   ********************************************   ");
  printf("\n                                                  ");
  printf("\n The size of mA, mB : 3x3     6x6               \n");
  printf("\n        ex : \"syminvF exe\"                    \n");
  printf("\n You can choose the size :                      \n");
  printf("\n        ex : \"syminvF exe 3\" -> mA(3x3)         ");
  printf("\n             \"syminvF exe 4\" -> mA(4x4)         ");
  printf("\n             \"syminvF exe 5\" -> mA(5x5)         ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www simtel net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t  t;
int     n;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n  = atoi(argv[1]);

    if(  n < 2){ n = 2;}
    if(  n > 4){ n = 4;}
    }
  else
    {
    n  = (int) fabs(randF(5));

    if(n<2){n=2;}
    }

  gjA(n);
  printf(" Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

