/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
gjA(
int n)
{
double pbA [n][n*TWOCOL]; matrix mA ={n,n*TWOCOL,&pbA [0][0]};
double pbB [n][n*TWOCOL]; matrix mB ={n,n*TWOCOL,&pbB [0][0]};
double pbAB[n][n*TWOCOL]; matrix mAB={n,n*TWOCOL,&pbAB[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */

  clrscrn();
  printf("        Multiply two lower triangular matrices \n");
  mlowertriangI(&mA,9);
  printf("                                                        A  :");
  printmI(&mA);
  mlowertriangI(&mB,9);
  printf("                                                        B  :");
  printmI(&mB);
  printf("                                                        AB :");
  multmF(&mA,&mB,&mAB);
  printmI(&mAB);
  getchar();

  clrscrn();
  printf("    Multiply two upper triangular matrices  :\n");
  muppertriangI(&mA,9);
  printf("                                                         A  :");
  printmI(&mA);
  muppertriangI(&mB,9);
  printf("                                                         B  :");
  printmI(&mB);
  printf("                                                         AB :");
  multmF(&mA,&mB,&mAB);
  printmI(&mAB);

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France \n");
  printf("\n                                                  ");
  printf("\n       Multiply two upper triangular matrices     ");
  printf("\n       **************************************     ");
  printf("\n       Multiply two lower triangular matrices     ");
  printf("\n       **************************************     ");
  printf("\n                                                  ");
  printf("\n The size of mA, mB : 3x3     6x6               \n");
  printf("\n        ex : \"trigabI exe\"                    \n");
  printf("\n You can choose the size :                      \n");
  printf("\n        ex : \"trigabI exe 3\" -> mA(3x3)         ");
  printf("\n             \"trigabI exe 4\" -> mA(4x4)         ");
  printf("\n             \"trigabI exe 5\" -> mA(5x5)         ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www simtel net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t  t;
int     n;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n  = atoi(argv[1]);

    if(  n < 3){ n = 3;}
    if(  n > 6){ n = 6;}
    }
  else
    {
    n  = (int) fabs(randF(7));

    if(n<3){n=3;}
    }

  gjA(n);
  printf(" Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

