/* xkmtriag.h                   freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION ---------------------------- mid() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int mlowertriangF(
pmatrix m,
int maxnumer,
int maxdenom)
{
int i;
int j;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock + i *m->cols + j    ) = 0;
       *(m->pblock + i *m->cols + j + 1) = 1;

       if( (i*TWOCOL) >= j)
         {
          *(m->pblock + i *m->cols + j    ) = rndI (maxnumer);
          *(m->pblock + i *m->cols + j + 1) = rndpI(maxdenom);
         }
       }
    }

  return (0);
}

/* ------------------------------ FUNCTION ---------------------------- mid() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int mlowertriangI(
pmatrix m,
int maxnumer)
{
int i;
int j;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock + i *m->cols + j    ) = 0;
       *(m->pblock + i *m->cols + j + 1) = 1;

       if( (i*TWOCOL) >= j)
         {
          *(m->pblock + i *m->cols + j) = rndI(maxnumer);
         }
       }
    }

  return (0);
}



/* ------------------------------ FUNCTION ---------------------------- mid() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int muppertriangF(
pmatrix m,
int maxnumer,
int maxdenom)
{
int i;
int j;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock + i *m->cols + j    ) = 0;
       *(m->pblock + i *m->cols + j + 1) = 1;

       if( (i*TWOCOL) <= j)
         {
          *(m->pblock + i *m->cols + j    ) = rndI (maxnumer);
          *(m->pblock + i *m->cols + j + 1) = rndpI(maxdenom);
         }
       }
    }

  return (0);
}


/* ------------------------------ FUNCTION ---------------------------- mid() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int muppertriangI(
pmatrix m,
int maxnumer)
{
int i;
int j;

  if (m->rows * TWOCOL != m->cols)
    {
     printf("\n mid() error - matrix must be square");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0 ; i < m->rows ; i++)
    {
    for ( j = 0 ; j < m->cols ; j++,j++)
       {
       *(m->pblock + i *m->cols + j    ) = 0;
       *(m->pblock + i *m->cols + j + 1) = 1;

       if( (i*TWOCOL) <= j)
         {
          *(m->pblock + i *m->cols + j) = rndI(maxnumer);
         }
       }
    }

  return (0);
}

