/* myfmop.h                     freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = mIn1 + mIn2          */
/* -------------------------------------------------------------------------- */
int addmF(
pmatrix mIn1,
pmatrix mIn2,
pmatrix mOut)
{

     int i;
     int j;
fraction f;

  if (mIn1->rows != mIn2->rows || mIn1->cols != mIn2->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mIn1->rows!=mOut->rows||mIn1->cols!=mOut->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0; i < mIn1->rows ; i++)
    for ( j = 0; j < mIn1->cols ; j++, j++)
         {

                                              f.numer =   \

                 (*(mIn1->pblock + i *mIn1->cols + j) *   \
                 *(mIn2->pblock + i *mIn2->cols + j + 1))
                                    + \
                 *(mIn2->pblock + i *mIn2->cols + j)  *   \
                 *(mIn1->pblock + i *mIn1->cols + j + 1);

                                                f.denom = \

                *(mIn1->pblock + i *mIn1->cols + j + 1) * \
                *(mIn2->pblock + i *mIn2->cols + j + 1);

                 f = fminiFnotZero(f);

                *(mOut->pblock + i *mOut->cols + j)       = f.numer;
                *(mOut->pblock + i *mOut->cols + j + 1)   = f.denom;
         }
/*               printf("%8.1lf / %-8.1lf",
                            *(mIn1->pblock + i *mIn1->cols + j + 1),
                            *(mIn2->pblock + i *mIn2->cols + j + 1));
*/
  return(0);
}


/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = mIn1 + mIn2          */
/* -------------------------------------------------------------------------- */
int submF(
pmatrix mIn1,
pmatrix mIn2,
pmatrix mOut)
{

     int i;
     int j;
fraction f;

  if (mIn1->rows != mIn2->rows || mIn1->cols != mIn2->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mIn1->rows!=mOut->rows||mIn1->cols!=mOut->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0; i < mIn1->rows ; i++)
    for ( j = 0; j < mIn1->cols ; j++, j++)
         {

                                              f.numer =   \

                 (*(mIn1->pblock + i *mIn1->cols + j) *   \
                 *(mIn2->pblock + i *mIn2->cols + j + 1))
                                    - \
                 *(mIn2->pblock + i *mIn2->cols + j)  *   \
                 *(mIn1->pblock + i *mIn1->cols + j + 1);

                                                f.denom = \

                *(mIn1->pblock + i *mIn1->cols + j + 1) * \
                *(mIn2->pblock + i *mIn2->cols + j + 1);

                 f = fminiFnotZero(f);

                *(mOut->pblock + i *mOut->cols + j)       = f.numer;
                *(mOut->pblock + i *mOut->cols + j + 1)   = f.denom;
         }
/*               printf("%8.1lf / %-8.1lf",
                            *(mIn1->pblock + i *mIn1->cols + j + 1),
                            *(mIn2->pblock + i *mIn2->cols + j + 1));
*/
  return(0);
}



/* ------------------------------ FUNCTION -------------------------- addf()  */
/* -------------------------------------------------------------------------- */
fraction addF(
fraction f1,
fraction f2)
{
  (f1.numer)=(f1.numer)*(f2.denom) + (f2.numer)*(f1.denom);
  (f1.denom)=(f1.denom)*(f2.denom);

   if(!f1.numer){f1.denom = 1;}

  return(f1);
}


/* ------------------------------ FUNCTION -------------------------- multm() */
/*    mutiply two matrices giving a third matrix    mOut = mIn1 * mIn2        */
/* -------------------------------------------------------------------------- */
void multmF(
pmatrix mIn1,
pmatrix mIn2,
pmatrix mOut)
{
     int i;
     int j;
     int k;
fraction fm;
fraction fa;

              for(k= 0; k < mIn1->rows; k++)
               {
                  for(j= 0; j < mIn2->cols; j++,j++)
                   { fa.numer = 0;
                     fa.denom = 1;
                    for(i= 0; i < mIn1->cols; i++,i++)
                    {
                    fm.numer = *(mIn1->pblock +  k   *(mIn1->cols) + i )  * \
                               *(mIn2->pblock + i/2  *(mIn2->cols) + j ) ;

                    fm.denom = *(mIn1->pblock +  k   *(mIn1->cols) + i + 1) * \
                               *(mIn2->pblock + i/2  *(mIn2->cols) + j + 1);

                    fm = fminiFnotZero( fm);
                    fa = addF(fa,fm);
                    }
                     fa = fminiFnotZero(fa);

                     *(mOut->pblock +  k   *(mOut->cols) + j    ) = fa.numer;
                     *(mOut->pblock +  k   *(mOut->cols) + j + 1) = fa.denom;
                   }
               }
}


/* ------------------------------ FUNCTION ------------------------ powermF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void powmF(
pmatrix m,
pmatrix mT1,
pmatrix mT2,
    int n)
{
 int i;

 if(!n){mid(m);}
 else
 {
  copymF(m,mT1);
  for(i = n-1 ; i ; i--)
  {
   multmF(m,mT1,mT2);
   copymF(mT2,m);
  }
 }
}

/* ------------------------------ FUNCTION ------------------------ smultmF() */
/*         m = scalaire * m                                                   */
/* -------------------------------------------------------------------------- */
int smultmF(
fraction s,
pmatrix mIn1)
{
     int i;
     int j;
fraction f;

  for (   i = 0; i < mIn1->rows ; i++)
    for ( j = 0; j < mIn1->cols ; j++, j++)
         {
          f.numer = (*(mIn1->pblock + i *mIn1->cols + j    )) * s.numer;
          f.denom = (*(mIn1->pblock + i *mIn1->cols + j + 1)) * s.denom;

                f = fminiFnotZero(f);

         (*(mIn1->pblock + i *mIn1->cols + j    )) = f.numer;
         (*(mIn1->pblock + i *mIn1->cols + j + 1)) = f.denom;
         }

  return(0);
}


/* ------------------------------ FUNCTION ---------------------- transpose() */
/*                     */
/* -------------------------------------------------------------------------- */
int transposeF(
pmatrix mIn,
pmatrix mOut)
{
  int i;
  int j;

  if (mOut->rows * TWOCOL != mIn->cols)
    {
     printf("\n transpose() error - dest matrix rows must = source matrix cols");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mIn->rows * TWOCOL != mOut->cols)
    {
     printf("\n transpose() error - source matrix rows must = dest matrix cols");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (  i = 0 ; i < mIn->rows ;     i++)
   {
    for (j = 0 ; j < mIn->cols ; j++,j++)
      {
       *(mOut->pblock + (j/TWOCOL) *mOut->cols + i * TWOCOL)     = \
       *( mIn->pblock +  i         *mIn->cols  + j         );

       *(mOut->pblock + (j/TWOCOL) *mOut->cols + i * TWOCOL + 1) = \
       *( mIn->pblock +  i         *mIn->cols + j           + 1);
      }
   }
  return(0);
}

/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = m + mIn2          */
/* -------------------------------------------------------------------------- */
fraction traceF(
pmatrix m)
{
     int i;
fraction f;
fraction fT;

  if ((m->rows * TWOCOL) !=  m->cols)
    {
     printf("\n trF() error - Square matrix, please");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }

    f.numer = 0;
    f.denom = 1;

  for(   i = 0; i < m->rows ; i++)
     {
      fT.numer = (*(m->pblock + i *m->cols + i * TWOCOL    ));
      fT.denom = (*(m->pblock + i *m->cols + i * TWOCOL + 1));

             f = addF(f,fT);

             f = fminiFnotZero(f);
     }

  return(f);
}

