include mwutil.ah

_DATA segment
      extrn conio_scr_info: TINFO
      extrn screen_page   : word
_DATA ends

_TEXT segment
      extrn conio_init : near

;----------------------------------------------------------------------
; Return cursor positions relative to current winleft/winbottom
;
; int  wherex (void);
; int  wherey (void);

PubProc  wherex
         call  conio_init
         call wherexy_abs
         sub al, conio_scr_info.winleft
         add al,2
         mov conio_scr_info.curx,al
         movzx eax,al
         ret

PubProc  wherey
         call  conio_init
         call wherexy_abs
         sub ah, conio_scr_info.wintop
         add ah,2
         mov conio_scr_info.cury,ah
         movzx eax,ah
         ret

;----------------------------------------------------------------------
; wherexy_abs: reads the absolute position of the cursor
; Return: AH = Y (0..49)
;         AL = X (0..131)
;

PubProc  wherexy_abs
         push es
         mov ax,SS_DOSMEM
         mov es,ax
         movzx eax,screen_page
         movzx eax,word ptr es:[450h+2*eax]  ; get cursor position
         pop es
         ret

_TEXT ends
end

