/*===================================================================
 interpol.c

 Version 1.0

 Written by:
   Brent Worden
   WordenWare
   email:  brent@worden.org

 Copyright (c) 2000-2001 WordenWare

 Created:  January 7, 2000
 Revised:  
===================================================================*/

#include <math.h>
#include "interpol.h"
#include "vecutils.h"
#include "numerror.h"

NUMERICS_EXPORT double polyint(double *xa, double *ya, int n, double x, double *dy)
{
	double dif, dift;
	int ns, i, m;
	double *c, *d;
	double den, ho, hp, w;
	double y;

	dif = fabs(x - xa[0]);
	ns = 0;
	c = dvector(0, n-1);
	d = dvector(0, n-1);
	
	for(i = 0; i < n; ++i){
		dift = fabs(x - xa[i]);
		if(dift < dif){
			ns = i;
			dif = dift;
		}
		c[i] = ya[i];
		d[i] = ya[i];
	}

	y = ya[ns--];
	for(m = 0; m < n - 1; ++m){
		for(i = 0; i < n - m; ++i){
			ho = xa[i] - x;
			hp = xa[i + m] - x;
			w = c[i + 1] - d[i];
			den = ho - hp;
			if(den == 0.0){
				NUMERICS_ERROR("polyint", "Two x values are the same.");
			}
			den = w / den;
			d[i] = hp * den;
			c[i] = ho * den;
		}
		*dy = (2 * ns < (n - m)) ? c[ns + 1] : d[ns--];
		y += *dy;
	}
	free_dvector(c, 0);
	free_dvector(d, 0);

	return y;
}

/*===================================================================
 Revision History

 Version 1.0 - 01/07/2000 - New.
===================================================================*/
