/* CFF.H	-- user api include file for the cff library */

#define CALLER(a) (((unsigned*)&a)[-1])

#if defined(__GNUC__) || defined(__OXCC__)
#ifndef __ITEMH__
#define __ITEMH__
typedef unsigned long long  KeyItem;   /* type for a key's associated item */
#endif
#endif

typedef union 			/* 2 BYTES */
	{
		unsigned short val;
		unsigned char b[2];
} SVAL;

typedef union			/* 4 BYTES */
	{
	unsigned long a0;
	void *a1;
	struct
		{
		SVAL	lo_word;
		SVAL	hi_word;
		} a2;
	struct
		{
			unsigned int pad :28;
			unsigned int type :4;
		} a3;
	struct
		{
			unsigned char b[4];
		} a4;
	int a8;
	short a9;
	char a10;
	float a11;
} ADDR;

#ifndef __STORH__
#define __STORH__

typedef union _stor	/* 8 BYTES */
	{
	unsigned long	a0;
	void *a1;
#if defined(__GNUC__) || defined(__OXCC__)
	KeyItem item;
#endif
	struct
		{
		unsigned short	lo_word;
		unsigned short	hi_word;
		unsigned int size :28;		/* in bytes or nibbles */
		unsigned int type :4;	    /* describes the STOR type */
		} a2;
	struct
		{
			short s0;
			short s1;
			short s2;
			short s3;
		} a3;
	struct
		{
			unsigned long	s0;
			unsigned long	s1;
		} a4;
	struct
		{
			unsigned char	b[8];
		} a5;
#if	defined(__GNUC__) || defined(__OXCC__)
	struct
		{
			unsigned long long dupname :48;
			unsigned long long dupid :16;
		} a6;
#endif
	struct
		{
			unsigned int home : 30;
			unsigned int full : 2;
		} a7;
	int a8;
	short a9;
	char a10;
	float a11;
	double a12;
} STOR, Item;
#endif /* __STORH__ */

/* DEFINITIONS FOR "a2.type */
#define STO_INACTIVE (0)
#define STO_NIL  (1)
#define STO_VALUE (2)	
#define STO_CHUNK (3)
#define STO_KEYINFO (4)
#define STO_NILCHUNK (5)
#define STO_COMPCHUNK (6)
#define STO_ALLOCATED (7)
#define STO_DELETED (8)	/* always ored with non zero */
#define STOMASK (7)

typedef struct {
	unsigned long	name;
	unsigned short	xname;
	unsigned short	id;
} DupName;

typedef struct			/* 12 BYTES */
	{
		STOR c0;
		ADDR c1;
	} CAT;
#define CATEXACT  (8)
#define CATHASH (cat.c1.a0)

typedef struct	/* 20 bytes */
	{
		STOR	stor;
		CAT		cat;
} SDB;


/* DEFINE CFF OPEN MODES */

#define F_RDONLY	(0x0001)
#define F_WRONLY	(0x0002)
#define F_RDWR		(0x0003)
#define F_CREAT		(0x0004)
#define F_TEMP		(0x0008)
#define F_UNIQ		(0x0010)
#define F_EXCL		(0x0020)
#define F_BITMAP	(0x0040)
#define F_TRUNC		(0x0080)
#define F_APPEND	(0x0100)
#define F_DELETING	(0x0200)
#define F_FILEONLY	(0x0400)
#define F_BIGDIR	(0x0800)
#define F_HUGEDIR	(0x1000)
#define F_SETUP		(0x4000)
#define F_PARENTS	(0x4000)
#define F_SORTED	(0x8000)
#define F_UNTAGGED	(0x10000)
#define F_STAT		(0x20000)	/* TRULY READONLY */
#define F_TEXT		(0x40000)	/* DOS crap, default mode is binary */
#define F_ZIPFILE	(0x80000)	/* compress the file aspect */
#define F_ZIPDATA	(0x100000)	/* compress data chunks */
#define F_TEMPFILE	(F_RDWR|F_CREAT|F_UNIQ|F_TEMP)

/* BUFFER RELEASE MODES */
#define R_DIRTY		(0x80000000)
#define R_CLEAN		(0x40000000)
#define R_FLUSH		(0x20000000)

/* DEFINE SOME SYSTEM CALL VALUES */
#define S_READBLK (1)
#define S_WRITEBLK (2)
#define S_GETSPACE (3)
#define S_GIVESPACE (4)
#define S_CLOSE (5)
#define S_OPEN (6)
#define S_CREATE (7)
#define S_UNLINK (8)
#define S_SEEK (9)
#define S_FLUSH (10)
#define S_CLOSETRUNC (11)

#define S_SET (0)
#define S_CUR (1)
#define S_END (2)

/* DEFINE CFF OBJECT PROPERTIES -- returned by cfobtype(void *something) */
#define OB_SHARE	(0x00000001)
#define OB_ISDIR	(0x00000002)
#define OB_BMOK		(0x00000004)
#define OB_SMOK		(0x00000008)
#define OB_MEM		(0x00000010)
#define OB_RAWDEV	(0x00000020)
#define OB_CFILE	(0x00000040)
#define OB_SETUP	(0x00000080)
#define OB_FOD		(0x00000100)
#define OB_ROOTDIR	(0x00000200)
#define OB_DIRTY	(0x00000400)
#define OB_DELCLOSE	(0x00000800)
#define OB_WRITE	(0x00001000)
#define OB_BITMAP	(0x00002000)
#define OB_XFILE	(0x00004000)
#define OB_ISNEW	(0x00008000)
#define OB_SMEM		(0x00010000)
#define OB_FILEONLY	(0x40000000)
#define OB_HASHDIR	(0x20000000)
#define OB_TREEDIR	(0x10000000)
#define OB_UNTAGGED (0x08000000)
#define OB_PREALLOC (0x01000000)
#define OB_ZIPFILE	(0x00800000)
#define OB_ZIPDATA	(0x00400000)
#define OB_CHUNK	(0x00200000)
#define OB_VALUE	(0x00100000)

#ifndef NULL
#define NULL ((void *)0)
#endif
#ifndef EOF
#define EOF     (-1)
#endif
#define YES     (1)
#define NO      (0)
#define OK      (1)
#define NODUPS	(0)
#define OKDUPS	(1)
#define CNTDUPS (2)
#define DUPNAMES (4)

#define PREALLOC1 (8)
#define PREALLOC2 (16)
#define PREALLOC3 (32)

#define ERROR   (-1)
#define FOUND	(1)
#define NOTFOUND (0)
#define NONE	(-1)	/* no value */
#define INVALID (-4)	/* invalid value */
#define LESS	(-1)	/* a is less than b */
#define EQUAL	(0)		/* a and b are equal */
#define GREATER	(2)		/* a is greater than b */
#define	BOI	(-2)		/* beginning of index */
#define	EOI	(-3)		/* end of index */

typedef struct opninfo {
	long initial_entries;
	unsigned long bitmap_prealloc;
	long data_prealloc;
} OPNINFO;

typedef struct cfdirent {
	int d_namlen;
	char *d_name;
	unsigned long d_bytesalloc;
	unsigned long d_bytesused;
	unsigned long d_mode;
	unsigned long d_entrycnt;
	unsigned long d_ino;
	unsigned long d_mtime;
	unsigned long d_ctime;
	void *d_fpt;
} CFDIRENT;

/* Function codes for the cfmisc instruction */
enum CfMisc {
	CF_ALLOC,CF_USED,CF_DEPTH,CF_MARK,CF_HEAD,CF_TAIL,CF_NEXT,
	CF_PREV,CF_KEYLEN,CF_DATALEN,CF_MODBUFS,
	CF_CURBUFS,CF_SETKEYCMP,CF_SETITEMCMP,CF_SETERRFUNC,
	CF_LAZY,CF_VERYLAZY,CF_CLRLAZY,CF_ISNEW,CF_FLUSH,
	CF_FILESIZE,CF_FILEALLOC,CF_PREALLOC,CF_ALIGNMENT,
	CF_MAPSIZE,CF_ISSORTED,CF_KEY,CF_ITEM,CF_CREEP,
	CF_SETPRINTFUNC,CF_DATA,CF_GETMARK,CF_SETMARK
};

typedef struct cffstat {
		unsigned long	st_smhead;
		unsigned long	st_smtail;
		unsigned short	st_id;
		unsigned short	st_keysize;

		STOR		   st_dups;
		unsigned long  st_bmhead;
		unsigned long  st_bmtail;
        unsigned long  st_mode;
        short st_uid;
        short st_gid;
        long  st_mtime;
        long  st_ctime;

		unsigned long  st_highleaf;
        unsigned long  st_size;
		unsigned long  st_alloc;
		unsigned long  st_entrycnt;
		short 		   st_mapsize;
		unsigned short st_dupids;

        long  st_atime;
		long  st_filesize;
		long  st_filealloc;
		long  st_obtype;
		unsigned int st_filedups;
        long  st_ino;
        short st_blksize;
        short st_dev;
        short st_nlink;
        short st_rdev;
} CFSTAT;

/* MODE BITS */
#define M_AFMT		(0x30000000)
#define M_ROOTDIR	(0x80000000)
#define M_FILEONLY	(0x40000000)
#define M_HASHDIR	(0x20000000)
#define M_TREEDIR	(0x10000000)
#define M_UNTAGGED	(0x08000000)
#define M_BITMAP	(0x04000000)
#define M_EXTRNFILE	(0x02000000)
#define M_PREALLOC	(0x01000000)
#define M_ZIPFILE	(0x00800000)
#define M_ZIPDATA	(0x00400000)
#define M_CHUNK		(0x00200000)
#define M_VALUE		(0x00100000)
#define M_IFMT		(0x0000F000)
#define M_IFREG		(0x00008000)
#define M_IFDIR		(0x00004000)
#define M_IFIFO		(0x00002000)
#define M_IFCHR		(0x00001000)
#define M_IFBLK		(0x00003000)
#define M_IREAD		(0x00000100)
#define M_IWRITE	(0x00000080)
#define M_IEXEC		(0x00000040)


extern void *PERMCAT;
extern void *PERMINFO;
extern void *PERMFILE;
extern void *MEMTEMP;
#define MEMTMP MEMTEMP

extern char *cff_version;
extern char *cff_copyright;


#ifdef __cplusplus
extern "C" {
#endif

/* STDIO STUFF */
#define __BUFSIZ_  4096

extern  struct  cf_iobuf {
    int      _cnt;
    char*    _ptr;
    char*    _base;
	int		 _bufsiz;
    short		 _flag;
    unsigned char _file;
	char	 _sbuf;
} cf_iob[];
extern void *cf_filelist[];

typedef struct cf_iobuf cfFILE;

#define cf_IOFBF    00000
#define cf_IOREAD   00001
#define cf_IOWRT    00002
#define cf_IONBF    00004
#define cf_IOMYBUF  00010
#define cf_IOEOF    00020
#define cf_IOERR    00040
#define cf_IOSTRG   00100
#define cf_IOLBF    00200
#define cf_IORW     00400
#define cf_IOAPPEND 01000
#define cf_IOTEXT   02000  /* for MSDOS cr/lf style files */

#define cfstdin     (&cf_iob[0])
#define cfstdout    (&cf_iob[1])
#define cfstderr    (&cf_iob[2])
#define cfstdaux	(&cf_iob[3])
#define cfstdprn	(&cf_iob[4])

#define cfgetc(p) (--(p)->_cnt>=0 ? \
  (int)(*(unsigned char*)(p)->_ptr++) : \
  cf_filbuf(p))
#define cfputc(x,p) (--(p)->_cnt>=0? \
  ((int)((unsigned char)((*(p)->_ptr++=(unsigned)(x))))): \
  cf_flsbuf((unsigned)(x),p))

#define cfclearerr(p) ((p)->_flag &= ~(cf_IOERR|cf_IOEOF))
#define cfgetchar()   cfgetc(cfstdin)
#define cfputchar(x)  cfputc(x,cfstdout)
#define cffeof(p)     (((p)->_flag&cf_IOEOF)!=0)
#define cfferror(p)   (((p)->_flag&cf_IOERR)!=0)
#define cffileno(p)   (cf_filelist[(p)->_file])

int    cf_filbuf(cfFILE*);
int    cf_flsbuf(unsigned, cfFILE*);
int    cffclose(cfFILE*);
cfFILE*  cffdopen(void *, char*);
int    cffflush(cfFILE*);
int    cffgetc(cfFILE*);
char*  cffgets(char*, int, cfFILE *);
cfFILE*  cffopen(char*, char*);
int    cffputc(int, cfFILE*);
int    cffputs(char*, cfFILE*);
int    cffread(void*, int, int, cfFILE*);
cfFILE*  cffreopen(char*, char*, cfFILE*);
int    cffseek(cfFILE*, long, int);
long   cfftell(cfFILE *);
int    cffwrite(void*, int, int, cfFILE*);
char*  cfgets(char*);
int    cfgetw(cfFILE*);
int    cfputs(char*);
int    cfputw(int, cfFILE*);
void   cfrewind(cfFILE*);
int    cfsetbuf(cfFILE*, char*);
int    cfsetbuffer(cfFILE*, char*, int);
int    cfsetlinebuf(cfFILE*);
int    cfsetvbuf(cfFILE*, char*, int, int);
int    cfungetc(int, cfFILE*);

int	cfprintf(const char *fmt, ...);
int cffprintf(cfFILE *iop, const char *fmt, ...);
int cfsprintf(char *str, const char *fmt, ...);
int cfvprintf(const char *fmt, char *args);
int cfvfprintf(cfFILE *iop, const char *fmt, char *args);
int cfvsprintf(char *str, const char *fmt, char *args);

int cfsscanf(char *str, const char *fmt, ...);
int cfvsscanf(char *str, const char *fmt, char **args);
int cffscanf(cfFILE *iop, const char *fmt, ...);
int cfvfscanf(cfFILE *iop, const char *fmt, char **args);
int cfscanf(const char *fmt, ...);
int cfvscanf(const char *fmt, char **args);


void cfinit(char *appname, int lbufpages, char *permfile);
void cfexit();
void cfport_settestflags(int flags);

void cfhash(const void *keyptr, int keysize, CAT *cat);
long cfrdwr_object(void *handle, void *userbuffer, long amount, int mode);
long cfseek(void *handle, long amount, int mode);

int cfkeycmp (void *keya, int lena, void *keyb, int lenb);
int cflexical_keycmp (void *keya, int lena, void *keyb, int lenb);
int cfitemcmp(void *itema, void *itemb);

void cfprintbitmaps(void *something);
void cfprintentries(void *something);
void *cfopen(char *path, long mode, void *info);
void *cfsubopen(void *handle, char *name, long mode, void *info);
void *cfopen_chunk(void *handle, void *item);
void *cfmake_chunk(void *handle, void *key , int keylen, int chunksize);
void *cfdup(void *handle);
void *cfreopen(void *handle);

void cfclose(void *handle);
int cfunlink(void *something, ... );
int cfstat(void *something, void *stbuf);
int cfsubstat(void *handle, char *name, void *stbuf);
void *cfcopy(void *something_dst, void *something_src);
long cfcopy_file(void *handle_dst, void *handle_src);
int cfcopy_object(void *handle_dst, void *handle_src);
void cftotalloc(void *something, unsigned long *used, unsigned long *alloc);
void *cflocalize(void *handle, void *item);
void cfrelease(void *ptr, long mode);

#define cfread(a,b,c) \
cfrdwr_object(a,b,c,S_READBLK)
#define cfwrite(a,b,c) \
cfrdwr_object(a,b,c,S_WRITEBLK)

int cfdef(char *key, char *def);
int cfsysdef(char *key, char *def);
int cfappdef(char *key, char *def);
int cfundef(char *key);
int cfsysundef(char *key); 
int cfappundef(char *key);
int cftrn(char *strn, char **newstrn);
int cfpathtrn(char *strn, char **newstrn);
void cfflush(void *handle);
void cfsync(void);
int cftruncate(void *something, unsigned long size);
int cfrename(const char *oldname, const char *newname);
int cfrekey(void *oldhd, void *oldkey, int oldkeylen, void *newhd, void *newkey, int newkeylen);

int cfinsertx(void *handle,void *key,int len,void *item,int dups,void *adup);
#define cfinsert(handle,keyptr,keylen,itemptr) \
cfinsertx(handle,keyptr,keylen,itemptr,NODUPS,NULL)
#define cfinsert_dupnum(handle,keyptr,keylen,itemptr,dupnum) \
cfinsertx(handle,keyptr,keylen,itemptr,OKDUPS,dupnum)
#define cfinsert_dupname(handle,keyptr,keylen,itemptr,dupname) \
cfinsertx(handle,keyptr,keylen,itemptr,DUPNAMES,dupname)

int cfqget(void *handle, void *keyptr, int keylen, void *bufptr, int buflen);
int cfqfind(void *handle, void *keyptr, int keylen, Item *keyi, Item *dati);
int cfqfindkey(void *handle, void *keyptr, int keylen, Item *keyi);
int cfqfinddat(void *handle, void *keyptr, int keylen, Item *dati);
int cffindx(void *handle, void *keyptr, int keylen, void *itemptr, void *adup);
#define cffind(handle,key,len,item) \
cffindx(handle,key,len,item,NULL)
#define cffind_dupnum(handle,key,len,item,dupnum) \
cffindx(handle,key,len,item,dupnum)
#define cffind_dupname(handle,dupname,itemptr) \
cffindx(handle,dupname,8,itemptr,(void *)0xffffffff)
#define cfreinsert(handle,key,len,item) \
cffindx(handle,key,-len,item,NULL)
#define cfreinsert_dupnum(handle,key,len,item,dupnum) \
cffindx(handle,key,-len,item,dupnum)
#define cfreinsert_dupname(handle,key,len,itemptr,dupname) \
cffindx(handle,dupname,-8,itemptr,(void *)0xffffffff)

int cffind_item(void *handle, void *key, int keylen, void *itemptr);
int cffind_mark(void *handle, void *itemptr);

#define cfdelete(a,b,c) \
cfdelete_item(a,b,c,NULL)
int cfdelete_item(void *handle, void *key, int keylen, void *itemptr);
int cfdelete_dupnum(void *handle, void *key, int keylen, long dupnum);
#define cfdelete_lastdupnum(a,b,c) \
cfdelete_dupnum(a,b,c,-1)
int cfdelete_dupname(void *handle, void *key, int keylen, void *dupname);
int cfdelete_lastdupname(void *handle, void *key, int keylen);
int cfdelete_alldupnames(void *handle, void *key, int keylen);
int cfdelete_alldupnums(void *handle, void *key, int keylen);
int cflastdupname(void *handle, void *key, int keylen, void *dupname);

long cfpush_item(void *handle, void *itemptr);
long cfpush_value(void *handle, unsigned long *value);
long cfpush_data(void *handle, void *datptr, int datsize);
long cfpop_item(void *handle, void *itemptr);
long cfpop_value(void *handle, unsigned long *value);
long cfpop_data(void *handle, void *datptr, int datsize);
long cfstackdepth(void *handle);

long cfcountdups(void *handle, void *key, int keylen);
long cfmisc(void *something, int func, ...);

void *cfopendir(void *path);
void cfclosedir(void *it);
CFDIRENT *cfreaddir(void *it);
CFDIRENT *cfreadfulldir(void *it);
void cfrewinddir(void *it);
void cftelldir(void *it, STOR *entry);
void cfseekdir(void *it, STOR *entry);
long cfentrycnt(void *something);
long cffilesize(void *something);

int cfseq_dupnum(void *handle, void *key, int len, void *itemptr, int mode);
#define cfhead_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_HEAD)
#define cftail_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_TAIL)
#define cfnext_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_NEXT)
#define cfprev_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_PREV)

int cfseq_dupname(void *handle, void *key, int len, void *itemptr, int mode);
#define cfhead_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_HEAD)
#define cftail_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_TAIL)
#define cfnext_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_NEXT)
#define cfprev_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_PREV)


#define cfdepth(a) \
cfmisc(a, CF_DEPTH)
#define cfmark(a) \
cfmisc(a, CF_MARK)
#define cfhead(a,b) \
cfmisc(a, CF_HEAD, b)
#define cftail(a,b) \
cfmisc(a, CF_TAIL, b)
#define cfnext(a,b) \
cfmisc(a, CF_NEXT, b)
#define cfprev(a,b) \
cfmisc(a, CF_PREV, b)
#define cfkeylen(a,b) \
cfmisc(a, CF_KEYLEN, b)
#define cfdatalen(a,b) \
cfmisc(a, CF_DATALEN, b)
#define cfbytesused(a) \
cfmisc(a, CF_USED)
#define cfbytesalloc(a) \
cfmisc(a, CF_ALLOC)
#define cfmodbufs(a) \
cfmisc(NULL, CF_MODBUFS, a)
#define cfcurbufs() \
cfmisc(NULL, CF_CURBUFS)
#define cfsetkeycmp(a,b) \
cfmisc(a, CF_SETKEYCMP, b)
#define cfsetitemcmp(a,b) \
cfmisc(a, CF_SETITEMCMP, b)
#define cfseterrfunc(a) \
cfmisc(NULL, CF_SETERRFUNC, a)
#define cfsetprintfunc(a) \
cfmisc(NULL, CF_SETPRINTFUNC, a)
#define cfisnew(a) \
cfmisc(a,CF_ISNEW)
#define cfsetverylazy(a) \
cfmisc(a, CF_LAZY)
#define cfsetlazy(a) \
cfmisc(a, CF_VERYLAZY)
#define cfclrlazy(a) \
cfmisc(a, CF_CLRLAZY)
#define cffilealloc(a) \
cfmisc(a, CF_FILEALLOC)
#define cfprealloc(a) \
cfmisc(a, CF_PREALLOC)
#define cfalignment(a) \
cfmisc(a, CF_ALIGNMENT)
#define cfmapsize(a) \
cfmisc(a, CF_MAPSIZE)
#define cfissorted(a) \
cfmisc(a, CF_ISSORTED)
#define cfkey(ccb,key,len) \
cfmisc(ccb, CF_KEY, key, len)
#define cfitem(ccb, item) \
cfmisc(ccb, CF_ITEM, item)
#define cfdata(ccb, buf, len) \
cfmisc(ccb, CF_DATA, buf, len)

void cfpflags(char *name, void *handle);
long cfobtype(void *handle);
void *cfgetspace(void *handle, long amount, void *addr);
int cfretspace(void *handle, void *addr);

void *cfputx(void *handle, void *keyptr, int keylen, void *itemptr,
					int dupflg, void *adup, void *bufptr, long buflen);
#define cfput(handle,key,len,buf,buflen,itemptr) \
cfputx(handle,key,len,itemptr,NODUPS,NULL,buf,buflen)
#define cfput_dupnum(handle,key,len,buf,buflen,itemptr,dupnum) \
cfputx(handle,key,len,itemptr,OKDUPS,dupnum,buf,buflen)
#define cfput_dupname(handle,key,len,buf,buflen,itemptr,dupname) \
cfputx(handle,key,len,itemptr,DUPNAMES,dupname,buf,buflen)
#define cfreput(handle,key,len,buf,buflen,itemptr) \
cfputx(handle,key,len,itemptr,NODUPS,NULL,buf,-buflen)
#define cfreput_dupnum(handle,key,len,buf,buflen,itemptr,dupnum) \
cfputx(handle,key,len,itemptr,OKDUPS,dupnum,buf,-buflen)
#define cfreput_dupname(handle,key,len,buf,buflen,itemptr,dupname) \
cfputx(handle,key,len,itemptr,DUPNAMES,dupname,buf,-buflen)


int cfgetx(void *handle, void *keyptr, int keylen,
					void *bufptr, long buflen, void *adup);
#define cfget(handle,key,len,buf,buflen) \
cfgetx(handle,key,len,buf,buflen,NULL)
#define cfget_dupnum(handle,key,len,buf,buflen,dupnum) \
cfgetx(handle,key,len,buf,buflen,dupnum)
#define cfget_dupname(handle,dupname,buf,buflen) \
cfgetx(handle,dupname,8,buf,buflen,(void *)0xffffffff)
int cfchdir(char *);
void cfgetcwd(char *cwd, int size);
int cfdozip(void *, int, void *, int, int);
#define cfzip(dst,dsize,src,ssize) \
cfdozip(dst,dsize,src,ssize,0)
#define cfunzip(dst,dsize,src,ssize) \
cfdozip(dst,dsize,src,ssize,-1)


void *malloc(size_t);
void free(void *);
unsigned mallocsize(const void *);

#if 0 /* some include files use size_t for these functions */
void *calloc(unsigned, unsigned);
void *realloc(void *, unsigned);
void *memalign(unsigned, unsigned);
void *valloc(unsigned);
#endif

void *mallocC(long, unsigned);
void *callocC(long, unsigned, unsigned);
void *reallocC(long, void *, unsigned);
void *vallocC(long, unsigned);
void *memalignC(long, unsigned, unsigned);
void freeC(long, void *);
void freecat(long);
void *cfmalloc(unsigned, STOR *);
void cffree(STOR *);

/* DEFINITIONS FOR THE INTERNAL COPY OF DLD */
/* Error codes */

#define DLD_ENOFILE	1	    /* cannot open file */
#define DLD_EBADMAGIC	2	    /* bad magic number */
#define DLD_EBADHEADER	3	    /* failure reading header */
#define DLD_ENOTEXT	4	    /* premature eof in text section */
#define DLD_ENOSYMBOLS	5	    /* premature end of file in symbols */
#define DLD_ENOSTRINGS	6	    /* bad string table */
#define DLD_ENOTXTRELOC	7	    /* premature eof in text relocation */
#define DLD_ENODATA	8	    /* premature eof in data section */
#define DLD_ENODATRELOC	9	    /* premature eof in data relocation */
#define DLD_EMULTDEFS	10	    /* multiple definitions of symbol */
#define DLD_EBADLIBRARY	11	    /* malformed library archive */
#define DLD_EBADCOMMON	12	    /* common block not supported */
#define DLD_EBADOBJECT	13	    /* malformed input file (not rel or
				       archive) */
#define DLD_EBADRELOC	14	    /* bad relocation info */
#define DLD_ENOMEMORY	15	    /* virtual memory exhausted */
#define DLD_EUNDEFSYM	16	    /* undefined symbol */

extern int dld_errno;		    /* error code returned by dld */
extern int dld_undefined_sym_count; /* # of undefined global symbols */

extern int dld_init ();		    /* initialize the dld routines */
extern int dld_link ();		    /* dynamically link and load an object
				       file */
extern void *
dld_get_symbol ();		    /* return the address of the named
				       identifier  */
extern void *
dld_get_func ();		    /* return the address of the named
					       function */
extern void *
dld_get_bare_symbol ();		    /* same as dld_get_symbol except that
						       no underscore (_) is prepended.  Use
						       to locate symbols defined by
						       assembly routines. */
extern int dld_unlink_by_file ();   /* unlink a file */
extern int dld_unlink_by_symbol (); /* unlink the module that defines the
							       given symbol */

extern int
dld_function_executable_p ();	    /* return true if the named C function
							       is executable */

extern char **
dld_list_undefined_sym ();	    /* return an array of undefined symbols */

extern char *
dld_find_executable ();		    /* return the full path name of the
						       given executable file. */

extern int
dld_create_reference ();	    /* explicitly create a reference to the
				       given symbol. */

extern int dld_define_sym ();	    /* explicitly define the value for the
				       given symbol. */

extern void
dld_remove_defined_symbol ();	    /* remove a explicitly defined symbol */

extern void dld_perror ();	    /* print error messages. */

extern void dld_demand_load();	/* define all undefined symbols
									with negative numbers */

extern void dld_use_library();	/* add a filename for undefined symbol
									search */

extern void dld_nouse_library();	/* remove a library from the search list */

extern void  *dld_resolve_symbol();	/* resolve one of the demand loadable undefs */

extern void dld_trace();		/* set the trace level */

extern char *dld_symname();		/* return name of a demand loadable undef */

extern void *dld_rename_symbol(char *old, char *new);

extern int dld_rename_file(char *old, char *new);

extern void dld_lib_check(int dynlink);	/* force search of library list */

extern void dld_load_symb(char *symb, int dynlink);

extern int dld_scan_file(void *fhandle, void *thandle);

extern void dld_oxset_libtype(int type);

extern void dld_oxset_libnum(int libnum);

extern void dld_oxload_thunk(int thunknum);

extern int dld_oxprep_thunk(char *symb);

typedef struct {
	void *pad;
	char *name;
	long value;
} dldSymbol;

/* PATTERN MATCH FLAGS */
#define P_LEADING_DOT	(0x1)
#define P_IS_PATH		(0x2)
#define P_PAT_PATH		(0x4)
#define P_USES_ESCAPES	(0x8)
#define P_PCDOS			(0x10)

int pattern_match (char *pattern, char *string, int flags);
int check_for_pattern(char *cp, int flags);

/* CTYPE DEFINITIONS */
   
#define _mU (0x01)
#define _mL (0x02)
#define _mN (0x04)
#define _mX (0x08)
#define _mS (0x10)
#define _mP (0x20)
#define _mC (0x40)
#define _mB (0x80)

extern  unsigned char      cfctype[];
   
#define isalpha(c)  (cfctype[(unsigned char) c]&(_mU|_mL))
#define isupper(c)  (cfctype[(unsigned char) c]&_mU)
#define islower(c)  (cfctype[(unsigned char) c]&_mL)
#define isdigit(c)  (cfctype[(unsigned char) c]&_mN)
#define isxdigit(c) (cfctype[(unsigned char) c]&(_mX|_mN))
#define isspace(c)  (cfctype[(unsigned char) c]&_mS)
#define ispunct(c)  (cfctype[(unsigned char) c]&_mP)
#define isalnum(c)  (cfctype[(unsigned char) c]&(_mU|_mL|_mN))
#define isprint(c)  (cfctype[(unsigned char) c]&(_mP|_mU|_mL|_mN|_mB))
#define isgraph(c)  (cfctype[(unsigned char) c]&(_mP|_mU|_mL|_mN))
#define iscntrl(c)  (cfctype[(unsigned char) c]&_mC)
#define isascii(c)  ((unsigned char)(c)<=(0x7f))

#define toupper(c)  ({unsigned char _c = (unsigned char)(c); islower(_c) ? (_c-32) : _c; })
#define tolower(c)  ({unsigned char _c = (unsigned char)(c); isupper(_c) ? (_c+32) : _c; })
#define toascii(c)  ((c)&(0x7f))

#ifdef __cplusplus
}
#endif

