/*** dpmi.h ***/

#define CALL_DPMI   0x31

/* DPMI Functions */

#define DPMI__ALLOCDOS   0x0100  /* Allocate DOS memory */
#define DPMI__FREEDOS    0x0101  /* Free DOS memory */
#define DPMI__GETRMVEC   0x0200  /* Get Real Mode Vector  */
#define DPMI__SETRMVEC   0x0201  /* Set Real Mode Vector  */
#define DPMI__GETPMVEC   0x0204  /* Get Prot Mode Vector  */
#define DPMI__SETPMVEC   0x0205  /* Set Prot Mode Vector  */
#define DPMI__SIMRMINT   0x0300  /* Simulate Real Mode Interrupt */
#define DPMI__RMCALL     0x0301  /* Call real mode procedure     */
#define DPMI__RMINT      0x0302  /* Call real mode interrupt svc */
#define DPMI__ALLOCRMC   0x0303  /* Allocate Real Mode Callback  */
#define DPMI__FREERMC    0x0304  /* Free Real Mode Callback */
#define DPMI__GETVERSION 0x0400  /* Get DPMI version */

#define DPMI__DETECT     0x1687  /* real mode function to detect DPMI */

typedef struct RMCStag           /* Real Mode Call Structure */
    {
    unsigned long _edi_;     /*  0/00 */
    unsigned long _esi_;     /*  4/00 */
    unsigned long _ebp_;     /*  8/00 */
    unsigned long _reserved; /* 12/00 */
    unsigned long _ebx_;     /* 16/00 */
    unsigned long _edx_;     /* 20/00 */
    unsigned long _ecx_;     /* 24/00 */
    unsigned long _eax_;     /* 28/00 */
    unsigned short _flags_;  /* 32/00 */
    unsigned short _es_;     /* 34/00 */
    unsigned short _ds_;     /* 36/00 */
    unsigned short _fs_;     /* 38/00 */
    unsigned short _gs_;     /* 40/00 */
    unsigned short _ip_;     /* 42/00 */
    unsigned short _cs_;     /* 44/00 */
    unsigned short _sp_;     /* 46/00 */
    unsigned short _ss_;     /* 48/00 */
    } RMCStype;

; /*&
;
CALL_DPMI        equ   31h
;
DPMI__ALLOCDOS   equ 0100h        ; Allocate DOS memory
DPMI__FREEDOS    equ 0101h        ; Free DOS memory
DPMI__GETRMVEC   equ 0200h        ; Get Real Mode Vector
DPMI__SETRMVEC   equ 0201h        ; Set Real Mode Vector
DPMI__GETPMVEC   equ 0204h        ; Get Prot Mode Vector
DPMI__SETPMVEC   equ 0205h        ; Set Prot Mode Vector
DPMI__SIMRMINT   equ 0300h        ; Simulate Real Mode Interrupt
DPMI__RMCALL     equ 0301h        ; Call real mode procedure
DPMI__RMINT      equ 0302h        ; Call real mode interrupt svc
DPMI__ALLOCRMC   equ 0303h        ; Allocate Real Mode Callback
DPMI__FREERMC    equ 0304h        ; Free Real Mode Callback
DPMI__GETVERSION equ 0400h        ; Get DPMI version
;
RMCStype STRUC
rmcs_edi  dd ?   ;  0/00
rmcs_esi  dd ?   ;  4/04
rmcs_ebp  dd ?   ;  8/08
rmcs_reserved dd ?; 12/0C
rmcs_ebx  dd ?   ; 16/10
rmcs_edx  dd ?   ; 20/14
rmcs_ecx  dd ?   ; 24/18
rmcs_eax  dd ?   ; 28/1C
rmcs_flags dw ?  ; 32/20
rmcs_es   dw ?   ; 34/22
rmcs_ds   dw ?   ; 36/24
rmcs_fs  dw ?    ; 38/26
rmcs_gs  dw ?    ; 40/28
rmcs_ip  dw ?    ; 42/2A
rmcs_cs  dw ?    ; 44/2C
rmcs_sp  dw ?    ; 46/2E
rmcs_ss dw ?     ; 48/30
              ; 50/32 (total)
RMCStype ENDS

rmcs_di equ word ptr rmcs_edi
rmcs_si equ word ptr rmcs_esi
rmcs_bp equ word ptr rmcs_ebp
rmcs_bx equ word ptr rmcs_ebx
rmcs_dx equ word ptr rmcs_edx
rmcs_cx equ word ptr rmcs_ecx
rmcs_ax equ word ptr rmcs_eax
rmcs_fl equ word ptr rmcs_flags

rmcs_bl equ byte ptr rmcs_bx
rmcs_bh equ byte ptr rmcs_bl+1
rmcs_dl equ byte ptr rmcs_dx
rmcs_dh equ byte ptr rmcs_dl+1
rmcs_cl equ byte ptr rmcs_cx
rmcs_ch equ byte ptr rmcs_cl+1
rmcs_al equ byte ptr rmcs_ax
rmcs_ah equ byte ptr rmcs_al+1

; */
