/*
**  spawn.c (11/07/95)
**
**  Spawns "DOOR.EXE", and verifies that the PIC and the UART
**  interrupt enable register, UART line control, and UART modem
**  control registers are restored to their state before spawning.
**
**  If you allocate dynamic memory (malloc) in a door program, be
**  sure to free the memory before exiting.
*/

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include "pcl4c.h"

#define FALSE 0
#define TRUE !FALSE
#define CTLZ 0x1a

/*** Global Variables ***/

static int Port = COM1;          /* Port COM1 */
static int BaudCode = Baud2400;  /* baud rate code */
static char RxBuffer[128+16];    /* 128 byte buffer */
static char TxBuffer[128+16];    /* 128 byte buffer */

/*** local prototypes */

int BaudMatch(char *);
int ErrorCheck(int);

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i, rc;
 char far *Ptr;
 int  Seg;
 if(argc!=2)
   {printf("Usage: SPAWN <port> \n");
    exit(1);
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20))
     {printf("SPAWN: Port must be COM1 to COM20\n");
      exit(1);
     }
 /* setup 128 byte receive buffer */
 Ptr = (char far *)RxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioRxBuf(Port,Seg,Size128);
 /* setup 128 byte transmit buffer */
 Ptr = (char far *)TxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioTxBuf(Port,Seg,Size128);
 printf("SPAWN: Starting...\n");
 SioRxBuf(Port,Seg,Size128);
 /* set port parmameters */
 ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
 /* reset the port */
 ErrorCheck( SioReset(Port,BaudCode) );
 /* set DTR and RTS */
 ErrorCheck( SioDTR(Port,'S') );
 ErrorCheck( SioRTS(Port,'S') );
 printf("\nSPAWN: Type '$' to spawn DOOR.EXE\n");
 printf("SPAWN: Type ^Z to exit\n\n");
 /* enter terminal loop */
 while(TRUE)
     {/* was key pressed ? */
      if(kbhit())
          {i = getch();
           if((char)i==CTLZ)
              {/* restore COM port status & exit */
               SioDone(Port);
               printf("SPAWN: Exiting...\n");
               exit(0);
              }
           else if((char)i=='$')
              {/* spawn DOOR.EXE */
               printf("SPAWN: Spawning DOOR [DTR=%d]\n",SioDTR(Port,'R') );
               if(spawnl(P_WAIT,"DOOR.EXE","DOOR",argv[1],NULL)==-1)
                  {printf("SPAWN: Cannot spawn DOOR.EXE\n");
                   SioDone(Port);
                   exit(1);
                  }
               printf("SPAWN: Returned from DOOR [DTR=%d]\n",SioDTR(Port,'R') );
              }
           else SioPutc(Port,(char)i);
          } /* end if */
      /* any incoming over serial port ? */
      i = SioGetc(Port,0);
      if(i>-1) putch((char)i);
     } /* end while */
} /* end main */

int ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {SioError(Code);
      SioDone(Port);
      exit(1);
     }
 return(0);
} /* end ErrorCheck */
