/* 
**  TESTER.C
**
**  Connect to another machine using a null-modem cable
**  in order to test throughput. The other side should
**  echo back everything it receives.
**
**  You should boot to DOS before running this test since 
**  Windows interfers with timing.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "pcl4c.h"

char Temp[80];
int Port;
int BaudCode;
char *BaudRate[10] =  {"0","300","1200","2400","4800","9600",
                       "19200","38400","57600","115200"};
char *UartString[4] = {"8250/16450", "16550", "16650", "16750"};
char RxBuffer[1024+16];
char TxBuffer[1024+16];

int ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {printf("ERROR %d:",Code);
      SioError(Code);
      SioDone(Port);
      exit(1);
     }
 return(0);
}

int BaudMatch(char *P)
{int i;
 /* find baud rate in table */
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],P)==0) return(i);
 return(-1);
}

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i;
 int  x;
 char far *Ptr;
 int  Seg; 
 int  Psize;
 long TrueCPS;
 long TimeMark1;
 long TimeMark2;
 long Delta;
 
 /* process args */
 if(argc!=4)
   {printf("Usage: TESTER <port> <baud> <psize>\n");
    return;
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20))
     {printf("Port must be COM1 to COM20\n");
      exit(1);
     } 
 /* get baud rate from command line */
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode<0)
     {printf("Cannot recognize baud rate = %s\n",argv[2]);
      exit(1);
     }
 /* get packet size from command line */
 Psize = atoi(argv[3]);
 /* too small ? */
 if(Psize < 1) 
   {printf("ERROR: Packet size = %d is too small\n", Psize);
    exit(1);
   }
 /* too big ? */  
 if(Psize >1024) 
   {printf("ERROR: Packet size = %d is too large\n", Psize);
    exit(1);
   }
 /* setup 1024 byte receive buffer */
 Ptr = (char far *)RxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 ErrorCheck( SioRxBuf(Port,Seg,Size1024) );
 /* setup 1024 byte transmit buffer */
 Ptr = (char far *)TxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 ErrorCheck( SioTxBuf(Port,Seg,Size1024) );
 /* set port parmameters */
 ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
 /* reset the port */
 ErrorCheck( SioReset(Port,BaudCode) );
 /* set DTR and RTS */
 ErrorCheck( SioDTR(Port,'S') );
 ErrorCheck( SioRTS(Port,'S') );
#if 0 
 /* set RTS/CTS flow control. */
 ErrorCheck( SioFlow(Port,18) );
 puts("Flow control on");
#endif 
 /* Set FIFO level */
 i = SioFIFO(Port,LEVEL_4TH);
 printf("[%s]\n",UartString[i]);

#if 0 
 /* other side should have raised their DTR */
 if(!SioDSR(Port))
   {printf("ERROR: DSR not detected. Start other side 1st\n");
    SioDone(Port);
    exit(1);
   }   
 /* other size should have raised their RTS */  
 if(!SioCTS(Port))
  {printf("ERROR: CTS not detected. Start other side 1st\n");
   SioDone(Port);
   exit(1);
  }  
#endif

 SioRxClear(Port);
 SioTxClear(Port);
 printf("TESTER: Port = COM%1d, Baud Rate = %s, Packet Size = %d\n",
        Port+1,BaudRate[BaudCode],Psize);  
 if(SioInfo('I')) printf("TX interrupts are enabled.\n");
 else printf("TX interrupts are NOT enabled.\n");
 /* start test */
 printf("Sending packet & waiting for return echo...");
 TimeMark1 = SioTimer();
 for(i=0;i<Psize;i++) SioPutc(Port, (char)('A' + (i%26)) );
 /* wait for response */
 i = 0;
 while(i < Psize)
   {x = SioGetc(Port, 18);
    if(x < 0) ErrorCheck(x);
    if(x >= 0) 
      {/* received byte */
       c = (char)x;
       if(c!=('A' + (i%26)))
         {printf("Error: Index = %d, Received = %c [%xH], Expected = %c\n", 
               i,c,x,'A' + (i%26));
          SioDone(Port);     
          exit(1);     
         }
       /* received correct character */
       i++;
      }
   }
 /* all done */
 printf("\n");
 TimeMark2 = SioTimer();
 Delta = TimeMark2 - TimeMark1;
 if(Delta>0)
   {TrueCPS = 18 * (Psize/Delta);  
    printf("%d bytes sent and received in %ld Tics (%ld CPS)\n",
       Psize,  Delta, TrueCPS ); 
   }
 SioDone(Port);
} /* end main */

