/*
	BUF.C
	From the book "Systems Programming in Turbo C",  by Michael J. Young
*/

#include <stdio.h>
#include <process.h>
#include <alloc.h>
#include <dos.h>
#define LIBFILE
#include "buf.h"
#include "scr.h"
#include "kbd.h"

#define MAXLINES 4000
static char *LinePtAr [MAXLINES];
static int ULC, ULR, LRC, LRR;
static int LinesPerWin;
static int CharPerLine;


void BufInit (int StartCol, int StartRow, int StopCol, int StopRow)
/*
	This function initializes the buffer display system of functions
*/
{
	ULR = StartRow;					/* Save dementions of window            */
	ULC = StartCol;
	LRR = StopRow;
	LRC = StopCol;
	LinesPerWin = LRR - ULR + 1;
	CharPerLine = LRC - ULC + 2;
	LastLine = -1;					/* Initialize global variable           */
}


char *BufNextLine ()
/*
	This function adds another line to the internal buffer, and returns
	the starting address of the line.
*/
{
	int i;

	if (++LastLine >= MAXLINES)	{            /* Test for buffer size limit */
		ScrPutS("MAXLINES exceeded!", 0x46, 12, 33);
		exit(1);
	}

	if (LastLine % LinesPerWin == 0)	{    /* Time to allocate          */
		if ((LinePtAr [LastLine] =
			(char *)malloc (LinesPerWin * CharPerLine+10)) == NULL) {
			ScrPutS("Out of heap memory", 0x47, 12, 33);
			exit(1);
		}
	}
	else
		LinePtAr [LastLine] = LinePtAr [LastLine - 1] + CharPerLine;

	return (LinePtAr [LastLine]);
}


void BufShow (int StartLine, int Attr)
/*
	This function displays the buffer, beginning with the line having the
	index specified by 'StartLine'.
*/
{
	register int Line, Row;

	ScrClear (ULC, ULR, LRC, LRR);		/* First clear the window         */
	Row = ULR;

	for (Line=StartLine; Line<StartLine+LinesPerWin&&Line<=LastLine; ++Line)
		ScrPutS (LinePtAr [Line], Attr, Row++, ULC);
}


char *BufGet (int Line)
/*
	This function returns the address of buffer line number 'Line'.
*/
{
	if (Line <= LastLine)
		return (LinePtAr [Line]);
	else
		return (NULL);
}


void BufFree ()
/*
	This function frees the buffer memory.
*/
{
	int i;

	for (i=0; i<=LastLine; i += LinesPerWin)
		free (LinePtAr [i]);
}


void BufScroll(int lines, int direc, int attr)
/*
	This function scrolls an area of the screen.
*/
{
	union REGS r;

	if (direc == 0) r.h.ah = 6;	    		/* scroll up */
	else r.h.ah = 7;						/* scroll dn */

	r.h.al = lines;							/* no. of lines to scroll */
	r.h.ch = ULR;
	r.h.cl = ULC;
	r.h.dh = LRR;
	r.h.dl = LRC;
	r.h.bh = attr;							/* color */
	int86(0x10, &r, &r);
}


void downward (int line, int numlines, int Attr)
{
	line += LinesPerWin;
	BufScroll(numlines, 0, Attr);
	ScrPutS (LinePtAr [line], Attr, LRR, ULC);
}


void upward (int line, int numlines, int Attr)
{
	line--;
	BufScroll(numlines, 1, Attr);
	ScrPutS (LinePtAr [line], Attr, ULR, ULC);
}