/*
	PCPILOT.C - This is the main() module for PCPILOT.EXE.  It should be
				compiled in the small or tiny memory model.  See the
				README.1ST file for important info on compiling and
				running this program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <scr.h>
#include <kbd.h>

int BorderClr = 0x09;
int TitleClr = 0x0c;
int TextClr = 0x0f;
int FooterClr = 0x0b;
int HighlightClr = 0x4f;

int Code = 0;				/* For Ascii()       */
int BoxIdx = 0;             /* For BoxCodes()    */
int ClrIdx = 0x00;			/* For ColorCodes()  */
unsigned long NumIdx = 0L;	/* For BaseConvert() */
int Row = 0, Col = 0;       /* For Ruler()       */

void PcPilot(void);
void Initialize(void);
static int videomode(void);
void TitleScreen(void);

/*  #define DEBUG  */
char signature[] = "PC-PILOT";
extern unsigned _heaplen = 12288;
extern unsigned _stklen = 1024;
extern unsigned scancode[], keymask[];
extern int unloading;         			/* To UnInstall TSR */
void main(int argc, char *argv[])
{
	while (--argc > 0)	{
		++argv;
		if (**argv != '-')
			break;
		if (tolower(argv[0][1]) == 'x')	{
			Initialize();
			PcPilot();
			return;
		}
	}
	Initialize();
	*scancode= 76;				/* Alt(8) - '5'(76) on the keypad */
	*keymask = 8;
	tsr(PcPilot, TitleScreen);
}

typedef struct {
	char *str;
	int y;
} MENU;

MENU m[] = {
	" Ascii Table    ",  8,
	" Box Characters ",  9,
	" Hex/Dec/Binary ", 10,
	" Keyboard Codes ", 11,
	" Ruler          ", 12,
	" Color Codes    ", 13,
	" Printer Setup  ", 14,
	" Uninstall      ", 15,
	" Exit           ", 16
};

int Idx = 0;
int K;
int oldx, oldy;

static void DrawMenu(void);
static void HighLight(int code);
static void ExecuteMenuOptions(int index);

void PcPilot()
{
	ScrGetCur(&oldx, &oldy, 0);
	HideCur();
	ScrPush();
	DrawMenu();

	for (;;)	{
		HighLight(1);
		switch (K = KbdGetC())	{
			case UP:
			case LEFT:
				HighLight(0);
				if (--Idx < 0) Idx = 8;
				break;
			case DN:
			case RIGHT:
				HighLight(0);
				if (++Idx > 8) Idx = 0;
				break;
			case PGUP:
			case HOME:
				HighLight(0);
				Idx = 0;
				break;
			case PGDN:
			case END:
				HighLight(0);
				Idx = 8;
				break;
			case RET:
				if (Idx == 7 || Idx == 8)	{
					if (Idx == 7) unloading = 1;
					ScrPop(1);
					ScrSetCur(oldx, oldy, 0);
					return;
				}
				if (Idx == 4)	{
					ScrPop(1);
					Ruler();
					ScrPush();
					DrawMenu();
				}
				ExecuteMenuOptions(Idx);
				break;
			case ESC:
				ScrPop(1);
				ScrSetCur(oldx, oldy, 0);
				return;
			default:
				if ((K = K&0x00ff) != 0)	{
					if (!strchr("abhkrcpue", tolower(K))) break;
					HighLight(0);
					switch (tolower(K))	{
						case 'a': Idx = 0; break;
						case 'b': Idx = 1; break;
						case 'h': Idx = 2; break;
						case 'k': Idx = 3; break;
						case 'r': Idx = 4;
							ScrPop(1);
							Ruler();
							ScrPush();
							DrawMenu();
							break;
						case 'c': Idx = 5; break;
						case 'p': Idx = 6; break;
						case 'u': Idx = 7;
							unloading = 1;
						case 'e': Idx = 8;
								  ScrPop(1);
								  ScrSetCur(oldx, oldy, 0);
								  return;
						default : continue;
					}
					HighLight(1);
					ExecuteMenuOptions(Idx);
				}
				break;
		}
	}
}

static void DrawMenu()
{
	register int i;

	ShadowBox(31,5,48,19, 2, BorderClr);
	PutStr(32,6, TitleClr, "   PC - PILOT   ");
	PutStr(31,7, BorderClr,"͵");
	PutStr(31,17,BorderClr,"͵");
	PutStr(32,18,FooterClr," %c %c <Esc> exits", 24,25);

	for (i=0; i<9; i++)	{
		PutStr(32,8+i, TextClr, "%s", m[i].str);
		PutStr(33,8+i, FooterClr, "%c", m[i].str[1]);
	}
	HighLight(1);
}

static void HighLight(int code)
{
	switch (code)	{
		case 0:
			PutStr(32,m[Idx].y, TextClr, "%s", m[Idx].str);
			PutStr(33,m[Idx].y, FooterClr, "%c", m[Idx].str[1]);
			break;
		case 1:
			PutStr(32,m[Idx].y, ~TextClr & 0x7f, "%s", m[Idx].str);
			PutStr(33,m[Idx].y, ~FooterClr & 0x7f, "%c", m[Idx].str[1]);
			break;
	}
}

static void ExecuteMenuOptions(int index)
{
	switch (index)	{
		case 0:  Ascii(); return;
		case 1:  BoxCodes(); return;
		case 2:  BaseConvert(); return;
		case 3:  KeyCodes(); return;
		case 4:  return;
		case 5:  ColorCodes(); return;
		case 6:  PrintCodes(); return;
		case 7:  return;
	}
}

static void Initialize()
{
	int vmode;

	vmode = videomode();
	if ((vmode != 2) && (vmode != 3) && (vmode != 7))	{
		printf("Must be in 80 column text mode.\n");
		exit(1);
	}
	InitScr();
	if (VideoMode == MONO)	{
		BorderClr     = 0x0f;
		TitleClr      = 0x0f;
		TextClr       = 0x07;
		FooterClr     = 0x0f;
		HighlightClr  = 0x70;
	}
}

static int videomode()
{
	union REGS r;

	r.h.ah = 15;
	return int86(0x10, &r, &r) & 255;
}

static void TitleScreen()
{
	Cls();
	ShadowBox(18,8,59,16, 2, BorderClr);
	PutStr(19,9, TextClr,    "               PC - PILOT               ");
	PutStr(19,10, FooterClr, "           Programmer's Pop-Up          ");
	PutStr(19,12, TextClr,   "     FREEware written by Tom Grubbe     ");
	PutStr(19,13, TextClr,   " Released to the Public Domain 01-12-90 ");
	PutStr(19,15, TextClr,   "          Alt-5 (keypad)                ");
	PutStr(23,15, TitleClr,  "Press");
	PutStr(44,15, TitleClr,  "To Activate");
	ScrSetCur(0,18,0);
}