/***********************************************************/
/* Program Id.               PmnuDemo.C.                   */
/* Author.                   Stan Milam.                   */
/* Date Written.             03/12/89.                     */
/*                                                         */
/* Comments: This program demonstrates the use of the pop- */
/* up menu capabilities of PC Windows.  Use the up & down  */
/* arrow keys to change the selection. Press enter to make */
/* a selection.  Or, press 1 thru 5 to select, or use the  */
/* mouse to "point and shoot".                             */
/***********************************************************/

#include <stdio.h>
#include <pcwproto.h>
#include <menu.h>

int pmenu_demo(void) {

   WNDPTR *wnd, *savewnd, *iwnd;

/***********************************************************/
/* Initialize the popup menu structures defined in menu.h. */
/***********************************************************/

   static PMNUFLDS pitems[] = {
       { '1', "1. Methodology                   "},
       { '2', "2. Word Processors               "},
       { '3', "3. ITI Mainframe Communications  "},
       { '4', "4. C Programming Environment     "},
       { '5', "5. Pascal Programming Environment"},
       { 'e' ,"E. Esc or Right Mouse Key - Exit "},
       {  0,  ""}
    };

/**********************************************************/
/* PMNUTYPE contains elements concerning a popup menu.    */
/* First, there is a pointer to the window to be used,    */
/* then window parameters, border parms, title parms,     */
/* selection bar parms, and finally a pointer back to our */
/* menu options.                                          */
/**********************************************************/

    static PMNUTYPE  pmenu =  {
       NULL,
       13, 20, 20, 60, BLACK,LIGHTGRAY,          /* Window Parms */
       2, RED,LIGHTGRAY,                         /* Border Parms */
       " Main Menu ",TOP,MIDDLE,BLUE,LIGHTGRAY,  /* Title  Parms */
       WHITE,BLUE,0,                             /* Select Bar   */
       pitems                                    /* pointer to menu list */
    };

    static char *instructions[] = {
       "To use the  Popup  Menu  use  the  \30\31  arrow  keys,",
       "to place the cursor bar on  the  desired  selection",
       "and then press enter.  Or, use the SELECT CHARACTER",
       "at left of each selection, or...use  the  Mouse  to",
       "point and shoot the selection you want.  ESC or the",
       "right Mouse key will end the demo.                 ",
       NULL
    };

    static char *selections[] = {
       "Methodology",
       "Word Processors",
       "ITI Mainframe Communications",
       "C Programming Environment",
       "Pascal Programming Environment"
    };

    int i = 0;
    int mxr, mxc;

   chk_video_state(&mxr,&mxc);                   /* Get max rows & cols */
   savewnd = wpush(1,1,mxr,mxc);                 /* Save entire screen */
   if (!savewnd) return(3);                      /* Exit if cannot save */
   bordercolor(BLUE,LIGHTGRAY);                  /* Set border color */
   titlecolor(BLACK,LIGHTGRAY);                  /* Set the title color */
   iwnd = wexplode(2,10,11,70,RED,LIGHTGRAY);      /* Make instruction window */
   wtitle(iwnd,TOP,LEFT," Popup Menu Instructions "); /* Title it */
   w_block_write(iwnd, 2, CENTER,instructions);  /* Write instructions to it */
   wnd = makepmenu(&pmenu);                      /* Make a popup window */
   while (i != 27 && i != 'e') {                 /* Do until Esc */
      i = pmenuinput(&pmenu);                    /* Get Menu return value */
      switch(i) {
         case '1' :
         case '2' :
         case '3' :
         case '4' :
         case '5' :
            if (mpresent) hide_mouse();
            i -= 48;
            qhchar(22,1,7,BLUE,176,80);          /* Clear msg line */
            qputs(22,99,RED,7,selections[i-1]);  /* Write the choice */
            if (mpresent) show_mouse();
            break;
         default: break;
      }
   }
   if (mpresent) hide_mouse();                   /* Hide the mouse */
   wnd     = wpop(wnd);                          /* Get rid of menu */
   iwnd    = wpop(iwnd);                         /* Get rid of instructions */
   savewnd = wpop(savewnd);                      /* Restore msg row */
   return(0);                                    /* And go home */
}

