/***********************************************************/
/* File Id.                  Qputchar.C                    */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/06/88.                     */
/* Date Last Modified.                                     */
/*                                                         */
/*           (c) Copyright 1989-90 by Stan Milam           */
/*                                                         */
/* Comments:  This routine will write a character at the   */
/* specified location with the specified colors via an     */
/* assembley langauge routine.                             */
/***********************************************************/

#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

int qputchar(int row, int col, int fcolor, int bcolor, char ch) {

   int far  *scrnptr;
   unsigned offset, scrnseg;
   int attr, page, pagesize;
   int mx_rows, mx_cols;

   if (!chk_video_state(&mx_rows,&mx_cols)) return(0);
   if (row > mx_rows) return(0);
   if (col > mx_cols) return(0);
   page    = getpage();
   scrnseg = getscrnseg();
   pagesize= getpagesize();
   offset  = MK_SCRNOFF(row,col);
   attr    = MK_ATTR(fcolor,bcolor) | ch;
   scrnptr = (int far *) MK_FP(scrnseg, offset);
   Tputchar(scrnptr, attr); return(1);
}
