/***********************************************************/
/* File Id.                  Wait.C                        */
/* Author.                   Stan Milam.                   */
/* Date Written.             02/14/89.                     */
/*                                                         */
/*          (c) Copyright 1989-90 by Stan Milam            */
/*                                                         */
/* Comments: This function replaces the wsleep() functions.*/
/* it is provided to give delay capablity to all compilers */
/* using this library.  Turbo C & Power C both have the    */
/* sleep() function, in addition, Turbo C provides the     */
/* delay() function.  However, Microsoft C has no delay    */
/* type functions.                                         */
/* This function works by multiplying the argument by 18   */
/* (approximate for 18.2) and adding to it the BIOS time of*/
/* day count kept in low memory.  Then simply wait for the */
/* BIOS time of day count to catch up.                     */
/***********************************************************/

#include <dos.h>
#include "pcwproto.h"

void swait(unsigned seconds)  {

   long far *bios_count;                    /* Far pointer to BIOS count */
   long anchor, control;                    /* Our anchor point */

   bios_count = (long far *) MK_FP(0x0000,0x046C); /* Point to TOD count */

   anchor = (long) seconds * 182;           /* Clock beats 18 time a second */
   control= *bios_count * 10;
   anchor = anchor + control;

   while((*bios_count * 10) <= anchor) {    /* Wait for TOD to catch up */
      if (*bios_count * 10 < control) {     /* Adjust if midnight rollover */
         control = *bios_count * 10;        /* Occurs. */
         anchor -= 15730660L;
      }
   }
}
