/***********************************************************/
/* File Id.                  Vgetmode.C                    */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/19/88.                     */
/* Date Last Modified.                                     */
/*                                                         */
/*          (c) Copyright 1989-90 by Stan Milam            */
/*                                                         */
/* Comments:  This function will call BIOS to get the      */
/* current video mode.  It takes to pointers to type INT.  */
/* these pointer will be return the number of columns for  */
/* the current video mode if there is one, and the video   */
/* mode itself.                                            */
/***********************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "pcwproto.h"

static union REGS regs;

void vgetmode(int *cols, int *mode, int *activepage)  {

     memset(&regs,'\0',sizeof (union REGS));
     regs.x.ax = 0x0f00;
     int86(0x10,&regs,&regs);
     *cols       = regs.h.ah;
     *mode       = regs.h.al;
     *activepage = regs.h.bh;
}

/**********************************************************/
/*                        vsetmode()                      */
/*                                                        */
/* Add vsetmode() to set the video mode when I need to.   */
/**********************************************************/

void vsetmode(int mode) {

   memset(&regs,'\0', sizeof (union REGS));
   regs.h.ah = 0;
   regs.h.al = (char) mode;
   int86(0x10,&regs,&regs);
}
