/**********************************************************/
/* File Id.                  Wputs.C.                     */
/* Author.                   Stan Milam.                  */
/* Date Written.             02/27/89.                    */
/*                                                        */
/*           (c) Copyright 1989-90 by Stan Milam          */
/*                                                        */
/* Comments: This function will write a string to a spec- */
/* fied window with that window's saved color.  If the    */
/* window is overlapped it "floated" to the top. It then  */
/* becomes the active window.                             */
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

#define center (((wnd->lcol - wnd->ucol) / 2) - (wrklen / 2));
#define wrkstr PCWRKSTR

extern char wrkstr[];

int wputs(WNDPTR *wnd, int row, int col, char str[]) {

    int far  *scrnptr;
    int      page, pagesize, attr;
    int      mx_rows, mx_cols, wrklen;
    unsigned offset, scrnseg;

    if (!wnd) return(0);
    if (!chk_video_state(&mx_rows,&mx_cols)) return(0);
    if (wnd->hideflag) return(0);

    strcpy(wrkstr,str);
    wrklen = strlen(wrkstr);
    if (col == CENTER) col = center;
    row = row + wnd->urow;
    col = col + wnd->ucol;

/*****************************************************************/
/* Need to put in some code to see if string will fit into window*/
/* Truncate the string if neccessary.  Two cases, if string too  */
/* long to fit in window, or starting in a column where it will  */
/* move out of bounds.  Also need to check if the row is valid.  */
/*****************************************************************/


    if (col >= wnd->lcol) return(0);        /* Check to see if row */
    if (col <= wnd->ucol) return(0);        /* Or col out of bounds */
    if (row <= wnd->urow) return(0);
    if (row >= wnd->lrow) return(0);
    if ((wrklen + col) >= wnd->lcol)        /* If string too long then */
       wrkstr[wnd->lcol - col] = '\0';      /* truncate it.            */

    re_order(wnd, NORMAL);
    scrnseg = getscrnseg();
    page    = wnd->page;
    pagesize= getpagesize();
    offset  = MK_SCRNOFF(row,col);
    attr    = wnd->attr << 8;
    scrnptr = (int far *)MK_FP(scrnseg,offset);
    Tputs(scrnptr, (char far *) wrkstr, attr);
    return(1);
}
