#ifndef __ALLOC_H__
#define __ALLOC_H__

#include <stddef.h>

#define _HEAPOK 	0
#define _HEAPEMPTY	1	/* heap isn't initialized */
#define _HEAPBADBEGIN	2	/* heap header is corrupted */
#define _HEAPBADNODE	3	/* heap entry is corrupted */
#define _HEAPEND	4	/* end of heap entries (_heapwalk) */
#define _HEAPBADPTR	5	/* invalid heap entry pointer (_heapwalk) */

#define _USEDENTRY	0
#define _FREEENTRY	1

typedef struct {
    void   *_pentry;       /* heap pointer */
    size_t _size;          /* heap entry size */
    byte   _useflag;       /* heap entry 'in-use' flag */
} _heapinfo;

#define _HEAPINFO _heapinfo

#ifdef __cplusplus
  extern "C" {
#endif

extern void * malloc(dword);         //NULL=error
extern void * calloc(dword,dword);   //NULL=error
extern void free(void *);
extern void * realloc(void *,dword);  //FIXED : v2.00 Beta #3

extern dword coreleft(void);          //find total avail RAM

extern dword _memavl(void);           //same as coreleft()
extern dword _memmax(void);           //Return largest free block size
extern dword _memused(void);          //NEW : v2.11 Beta #2
extern dword _memtotal(void);         //NEW : v2.11 Beta #2
extern dword _heapwalk(_heapinfo *);  //NEW : v2.11 Beta #2
extern dword _heapset(uint8 fill);    //NEW : v2.11 Beta #2
extern dword _heapchk(void);          //NEW : v2.11 Beta #2
extern dword _heapfrag(void);         //NEW : v2.11 Beta #2
extern dword _memblksize(void);       //NEW : v2.11 Beta #5

#ifdef __cplusplus
  }
#endif

#define farmalloc malloc
#define farcalloc calloc
#define farfree free
#define farcoreleft coreleft

#endif
