#ifndef __COMPRESS_H__
#define __COMPRESS_H__

#define COMP_OFLOW 128  //recommended min # of bytes that dest must be larger
                        //than src on call to CompressBuffer()

/*/  Flags  /*/
#define COMP_NOSTORE     1    //force compression even if buffer gets bigger, unless dest is too small (error)
#define COMP_BLOCKSTART  2    //Start to compress a portion of a file
#define COMP_BLOCKCONT   4    //continue to compress the next block
#define COMP_BLOCKEND    8    //compress last block of a file
//When the above is used the compression routine will maintain it's hash
//  tables between calls so that you can compress a file that can not
//  fit into memory all at once.  After each call you must copy the last
//  byte in the output buffer that was not used cause it may hold some
//  un-outputed bits.  See compress.txt for more help.

/*/  Compression types  /*/
#define COMP_STORE 0      //store compression  (simply copy)
#define COMP_LZ    1      //LZ compression
//#define COMP_LZW   2      //LZW compression

extern sdword CompressBuffer(void * dest,dword dlen,void * src,dword slen,
  dword flags,dword comptype);
extern sdword DecompressBuffer(void * dest,dword dlen,void * src);
extern sdword CompressBufferSize(void * buf);    //returns size of buffer if expanded
extern void CompressSetLevel(dword lvl);    //sets compression level

#endif

