;unrem these to 'debug the debugger'? 
;debug_keys equ 1         ;shows keys as pressed in insert_key()
;debug_showexc equ 1      ;shows exceptions as they occur on screen
;debug_keymain equ 1      ;shows keys as pressed after getkey() in main loop
;debug_stacks equ 1       ;shows stacks avail.
;debug_kbd equ 1          ;shows kbd init/uninit

int_10h equ <int 10h>     ;to remove INT 10h change this to nothing

include qdebug.bld

QDEBUG_VERSION EQU <'v1.10 Fix #2'>

comment ~ 
			     
			     QDEBUG

	     DPMI Compliant Protected Mode Debugger

      This project was developed from Adam Seychell's work on DOS32.

      Original Copyright (c) Adam Seychell, James B, 1995.
      New Copyright (c) Peter Quiring, 1997, 1998. (can I do that?)

      This software is "copied" illegally from Adam, oh well
      he does not seem to be actively improving his software
      anyways.  QDebug is Freeware though so it should not
      really matter.

      See \docs\debug\newdebug.txt for version info.

		     Last Modified on Aug-Sept/97 by Peter Quiring
		       - Heavy modification to work under DPMI servers
		     Last Modified on 1st Oct 1995 by Adam S.
		     Last Modified on 11th Dec 1995 by James B.
		     Last Modified on 14th Dec 1995 by James B.
		     Last Modified on 25th Dec 1995 by James B.
		     Last Modified on 19th Mar 1996 by Adam S.
		     Last Modified on 20th Mar 1996 by James B.
		     Last Modified on 17th April 1996 by Adam S.
		     Last Modified on 27th April 1996 by Adam S.
		     Last Modified on 3 May 1996 by Adam S.
		     Last Modified on 13 May 1996 by James B

 I have released the source in the hope it will be useful and that
 if someone has made some improvments and would like to share their
 work then please send me the new copy so I can release it for next
 versions of DOS32. This source code is written in MASM 6.1 and by
 no means is it written neatly. If someone wants to write thier
 own debugger then best thing would be to use the instruction decode
 routine ( DEBUG.INC ) since this is a general routine for displaying
 486 instructions as a string. The rest of the debugger could be written
 in 32bit C/C++ and while still using ASM for the exception handlers.

 If you have written some code for the debugger or you would like to then
 please contact me by email or snail mail (see address in DOS32.DOC)
 and I will send you the latest copy of the source code so you can
 make your changes. The other option is to send me just the changes
 you have made and I'll implement them to the 'home copy' of the debugger
 source. This is to make sure that all improvments made by everyone who
 has or would like to contirbute, will released in the next version
 of DOS32.

James modification note from version 1.11 to 1.11a

The modification was based on DEBUG32 version 1.11 as released in DOS32 v3.2.
Since the modification was minor, I don't change the version, only append an
'a' to it to differentiate it from the original.

All modification are surrounded by ;***. This is not to show off that I
modify a lot of places, no at all. I do that so you can see which part is
changed and which part is not. After you have examined it, you can delete
all the marks.

Basically, this is what I've done to it:
* rewrite the key dispatcher (in Handle_Debug_Exception) using tables
  instead of direct comparison. This is to facilitate interactivity in
  each "window". Each window now has separate command keys table.
* adding a data window
  - add data display section to refresh_screen
  - change frame drawing in Debuggers_Video
* the other windows are now active: there are now 4 active windows:
  code, register, flag, data, instead of code only. Each has a set of
  context sensitive menu bar and context sensitive command keys, with some
  global keys (in shared_table).
* add interactivity to each window
  - in code window,
    + you can change the starting address of display.
    + get the true F4-Here (from turbo debugger). The original F4 is now
      renamed under Ctrl-N (New) which sets EIP from selected_line.
    + get Ctrl-O (origin): to get back the disassembly at current EIP if you
      have moved to somewhere else and get lost.
  - in register window
    + you can change the value
  - in the flag window
    + you can change set/reset/toggle the flag
  - in data window
    + you can change the offset to display
    + you can change the actual data bytes in memory
    + you can scroll up, down, page-up, page down bytes of memory.
* I have decided to change some of the key lay-out in the original DEBUG32,
  in order to match turbo debugger more closely. Sorry about that. I used TD
  very often so I think matching DEBUG32 keys to TD keys is a good idea...
  You can see the key allocation from the menu bar. It contains all the
  keys I have defined.
  Anyway, you can always change the lay-out: it is as easy as changing the
  tbl_key value in key_struct below in the command tables.

James modification note from version 1.11a to 1.11b

* Alt +,- is now a global key to inc/dec ESP by 4. That is, a global key to
  view the stack frame. Alt * will reset ESP to its most recent value.

James modification note from version 1.11b to 1.11c

* Change regs (in whatever ways) now works as expected (change jmp main_loop
  to jmp load_all_regs). Previously it has a bug: the value shown on
  screen is changed, but when stepping it uses old value (yuck!).
* Alt +,- is now a global key to change stack frame view.
  Alt + will scroll up
  Alt - will scroll down
  Alt * will reset stack frame ptr to ESP,
  Alt / will reset stack frame ptr to EBP.
  By default, after stepping stack frame ptr will be equal to ESP
  Note: Alt +,-,*,/ *no longer* affects ESP!!! You have to change ESP
  manually now.
  Note: changing any register automatically resets frame ptr to ESP!!!

Adam's change from 1.11c to 1.11d

1. Fix Numlock bug. Previously, activating Numlock will screw up keypad
   (not numeric pad) cursors handling, because each key press of keypad
   will automagically enclosed with a shift key press.
2. Make stack frame shows ss:esp and/or ss:ebp at exact location, and
   this is scrollable. Can even shows both ss:esp & ss:ebp now! (nice feature).

James's change from 1.11d to 1.11e

1. Now changing registers does not change frame ptr.
   Stepping/run program etc still do, and this is intentional.

Note to Adam:
1. I don't change the copyright name. You make most of it, I only add some
   infinitesimal cosmetics...I just don't deserve a place there. I am content
   enough if you can put my name in contributors' list.
   (But of course if you think differently and want to put my name in the
   copyright section, I would feel very honored.... :)

2. I will not distribute the modified version to public domain by myself.
   Rather, I submit this modification to you so that you can organize them and
   publish them with the next version of DOS32. In this way, there is only
   one authoritative version of DOS32, and there is  only one authorized
   source: Adam Seychell (thanks for the great product! :).

Adam:   v1.11f

* Improved print_message_box procedure to handle multiple lines.
  Uses character 10 for a new line.
* changed debugger intro message to list contributors.
* converted all symbols to case matching.
* made DECODE.ASM into a module.
* changed makefile to produce a LIB
* defined multiple symbol names that can be used to execute the debugger.
  eg.  Debug, debug, DEBUG, _debug, _Debug,, ect...



Adam:   v1.11g

* started setting up for FPU windows.
* coded routine to print 80bit extended precision floating point real
  numbers. This was not an easy task. See the routine for your self and
  you'll relize the trouble I must of went through. It took me a week
  to complete.
* made new macros for FPU instruction definitions for the instruction
  decode routines. filles in first three FPU instructions


Adam:   v1.11h

* made code window screen draw line to and from jump instructions.
  only draws if jump condition is true

James:   v1.11i

* coded an alternative 80-bit printer. The accuracy is only 17-digits, though 
  (out of 19-digits possible). It uses log & antilog algorithms.
* correct tag word meaning. tag word is *not* aligned with st0 etc in fpu_envir!!
* eliminate several references to i variable.
* eliminate residual chars when printing "empty" (just add more spaces)
* todo: - make segment reg window active (is this useful? in flat mode, we
	  are not supposed to use (or change) segment very often...)
	- make fpu reg window active (this will need a float_input, and will
	  be impossible without input window dialog box (or something like that)
* known bug not yet fixed:
  - see BUGS.TXT


Adam:   v1.11j

* fixed jumping line bug with the instructions JECXZ, LOOPZ, LOOPNZ and
   Jxx near displacements.
* Stoped instruction pointer from going below the program loading address
  for DOS32 Versions 3.5+. This will stop page faulting in the debugger
  trying to 'look' at non valid memory.
* included the non 387+ fpu instructions, fdidi, feni, fsetpm, frspm
* made decode routine diaplay fpu memory operand size.
* fixed fstp st(i)  display, The Intel Microprocessors Vol I & II
  have a error in their opcode table for this instruction.


Adam:   v1.11k

* fixed bug in print_float2 routine. Now displays floats OK.
* put feature to set data window offset to current memory operand
  by pressing Shift+Space when in code window.

~


OPTION OLDSTRUCTS
.386p
.387
;.mmx   ;Requires MASM v6.12+ (not need - I just placed in DB for EMMS)
;                             (so I can still use MASM v6.11 under DOS)
.MODEL FLAT,c
assume fs:flat,gs:flat

.stack  ;default 1k stack

.data
_i3here db ON
_show_mmx db FALSE

mm0_symb db 'mm0  $'
mm1_symb db 'mm1  $'
mm2_symb db 'mm2  $'
mm3_symb db 'mm3  $'
mm4_symb db 'mm4  $'
mm5_symb db 'mm5  $'
mm6_symb db 'mm6  $'
mm7_symb db 'mm7  $'

ST0_symb db 'st(0)$'
ST1_symb db 'st(1)$'
ST2_symb db 'st(2)$'
ST3_symb db 'st(3)$'
ST4_symb db 'st(4)$'
ST5_symb db 'st(5)$'
ST6_symb db 'st(6)$'
ST7_symb db 'st(7)$'
EAX_symb db 'eax$'
ECX_symb db 'ecx$'
EDX_symb db 'edx$'
EBX_symb db 'ebx$'
ESP_symb db 'esp$'
EBP_symb db 'ebp$'
ESI_symb db 'esi$'
EDI_symb db 'edi$'
EIP_symb db 'eip$'
ES_symb db 'es$ '
CS_symb db 'cs$ '
SS_symb db 'ss$ '
DS_symb db 'ds$ '
FS_symb db 'fs$ '
GS_symb db 'gs$ '
db '??$ '
db '??$ '

include debug.inc   ; This is the instruction decoding routine

include keys.inc  ; this file holds key scan code definition
SHF EQU 4           ; artificial KB flag used in Handle_Debug_Exception
CTL EQU 2           ;
ALT EQU 1           ;
NONE EQU 0          ;

CODE_W EQU 0              ;do not change this!!! The code depends on the value.
REGS_W EQU 1              ;used in which_window variable
FLAG_W EQU 2              ;
DATA_W EQU 3              ;
DRx_W EQU 32
STx_W EQU 33
;***

CODE_WINDOW_WIDTH EQU 46
CODE_WINDOW_HEIGHT EQU 39

ScreenHeight EQU 50
ScreenWidth EQU 80
boarder_color EQU 3fh
back_color EQU 3fh
back_color_EA EQU 03fh
selected_color EQU 1fh
selected_brkpt_color EQU 0dfh
brkpt_color EQU 4fh
registers_color EQU 30h
base_addr_color EQU 38h
RegistersHiLight_color EQU 34h
menu_color EQU 70h
menu_color1 EQU 78h
heading_color EQU 3bh
SS_EBP_stackframe_color EQU 3ah
hilight_color EQU 75h
mesg_box_text_color EQU 071h
mesg_box_color EQU 07eh
fpu_registers_color EQU 038h
flag_registers_color EQU 030h
fpu_dummy_color EQU 039h
DATA_offset_color EQU 03Eh
cs_eip_color EQU 038h

qptr equ qword ptr
dptr equ dword ptr
wptr equ word ptr
bptr equ byte ptr

callstruct struct   ;50 bytes  (32h)
  _edi dd ?     ;0
  _esi dd ?     ;4
  _ebp dd ?     ;8
  _res dd ?     ;0ch reserved
  _ebx dd ?     ;10h
  _edx dd ?     ;14h
  _ecx dd ?     ;18h
  _eax dd ?     ;1ch
  _flg dw ?     ;20h flags
  _es dw ?      ;22h segments (NOT selectors)
  _ds dw ?      ;24h "
  _fs dw ?      ;26h "
  _gs dw ?      ;28h "
  _ip dw ?      ;2ah ignored in some calls
  _cs dw ?      ;2ch "
  _sp dw ?      ;2eh must be 0 to use system stacks
  _ss dw ?      ;30h "
callstruct ends

include stacks.asm

excpos dd 0b8000h+80*2*10

showexc macro excnum:req
  ifdef debug_showexc
    push ebx
    push ds
    mov ds,cs:seldata
    mov ebx,excpos
    add excpos,2
    mov byte ptr[ebx],excnum
    .if excpos > (0b8000h + 50*80*2)
      mov excpos,0b8000h+80*2*10
    .endif
    pop ds
    pop ebx
  endif
endm

crash macro excnum:req
;  ifdef debug_showexc  ;Do this always!
    .if cs:DebuggerInUse
      pushad
      mov cl,excnum
      jmp dump
    .endif
;  endif
endm

.DATA?
seldata dw ?
_cpl db ?
_cpuid db ?
_mmx db ?
temp_flgs dd ?

registers_save program_reg <?>
origonal_registers program_reg <?>
registers_saved_backlog program_reg 48 DUP (<?>)

BreakPoint_EIP dword Number_brkpts dup (?)
BreakPoint_oldopcode byte Number_brkpts dup (?)

;=========== complete VGA save status ===================
VideoBuffers db (8*1024) dup (?)
; VGA register saved 
VideoReg_CRTC_index byte ?
VideoReg_SQ_index byte ?
VideoReg_GC_index byte ?
VideoReg_MiscOutp byte ?
VideoReg_CRTC byte 019h dup (?)
VideoReg_SQ byte 005h dup (?)
VideoReg_GC byte 009h dup (?)
VideoReg_Attr byte 015h dup (?)
VideoReg_Palette byte 768 dup (?)
VideoReg_PELaddrWrite byte ?
; Other VGA info 
BIOS_cursor word ?
NumberOfCharacterRows byte ?
BytesPerCharacter word ?

.DATA

string_buffer byte 80 dup (?)
  db 0

JustTerminated db 0
JustFatalFaulted db 0
JustFatalStr dd ?
saved_mask dw ?
saved_IRQ1 df 0
saved_int21h df 0
saved_int31h df 0
saved_int0 df 0
saved_int1 df 0
saved_int3 df 0
saved_int6 df 0
saved_int7 df 0
saved_int13 df 0
saved_int14 df 0
saved_int16 df 0

;=
align 4
screen_EIP_value dd 0
current_memory_operand_address dd 0
current_memory_operand_seg dd 0
selected_EIP dd 0
BacklogRegPTR_tail dd 0
BacklogRegPTR_head dd 0
screen_ending_EIP dd 0
prg_videomode db 0
special_brkpt_EIP dd 0
special_brkpt_save db 0
special_brkpt db FALSE
Step_flag db FALSE
users_screen_flag db TRUE
program_is_running db FALSE
;fast_scroll db FALSE
Testing_Addr db FALSE
conditional_jump db FALSE
DebuggerTerminated db FALSE
fpu_emulation_flag db FALSE
bottom_window_FLAG db STx_W
Key_flags db 0
selected_line sbyte 0
Kbd_Rate db -1
Kbd_Delay db -1
prev_key_code db 0
FPU_installed db FALSE
IntroMessageNotShown db TRUE
DebuggerInUse db FALSE

Until_Here db 0         ;0=not engaged, 1=set brkpt, 2=run program
Until_Here_EIP dd 0     ;brk point set by Until_Here
Data_Offset dd 0        ;inv_adr_mesg  ;current top ptr of data view
which_window db 0       ;0=code, 1=reg, 2=flag, 3=data
reg_selected db 0       ;equivalent of selected_line for register window
flag_selected db 0      ;for flag window
data_selected db 0      ;for data window
maxdgroup_select db 0   ;max value for data_selected
Frame_Ptr dd 0          ;stack frame ptr
Keep_Frame_Ptr db 0     ;FALSE=reload frame_ptr from ss:esp, TRUE=don't reload

; menu bar texts 
Menu_shift_bar label dword            ;context-sensitive menu bar for shift key
dd Code_Menu_shift_bar_text
dd Reg_Menu_shift_bar_text
dd Flag_Menu_shift_bar_text
dd Data_Menu_shift_bar_text

Menu_ctrl_bar label dword           ;context-sensitive menu bar for ctrl key
dd Code_Menu_ctrl_bar_text
dd Reg_Menu_ctrl_bar_text
dd Flag_Menu_ctrl_bar_text
dd Data_Menu_ctrl_bar_text

Menu_alt_bar label dword          ;context-sensitive menu bar for alt key
dd Code_Menu_alt_bar_text
dd Reg_Menu_alt_bar_text
dd Flag_Menu_alt_bar_text
dd Data_Menu_alt_bar_text

Menu_bar label dword      ;context-sensitive menu bar
dd Code_Menu_bar_text
dd Reg_Menu_bar_text
dd Flag_Menu_bar_text
dd Data_Menu_bar_text

_xc_ equ mesg_box_text_color  ;lazy ass...

Help_msg label Byte
db 'QDEBUG : Extended Help',10,10
db 0,hilight_color,'            .-'  ,0,_xc_,'goto origin (code | data) ',10
db 0,hilight_color,'        Space-'  ,0,_xc_,'goto **memory operand ',10
db 0,hilight_color,'SHIFT : Space-'  ,0,_xc_,'goto *memory operand ',10
db 0,hilight_color,'ALT :   +,-,*,/ ',0,_xc_,'Frame Up,Dn,ESP,EBP ',10
db '$'

;;Menu Bars

;;code window
sp_str_ = $
Code_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: '  ,0,menu_color,' '
db 0,hilight_color,'X-'      ,0,menu_color,'Exit '
db 0,hilight_color,'F4-'     ,0,menu_color,'Back '
db 0,hilight_color,'F5-'     ,0,menu_color,'User screen '
db 0,hilight_color,'I-'      ,0,menu_color,'I3HERE '
db 0,hilight_color,'M-'      ,0,menu_color,'MMX/FPU '
sp_len_ = 80+(7*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Code_Menu_bar_text Label byte
db 0,menu_color,'    '
db 0,hilight_color,'F1-',0,menu_color,'Help '
db 0,hilight_color,'F2-',0,menu_color,'Brkpt '
db 0,hilight_color,'F4-',0,menu_color,'Here '
db 0,hilight_color,'F7-',0,menu_color,'Next '
db 0,hilight_color,'F8-',0,menu_color,'Step '
db 0,hilight_color,'F9-',0,menu_color,'Run '
db 0,hilight_color,'Tab-',0,menu_color,'Regs '
db 0,hilight_color,'+/- ',0,menu_color,'Inc/Dec '
sp_len_ = 80+(8*2*2+2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Code_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,' '
db 0,hilight_color,'F2-'    ,0,menu_color,'Restart '
db 0,hilight_color,'N-'     ,0,menu_color,'New EIP '
db 0,hilight_color,'O-'     ,0,menu_color,'Goto Origin '
db 0,hilight_color,'###-'   ,0,menu_color,'Change EIP '
sp_len_ = 80+(5*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Code_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: '        ,0,menu_color,' '
db 0,hilight_color,'Up/Dn/PgUp/PgDn-',0,menu_color,'Scroll data '
db 0,hilight_color,'Tab-'            ,0,menu_color,'Data   '
sp_len_ = 80+(4*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

;;reg window
sp_str_ = $
Reg_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: '  ,0,menu_color,' '
db 0,hilight_color,'X-'      ,0,menu_color,'Exit '
db 0,hilight_color,'F4-'     ,0,menu_color,'Back '
db 0,hilight_color,'F5-'     ,0,menu_color,'User screen '
db 0,hilight_color,'I-'      ,0,menu_color,'I3HERE '
db 0,hilight_color,'M-'      ,0,menu_color,'MMX/FPU '
sp_len_ = 80+(7*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Reg_Menu_bar_text Label byte
db 0,menu_color,'    '
db 0,hilight_color,'F7-' ,0,menu_color,'Next '
db 0,hilight_color,'F8-' ,0,menu_color,'Step '
db 0,hilight_color,'F9-' ,0,menu_color,'Run '
db 0,hilight_color,'Tab-',0,menu_color,'Flag '
db 0,hilight_color,'+/- ',0,menu_color,'Inc/Dec '
sp_len_ = 80+(5*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Reg_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,'      '
sp_len_ = 80+(1*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Reg_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: '        ,0,menu_color,' '
db 0,hilight_color,'###-'            ,0,menu_color,'Change '
db 0,hilight_color,'Up/Dn/PgUp/PgDn-',0,menu_color,'Scroll data '
db 0,hilight_color,'Tab-'            ,0,menu_color,'Code '
sp_len_ = 80+(4*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

;;flag window
sp_str_ = $
Flag_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: '  ,0,menu_color,' '
db 0,hilight_color,'X-'      ,0,menu_color,'Exit '
db 0,hilight_color,'F4-'     ,0,menu_color,'Back '
db 0,hilight_color,'F5-'     ,0,menu_color,'User screen '
db 0,hilight_color,'I-'      ,0,menu_color,'I3HERE '
db 0,hilight_color,'M-'      ,0,menu_color,'MMX/FPU '
sp_len_ = 80+(7*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Flag_Menu_bar_text Label byte
db 0,menu_color,'  '
db 0,hilight_color,'F7-'   ,0,menu_color,'Next '
db 0,hilight_color,'F8-'   ,0,menu_color,'Step '
db 0,hilight_color,'F9-'   ,0,menu_color,'Run '
db 0,hilight_color,'Space-',0,menu_color,'Toggle '
db 0,hilight_color,'0-'    ,0,menu_color,'Reset '
db 0,hilight_color,'1-'    ,0,menu_color,'Set '
db 0,hilight_color,'Tab-'  ,0,menu_color,'Data '
sp_len_ = 80+(7*2*2+2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Flag_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,'      '
sp_len_ = 80+(1*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Flag_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: ',0,menu_color,'    '
db 0,hilight_color,'Up/Dn/PgUp/PgDn-',0,menu_color,'Scroll data '
db 0,hilight_color,'Tab-',0,menu_color,'Regs '
sp_len_ = 80+(3*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

;;data window
sp_str_ = $
Data_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: '  ,0,menu_color,' '
db 0,hilight_color,'X-'      ,0,menu_color,'Exit '
db 0,hilight_color,'F4-'     ,0,menu_color,'Back '
db 0,hilight_color,'F5-'     ,0,menu_color,'User screen '
db 0,hilight_color,'I-'      ,0,menu_color,'I3HERE '
db 0,hilight_color,'M-'      ,0,menu_color,'MMX/FPU '
sp_len_ = 80+(7*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Data_Menu_bar_text Label byte
db 0,menu_color,'    '
db 0,hilight_color,'F7-',0,menu_color,'Next   '
db 0,hilight_color,'F8-',0,menu_color,'Step   '
db 0,hilight_color,'F9-',0,menu_color,'Run   '
db 0,hilight_color,'Tab-',0,menu_color,'Code   '
db 0,hilight_color,'+/- ',0,menu_color,'Inc/Dec value  '
sp_len_ = 80+(5*2*2+2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Data_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,' '
db 0,hilight_color,'###-'   ,0,menu_color,'Change offset '
db 0,hilight_color,'+/- '   ,0,menu_color,'Inc/Dec offset '
sp_len_ = 80+(3*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Data_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: ',0,menu_color,' '
db 0,hilight_color,'###-'    ,0,menu_color,'Change value '
db 0,hilight_color,'Up/Dn-'  ,0,menu_color,'Scroll '
db 0,hilight_color,'Tab-'    ,0,menu_color,'Flag '
sp_len_ = 80+(4*2*2)-($-sp_str_)
db sp_len_ dup(' '),'$'

stk_mesg db 0,heading_color,'Stack frame$'
stk_ptrmesg db 0,heading_color,'ss:esp$'
ebp_ptrmesg db 0,SS_EBP_stackframe_color,'ss:ebp$'
stk_blankit db '      $'
dat_mesg db 0,heading_color,'Offset: $'

.CODE

include decode.asm

_debugger_addr equ $
_debugger_size equ 64*1024  ;Lock 64k for now (size is unknown)

;This macro must be placed before each REP instruction to overcome
; some bloody WinNT bug.
_winnt macro
  push ds
  pop es   ;FIX v1.05 : WinNT needs this!
endm

include ftoa.asm   ;Include new print_float() rountines : v1.03

.code

;
;
;    The routine will start the dubugger
;
;    This routine will just init the debugger and set the Trap flag
;
;  Expects :  EAX = ESP
;          :  EBX = EIP
;
;
qdebug PROC 
  cld
  sti
  pushfd
  pop temp_flgs

  mov origonal_registers.prg_eax, 0
  mov origonal_registers.prg_ebx, 0
  mov origonal_registers.prg_ecx, 0
  mov origonal_registers.prg_edx, 0
  mov origonal_registers.prg_edi, 0
  mov origonal_registers.prg_esi, 0
  mov origonal_registers.prg_ebp, 0
  mov origonal_registers.prg_esp, EAX
  mov origonal_registers.prg_eip, EBX
  mov origonal_registers.prg_cs, cs
  mov origonal_registers.prg_ds, ds
  mov origonal_registers.prg_ss, ss
  mov origonal_registers.prg_es, es
  mov origonal_registers.prg_fs, fs
  mov origonal_registers.prg_gs, gs
  mov eax,temp_flgs
  mov origonal_registers.prg_eflags, eax

  call detect_cpl

  call detect_cpuid ;NEW : v1.10 Beta #3

  call detect_mmx  ;NEW : v1.10 Beta #3

  call detect_fpu

  .IF ( FPU_installed )
    fsave origonal_registers.fpu_envir    ; save 108 bytes
  .ENDIF

  mov esi,offset origonal_registers
  mov edi,offset registers_save
  mov ecx,sizeof registers_save
  _winnt
  rep movsb

  call debugger_init

  ret
qdebug ENDP

detect_cpl proc
  ; If the Current Privilege Level (CPL) is above 0 then
  ; the debugger runs differently
  mov ax,cs
  lar eax,eax
  test ah,01100000b
  .if zero?
    ;cpl=0
    mov _cpl,0
    mov ax,cs                      ; Set RPL field to zero
    and al,11111100b
    push eax
    push offset Load_cs
    retf
Load_cs:
  .else
    mov _cpl,3
  .endif
  ret
detect_cpl endp

detect_cpuid proc private
  pushfd
  pop eax
  mov ebx,eax
  xor eax,200000h
  push eax
  popfd
  pushfd
  pop eax
  .if eax!=ebx
    mov _cpuid,1
  .else
    mov _cpuid,0
  .endif
  ret
detect_cpuid endp

detect_mmx proc
  .if !_cpuid
    mov _mmx,0
    ret
  .endif
  mov eax,1
  db 0fh,0a2h  ;CPUID
  test edx,00800000h
  jz MMX_not_present
  mov _mmx,1
MMX_not_present:
  ret
detect_mmx endp

detect_fpu proc
  ; determine if FPU is installed 

  smsw ax
  test al, 4
  jz emulation_is_off

  mov fpu_emulation_flag,TRUE

  ; temperarily turn emulation off, 16bit emulators don't like
  ; 32bit mode.
  ;
  .if _cpl==0
    and al,NOT 4
    lmsw ax
  .endif

emulation_is_off:

  ; No emulation. can try instructions
  ;

  fninit
  mov ax,5a5ah
  fstsw ax
  cmp al,0
  jne _turn_on_EM

  mov FPU_installed, TRUE
  ret

  ; if no FPU is installed then turn emulation flag on to trap
  ; all fpu instruction with exception # 7.

_turn_on_EM:
  .if _cpl==0
    smsw ax
    or al, 4
    lmsw ax
  .endif
  ret
detect_fpu endp

;
;
;               initalize the debugger !!!!!!!!!!!!!!!!
;
;  This gets run only once when the debugger is started
;
;
;
debugger_init PROC 

  cli

  ; clear user breakpoint array 
  xor eax,eax
@@:
  mov BreakPoint_EIP[eax*4],-1
  inc eax
  cmp eax, LENGTHOF BreakPoint_EIP
  jne @b

  ; hook IRQ 1 the keyboard interrupt 
  mov bl,1
  call getIRQvector
  mov dword ptr saved_IRQ1,edx
  mov word ptr saved_IRQ1+4,cx

  mov edx,offset keyboard_ISR
  mov cx,cs
  call setIRQvector

  ; hook INT31h 
  mov bl,31h
  call GetIntVector
  mov dword ptr saved_int31h,edx
  mov word ptr saved_int31h+4,cx

  mov edx,offset new_int31h
  mov cx,cs
  call SetIntVector

  ; hook INT21 AH=4Ch   
  mov bl,21h
  call GetIntVector
  mov dword ptr saved_int21h,edx
  mov word ptr saved_int21h+4,cx

  mov edx,offset terminate_Hooker
  mov cx,cs
  call SetIntVector

  ; set the Divide Error handler 
  mov bl,0
  call GetExcVector
  mov dword ptr saved_int0,edx
  mov word ptr saved_int0+4,cx

  mov edx,offset DivideError_Exception
  mov cx,cs
  call SetExcVector

  ; set debug interrupt hanlder ( INT 1 ) 
  mov bl,1
  call GetExcVector
  mov dword ptr saved_int1,edx
  mov word ptr saved_int1+4,cx

  mov edx,offset Debug_Exception
  mov cx,cs
  call SetExcVector

  ; set the break point handler (opcode 0CCh) 
  mov bl,3
  call GetExcVector
  mov dword ptr saved_int3,edx
  mov word ptr saved_int3+4,cx

  mov edx,offset BreakPoint_Exception
  mov cx,cs
  call SetExcVector

  ; set the Invalid Opcode handler 
  mov bl,6
  call GetExcVector
  mov dword ptr saved_int6,edx
  mov word ptr saved_int6+4,cx

  mov edx,offset InvalidOpcode_Exception
  mov cx,cs
  call SetExcVector

  ; set device NOT available handler 
  mov bl,7
  call GetExcVector
  mov dword ptr saved_int7,edx
  mov word ptr saved_int7+4,cx

  mov edx,offset DEVICE_Unavailable_Exception 
  mov cx,cs
  call SetExcVector

  ; the General protection exception vector 
  mov bl,13
  call GetExcVector
  mov dword ptr saved_int13,edx
  mov word ptr saved_int13+4,cx

  mov edx,offset GeneralProtection_Exception
  mov cx,cs
  call SetExcVector

  ; set the page faults handler 
  mov bl,14
  call GetExcVector
  mov dword ptr saved_int14,edx
  mov word ptr saved_int14+4,cx

  mov edx,offset Page_Fault_Exception
  mov cx,cs
  call SetExcVector

  ; set FPU exception handler 
  mov bl,16
  call GetExcVector
  mov dword ptr saved_int16,edx
  mov word ptr saved_int16+4,cx

  mov edx,offset FPU_Exception
  mov cx,cs
  call SetExcVector

  mov program_is_running, TRUE

  ret

debugger_init ENDP    ; end of debugger  inialization =

intro_mesg db 'QDEBUG 32bit debugger ',QDEBUG_VERSION,' Build ',build_str,10,
'  MMX Supported',10,
'Made DPMI Compliance by :  Peter Quiring',10,
'QDASM v',DASM_VERSION,'(Based on Dazmit) by :  Peter Quiring',10,
'Based on DOS32 Debugger by :  Adam Seychell',
'$'

;
;
;       Save the *complete* VGA video card state
;
;
save_CompleteVideoState PROC 
  cld
  ;
  ;               Save some VGA registers
  ;

  ; get and save programs video mode 
  mov ah,0fh
  int_10h
  mov prg_videomode,al

  ; get font information 
  push ebp
  mov ax,1130h
  mov bh,0
  int_10h
  pop ebp
  inc dl
  mov NumberOfCharacterRows,dl
  mov BytesPerCharacter,cx

  cld
  ; save the CRT controller registers 
  mov dx,3D4h
  in al,dx
  mov VideoReg_CRTC_index,al

  xor ecx,ecx
@@:
  mov al,cl
  out dx,al
  inc dx  ;3D5h
  in al,dx
  dec dx  ;3D4h
  mov VideoReg_CRTC[ecx],al
  inc cl
  cmp cl,SIZEOF VideoReg_CRTC
  jb @b

  ; save the Sequencure controller registers 
  mov dx,3C4h
  in al,dx
  mov VideoReg_SQ_index,al

  xor ecx,ecx
@@:
  mov al,cl
  out dx,al
  inc dx ;3C5h
  in al,dx
  dec dx ;3C4h
  mov VideoReg_SQ[ecx],al
  inc cl
  cmp cl,SIZEOF VideoReg_SQ
  jb @b

  ; save the Graphic Controller Registers 
  mov dx,3CEh
  in al,dx
  mov VideoReg_GC_index,al
  xor ecx,ecx
@@:
  mov al,cl
  out dx,al
  inc dx ;3CFh
  in al,dx
  dec dx ;3CEh
  mov VideoReg_GC[ecx],al
  inc cl
  cmp cl,SIZEOF VideoReg_GC
  jb @b

  ; save the Attribute Controller Registers 
  mov dx,3DAh               ; reset flip flop
  in al,dx
  xor ecx,ecx
@@:
  mov dx,3C0h
  mov al,cl
  out dx,al
  inc dl
  in al,dx
  dec dl
  out dx,al
  mov VideoReg_Attr[ecx],al
  inc cl
  cmp cl,SIZEOF VideoReg_Attr
  jb @b
  mov dx,3C0h
  mov al,20h              ; Enable palette
  out dx,al
  mov dx,3DAh             ; reset flip flop
  in al,dx

  ; save 8KB of video memory 
  mov esi,0B8000h
  mov edi,Offset VideoBuffers
  mov ecx,(sizeof VideoBuffers)/4
  _winnt
  rep movsd

  ; save the general or external VGA registers 
  mov dx,3CCh
  in al,dx
  mov VideoReg_MiscOutp,al

  ; save the palette
  mov dx,3C8h
  in al,dx
  mov VideoReg_PELaddrWrite,al
  mov dx,3C7h

  mov al,0
  out dx,al
  mov dx,3C9h
  xor ecx,ecx
@@:
  in al,dx
  mov VideoReg_Palette[ecx],al
  in al,dx
  mov VideoReg_Palette[ecx+1],al
  in al,dx
  mov VideoReg_Palette[ecx+2],al
  add ecx,3
  cmp ecx,SIZEOF VideoReg_Palette
  jb @b

  ; save cursor position 
  mov ah,3
  mov bh,0
  int_10h
  mov BIOS_cursor,dx
  ret

  ; finished saveing the video state 
save_CompleteVideoState ENDP


;
;
;
;   load the VGA video state from what was saved in the
;  "save_CompleteVideoState" procedure above
;
;
;
Restore_Video PROC 
  cld
  .IF users_screen_flag
    ret
  .Endif
  pushad

  ; first return video mode 

  cli

  xor eax,eax
  mov al,prg_videomode
  int_10h

  mov al,prg_videomode
  and al,7fh
  .if (AL==3) && (BytesPerCharacter==8)
    mov ax,1123h
    mov bl,0
    mov dl,NumberOfCharacterRows
    int_10h
  .elseif (AL==3) && (BytesPerCharacter==14)
    mov ax,1122h
    mov bl,0
    mov dl,NumberOfCharacterRows
    int_10h
  .endif

  ; restore cursor position 
  mov ah,2
  mov bh,0
  mov dx,BIOS_cursor
  int_10h

  sti
  cld

  ; restore the video memory that gets wiped on mode switching 

  mov edi,0B8000h
  mov esi,Offset VideoBuffers
  mov ecx,(sizeof VideoBuffers )/4
  _winnt
  rep movsd

  ; Resotre the general or external VGA registers 
  mov dx,3C2h
  mov al,VideoReg_MiscOutp
  out dx,al

  ; restore the CRT controller registers 
  mov al,VideoReg_CRTC[ecx]             ; Turn off protection
  mov dx,3D4h
  mov ah,VideoReg_CRTC[11h]
  and ah,01111111b
  mov al,11h
  out dx,ax

  xor ecx,ecx
@@:
  mov al,cl
  out dx,al
  inc dx ;3D5h
  mov al,VideoReg_CRTC[ecx]
  out dx,al
  dec dx ;3D4h
  inc cl
  cmp cl,SIZEOF VideoReg_CRTC
  jb @b
  mov al,VideoReg_CRTC_index
  out dx,al

  ; restore the Graphic Controller Registers 
  xor ecx,ecx
  mov dx,3CEh
@@:
  mov al,cl
  out dx,al
  inc dx  ;3CFh
  mov al,VideoReg_GC[ecx]
  out dx,al
  dec dx  ;3CEh
  inc cl
  cmp cl,SIZEOF VideoReg_GC
  jb @b
  mov al,VideoReg_GC_index
  out dx,al

  ; Restore the Sequencure controller registers 
  xor ecx,ecx
  mov dx,3C4h
@@:
  mov al,cl
  out dx,al
  inc dx  ;3C5h
  mov al,VideoReg_SQ[ecx]
  out dx,al
  dec dx  ;3C4h
  inc cl
  cmp cl,SIZEOF VideoReg_SQ
  jb @b
  out dx,al
  mov al,VideoReg_SQ_index

  ; Restore the Attribute Controller Registers 
  mov dx,3DAh               ; reset flip flop
  in al,dx
  xor ecx,ecx
@@:
  mov dx,3C0h
  mov al,cl
  out dx,al
  mov al,VideoReg_Attr[ecx]
  out dx,al
  inc cl
  cmp cl,SIZEOF VideoReg_Attr
  jb @b
  mov dx,3C0h
  mov al,20h              ; Enaple palette
  out dx,al
  mov dx,3DAh               ; reset flip flop
  in al,dx

  ; Retore the palette
  mov dx,3C8h
  mov al,0
  out dx,al
  inc dx  ;3C9h
  xor ecx,ecx
@@:
  mov al,VideoReg_Palette[ecx]
  out dx,al
  mov al,VideoReg_Palette[ecx+1]
  out dx,al
  mov al,VideoReg_Palette[ecx+2]
  out dx,al
  add ecx,3
  cmp ecx,SIZEOF VideoReg_Palette
  jb @b
  dec dx  ;3C8h
  mov al,VideoReg_PELaddrWrite
  out dx,al

  mov users_screen_flag,TRUE
  popad
  ret
Restore_Video ENDP

;
;
;
;       Convert a scan code to a hex digit.
;
;      Expects   ch  = scan code
;      Return:   CF  = scan code not 0-9 or A-F
;                NC  = success, CL = hex digit (low nibble)
;
;
_scan2hex PROC 
  xor cl,cl
  .if cx == A_KEY
    mov cl,10
  .elseif cx == B_KEY
    mov cl,11
  .elseif cx == C_KEY
    mov cl,12
  .elseif cx == D_KEY
    mov cl,13
  .elseif cx == E_KEY
    mov cl,14
  .elseif cx == F_KEY
    mov cl,15
  .elseif cx == NUM_0
    ;;xor cl,cl   ;do nothing
  .elseif (cx >= NUM_1) && (CX <= NUM_9)
    sub cx,(NUM_1-100h)
    shr ecx,8
  .else
    stc
  .endif
  ret
_scan2hex ENDP

;
; The following routines are used to make calling DPMI services easier.
;

SetIntVector PROC  Uses Eax
  mov ax,0205h
  int 31h
  ret
SetIntVector ENDP

GetIntVector PROC  Uses Eax
  mov ax,0204h
  int 31h
  ret
GetIntVector ENDP

SetExcVector PROC  Uses Eax
  mov ax,0203h
  int 31h
  ret
SetExcVector ENDP

GetExcVector PROC  Uses Eax
  mov ax,0202h
  int 31h
  ret
GetExcVector ENDP

getIRQvector PROC  Uses Eax Ebx
  cmp bl,8h
  jb @@j1
  add bl,60h
@@j1:
  add bl,8
  mov ax,0204h
  int 31h
  ret
getIRQvector ENDP

setIRQvector PROC  Uses Eax Ebx
  cmp bl,8h
  jb @@j1
  add bl,60h
@@j1:
  add bl,8
  mov ax,0205h
  int 31h
  ret
setIRQvector ENDP

;===================================================================
;  The following will read/write/cmp data from unknown memory without
;    causing an exception to go to OS.
;  Carry clear = Action performed, data is valid (if any returned)
;  Carry set = Action caused exception, data is invalid
;    Expect: FS:ESI = pointing to location to perform action on
;===================================================================
getbyte proc
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    xor al,al
    stc
  .Endif
  ret
getbyte endp
getword proc
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    xor ax,ax
    stc
  .Endif
  ret
getword endp
getdword proc
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    xor eax,eax
    stc
  .Endif
  ret
getdword endp
chk_location proc uses eax
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    stc
  .Endif
  ret
chk_location endp
setbyte proc
  push ax
  Call Test_location      ; Test location FS:[ESI]
  pop ax
  .If Testing_Addr == TRUE
    push offset _bad_   ;just in case we have read access but not write access
    mov fs:[esi],al
    db 8 dup (90h)
    mov Testing_Addr,FALSE
    add esp,4
    clc
  .Else
_bad_:
    stc
  .Endif
  ret
setbyte endp

;
;  This procedure will test the DWORD at address in FS:ESI to see if it's
; a valid location, i.e will not cause a page fault.
;
;  Return       If location is Ok then
;                   Testing_Addr = TRUE
;                                   eax = dword
;               else
;                   Testing_Addr = FALSE
;
;
Test_location proc
  mov Testing_Addr,TRUE
    db 2 dup (90h)
  mov eax,fs:[esi]
    db 8 dup (90h)
Test_Location_End::
  ret
Test_location endp

;
;
;        Look at current instrucion and see if a VGA register was modified
;
;
;  Expects      "registers_save.prg_eip" pointing to instruction
;
;  Returns:    restores video state if instruction was using a VGA port
;
;
CheckVGAport PROC 

  pushad
  mov eax,registers_save.prg_eip
  mov eax,[eax]
  mov cl,2
Loopeer:
  .IF al == 66h                 ; igonre operand size prefix
    shr eax,8
  .ELSEIF al == 11110010b           ; igonre any stupid REP prefix
    shr eax,8
  .ENDIF
  dec cl
  jnz Loopeer

  and al,01111100b
  cmp AL ,01101100b     ;see if IN,OUT, INS or OUTS
  je getPortIn
  jmp exit

getPortIn:
  mov eax,registers_save.prg_edx
  mov edi,offset allVGAports
  cld
  mov ecx,19
  _winnt
  repne scasw
  jne exit

  call Restore_Video

exit:
  popad
  ret

  allVGAports dw 3D4h,3D5h,3C4h,3C5h,3CEh,3CFh,3CCh,3CAh,3C2h,3DAh
  dw 3c0h,3c8h,3c9h,3c7h,3d6h,3c3h,3cdh,3d4h,3d5h
CheckVGAport ENDP

;
;
;
;       Displays a repeated character on the screen Verticaly
;
;      Expects   edi = character offset in the screen memory.
;                al  = character
;                cl  = repeat
;                ah  = color
;
;
_draw_vert PROC  USES edx
  mov edx,0B8000h
@@:
  mov word ptr [edi*2+edx],ax
  add edi,80
  dec cl
  jnz @b
  ret
_draw_vert ENDP


;
;
;
;       Displays a repeated character on the screen horizonataly
;
;      Expects   edi = character offset in the screen memory.
;                al  = character
;                cl  = repeat
;                ah  = color
;
;
_draw_horz PROC  USES edx
  mov edx,0B8000h
@@:
  mov word ptr [edi*2+edx],ax
  inc edi
  dec cl
  jnz @b
  ret
_draw_horz ENDP



;
;
;
;       Displays a single character on the screen
;
;      Expects   edi = character offset in the screen memory.
;                al  = character
;                ah  = color
;
;
_draw_char PROC  USES edx
  mov edx,0B8000h
  mov word ptr [edi*2+edx],ax
  inc edi
  ret
_draw_char ENDP

;
;
;
;       reads current characer on the screen
;
;      Expects   edi = character offset in the screen memory.
;      returns   al  = character
;
;
read_char PROC  USES EDX
  mov edx,0B8000h
  mov al,byte ptr [edi*2+edx]
  ret
read_char ENDP

;
;
;
;       Displays two characters on the screen
;
;      Expects   edi = character offset in the screen memory.
;                bh  = character 1
;                bl  = character 2
;                ah  = color
;
;
_draw_2char PROC  USES edx
  mov al,bh
  mov edx,0B8000h
  mov word ptr [edi*2+edx],ax
  inc edi
  mov al,bl
  mov word ptr [edi*2+edx],ax
  inc edi
  ret
_draw_2char ENDP

;
;
;
;       Display a string on the screen
;
;      Expects   edi = character offset in the screen memory.
;                edx = points to the string that terminates with a '$'
;                ah  = color
;
;
plot_string PROC  USES EBX
  local first_pos :dword

  mov ebx,0B8000h
  mov first_pos,edi
leer:
  mov al,[edx]
  cmp al,'$'
  je exit
  cmp al,0
  jne @f
  mov ax,[edx+1]
  add edx,2
  xchg al,ah
@@:
  .if al != 10
    mov word ptr [edi*2+ebx],ax
    inc edi
  .else
    add first_pos,ScreenWidth*2
    mov edi,first_pos
  .endif

  inc edx
  jmp leer
exit:
  ret
plot_string ENDP

;
;
;
;       Display a hexidecimal number on the screen
;
;      Expects   edi = character offset in the screen memory.
;                ebx = The number to display
;                cl = The number of nibbles to display
;
;
;
print_hex PROC  USES EBX EBP EDX ECX
  mov edx,0B8000h
he_plotloop:
  rol ebx,4
  movzx ebp,bl
  and ebp,0fh
  mov al,ds:hex_chars[ebp]
  mov word ptr [edi*2+edx],ax
  inc edi
  dec cl
  jnz he_plotloop
  ret
print_hex ENDP

;
;
;
;       Display a hexidecimal number into a string
;
;      Expects   edx = string to print into
;                ebx = The number to display
;                cl = The number of nibbles to display
;
;
;
_print_hex PROC  USES EBX EBP EDX ECX EAX   ;must also preserve EAX!
he_plotloop:
  rol ebx,4
  movzx ebp,bl
  and ebp,0fh
  mov al,ds:hex_chars[ebp]
  mov [edx],al
  inc edx
  dec cl
  jnz he_plotloop
  ret
_print_hex ENDP

hex_chars db '0123456789abcdef'


;
;
;
;       Display a hexidecimal number on the screen without leading zeros
;
;      Expects   edi = character offset in the screen memory.
;                ebx = The number to display
;                cl = The number of nibbles to display
;
;
;
print_hexz PROC  USES EBX EBP EDX ECX

  mov ch,hex_chars[0]
  mov edx,0B8000h
he_plotloop:
  rol ebx,4
  movzx ebp,bl
  and ebp,0fh
  mov al,ds:hex_chars[ebp]
  cmp al,ch
  jne _P
  mov al,' '
  jmp _E
_P:
  mov ch,-1
_E:
  mov word ptr [edi*2+edx],ax
  inc edi
  dec cl
  jnz he_plotloop
  cmp ch,-1
  jne @f
  ret
@@:
  dec edi
  mov al,'0'
  mov cl,1
  jmp _P

print_hexz ENDP


;
;
;
;       This will display the 387 stack
;
;
;  Expects Nothing
;
;
Display_387_info PROC 

  Local ST_symbol_ptr :dword
  Local ST_tag_word :word

  .if (bottom_window_FLAG != STx_W)
    call clear_bottom_window
    mov bottom_window_FLAG, STx_W
  .endif

  ;********* plot the FPU registers ******************

  .IF ( FPU_installed )
    .if _show_mmx   ;NEW : v1.10 Beta #3 : MMX support!
      mov ST_symbol_ptr , offset mm0_symb
    .else
      mov ST_symbol_ptr , offset ST0_symb
    .endif
    mov edi, ScreenWidth*(ScreenHeight-9) + 1
    mov esi,0

    ; Note: while the tag field sequence is absolute,
    ;       the ST(x) sequence in save area is *RELATIVE* to stack top!!
    ; This must be taken into account by rolling the tag bits so that
    ; the stack top bits are at the bottom.
    ; we do this only once, and use the modified one for the rest of the time

    ; NEW : v1.10 Beta #3 : MMX Support (by Peter Quiring)
    ; for MMX the stack top is zero and absolute == relative
    ; but if you are viewing FPU regs in the MMX mode I print them in
    ; the stack manner (does not matter since all MMX instructions
    ; will reset TOS=0 always).
    ; this will make the MMX registers seem to jump though when
    ; tracing into an MMX instruction after FPU instructions.

    ; ** get the stack top
    mov ecx, registers_save.fpu_envir.status
    shr ch,3
    and ch,7                ;stack top on ch
    mov cl,ch
    add cl,cl               ;times 2 (tag is 2-bit wide)
    mov ebx, registers_save.fpu_envir.tag
    ror bx,cl               ;do the trick
    mov ST_tag_word,bx

Plot_ST_loop:
    ; ** plot eight 80 bit register symbols ******
    push edi
    mov edx,ST_symbol_ptr
    mov ah,registers_color
    call plot_string
    inc edi

    ; read specific TAG field

    mov bx, ST_tag_word         ;*** use modified one
    mov ecx,esi                 ;*** esi =2*index already
    shr bx,cl
    and bl,3

    .IF (BL == 3)
      mov edx,offset mesg_tag3
;    .ELSEIF (BL == 2)   ;allow other rountine to handle NAN/INF
;      mov edx,offset mesg_tag2
    .ELSE           ; floating point number display
      lea eax,[ registers_save.fpu_envir.st0 + ESI*4+ESI]
      mov edx,Offset string_buffer
      .if _show_mmx
        call print_mmx     ;NEW : v1.10 Beta #3 : MMX printing
      .else
        call print_float   ;Print float from QLIB v2.10
      .endif
    .ENDIF

    mov ah,registers_color
    call plot_string

    ;*** fill rest of line with blanks ***/

    pop edx
    push edx
    add edx,59
    sub edx,edi
    draw_horz ' ', DL

    pop edi
    add edi,ScreenWidth
    add ST_symbol_ptr, 6
    add esi,2
    cmp esi,16                ;ESI=2*index
    jb Plot_ST_loop

    ;NEW : v1.10 Beta #3 : Print FPU-TOS
    mov edi, ScreenWidth*(ScreenHeight-10) + 4
    mov ah,boarder_color
    draw_char 'T'
    draw_char 'O'
    draw_char 'S'
    draw_char '='
    mov eax, registers_save.fpu_envir.status
    shr ah,3
    and ah,7                ;stack top on ch
    mov al,ah
    mov ah,boarder_color
    add al,'0'
    call _draw_char

  .ELSE
    ; IF no 387 then print dummy message

    mov edi, ScreenWidth*(ScreenHeight-8) + 6
    mov ah,fpu_dummy_color
    mov edx,Offset dummy_ST_reg
    call plot_string
  .ENDIF

  ret


  dummy_ST_reg db ' ............',10
  db '.   Floating  Point  Unit  not  available  . ',10
  db ' ... $'
  mesg_tag3 db 'Empty',25 dup(' '),'$'
;  mesg_tag2 db 'NaN or infinity',15 dup(' '),'$'
Display_387_info ENDP


;
;
;
;       This will display all the debug register values and
;       the the R,W and LEN fields of each
;
;      Also displays the program segment Base & Limit fields
;
;
;   Expects :  Nothing
;
Display_DRx_info PROC 

  .if (bottom_window_FLAG != DRx_W)
    call clear_bottom_window
    mov bottom_window_FLAG,DRx_W
  .endif

  mov ah,heading_color

  ;***** plot SEGMENT info ****
  mov edi,(1 + ScreenWidth*(ScreenHeight-3) )
  mov edx,offset segdgroup_mesg1
  call plot_string
  mov ah,base_addr_color
  xor ebx,ebx  ;Program_Addr
  mov cl,8
  call print_hex
  add edi,4
  mov ah,heading_color
  mov edx,offset segdgroup_mesg2
  call plot_string
  mov ah,base_addr_color
  mov cx,cs
  lsl ebx,ecx
  mov cl,8
  call print_hex

  mov edi,(1 + ScreenWidth*(ScreenHeight-9) )
  mov ah,heading_color
  mov edx,offset HardwareBrkpts_mesg
  call plot_string

  ; display the break point regieters 
  mov edi,(2 + ScreenWidth*(ScreenHeight-8) )
  mov ah,registers_color
  draw_2char 'DR'
  draw_2char '0='
  .if _cpl
    xor ebx,ebx
  .else
    mov ebx,DR0
  .endif
  mov cl,0
  call Plot_DR

  mov edi,(2 + ScreenWidth*(ScreenHeight-7) )
  draw_2char 'DR'
  draw_2char '1='
  .if _cpl
    xor ebx,ebx
  .else
    mov ebx,DR1
  .endif
  mov cl,2
  call Plot_DR

  mov edi,(33 + ScreenWidth*(ScreenHeight-8) )
  draw_2char 'DR'
  draw_2char '2='
  .if _cpl
    xor ebx,ebx
  .else
    mov ebx,DR2
  .endif
  mov cl,4
  call Plot_DR

  mov edi,(33 + ScreenWidth*(ScreenHeight-7) )
  draw_2char 'DR'
  draw_2char '3='
  .if _cpl
    xor ebx,ebx
  .else
    mov ebx,DR3
  .endif
  mov cl,6
  call Plot_DR

  mov edi,(2 + ScreenWidth*(ScreenHeight-6) )
  draw_horz ' ',58

  ret

  Plot_DR PROC         ; sub proc for plotiing one DR reg 
    .if _cpl==0
      mov ebp,DR7
    .else
      xor ebp,ebp
    .endif
    shr ebp,cl
    push ecx
    mov cl,8
    call print_hex
    pop ecx
    test ebp,00000003h        ; look at  Gi and Li bits
    jnz @f
    .if _cpl==0
      mov edx,offset nul_DRx_measg
    .else
      mov edx,offset unknown_DRx_measg
    .endif
    call plot_string
    ret
@@:
    shr ebp,cl
    draw_char ' '
    draw_2char 'W='
    mov bx,'0 '
    test ebp,00010000h
    jz @f
    mov bh,'1'
@@:
    call _draw_2char
    draw_2char 'R='
    mov bx,'0 '
    test ebp,00020000h
    jz @f
    mov bh,'1'
@@:
    call _draw_2char
    draw_2char 'LE'
    draw_2char 'N='
    mov ebx,ebp
    and ebx,000C0000h
    rol ebx,10
    mov cl,1
    call print_hex
    draw_char ' '
    ret
  Plot_DR ENDP

  nul_DRx_measg db ' disabled $'
  unknown_DRx_measg db ' unknown $'

  HardwareBrkpts_mesg db '      80386  Linear Address Breakpoint Registers         $'

  segdgroup_mesg1 db 'program segment (CS);  base = $'
  segdgroup_mesg2 db 'size = $'

Display_DRx_info ENDP




;
; clear_bottom_window;
;
;    Clears the window for the debug registers and FPU registers
;
; No paramaters;
;
clear_bottom_window PROC 
  pushad
  mov edi,(1 + ScreenWidth*(ScreenHeight-9) )
  shl edi,1
  add edi,0B8000h
  mov ah,back_color
  mov al,' '
  mov bl,8
@@:
  mov ecx, 59
  push edi
  rep stosw
  pop edi
  add edi,ScreenWidth*2
  dec bl
  jnz @b
  popad
  ret
clear_bottom_window ENDP


;
;
;     checks Jump condition code tttn with current program flags
;
;   Expects :  AL = condition code
;   returns  ZF = 0 if condation fails
;            ZF = 1 if condation not fails
;
get_Jcc_condition PROC 

  and al,00001111b
  or al,10010000b
  mov [set_instr+1],al
  jmp $+2
  jmp $+2
  jmp $+2
  jmp $+2
  jmp $+2
  jmp $+2
  jmp $+2
  jmp $+2
  jmp $+2
  mov ah,BYTE PTR registers_save.prg_eflags
  sahf

  set_instr DB 0fh,?,11000000b                ; SETccc EAX

  and al,al
  ret 0
get_Jcc_condition ENDP


;
; removed user break point at location EAX
; returns ZF = 1    if removed
;         ZF = 0    if was not removed
;
remove_BreakPoint PROC  USES EDI EAX ECX
  mov ecx,Number_brkpts
  mov edi,offset BreakPoint_EIP
  cld
  _winnt
  repne scasd
  jne no_brkpt_
  sub edi,offset BreakPoint_EIP+4
  shr edi,2
  mov cl,BreakPoint_oldopcode[edi]    ; temperarly put
  mov [eax],cl                        ; in old instruction
  xor eax,eax                         ; set zero flag
no_brkpt_:
  ret
remove_BreakPoint ENDP

;
;
;     This will update the registers log storage.
;
;   Expects :  Nothing
;
;
Update_register_LOG PROC 
  ; copy all regs into back log 
  mov edi,BacklogRegPTR_head
  add edi,offset registers_saved_backlog
  mov esi,offset registers_save
  mov ecx,(SIZEOF program_reg ) /4
  _winnt
  rep movsd

  mov eax,BacklogRegPTR_head
  add eax, SIZEOF program_reg
  .if eax >= SIZEOF registers_saved_backlog
    xor eax,eax
  .endif
  mov BacklogRegPTR_head,eax

  .if BacklogRegPTR_tail == EAX
    mov eax,BacklogRegPTR_tail
    add eax, SIZEOF program_reg
    .if eax >= SIZEOF registers_saved_backlog
      xor eax,eax
    .endif
    mov BacklogRegPTR_tail,eax
  .endif
  ret
Update_register_LOG ENDP

;_reg_order db ?

;
;
;       This will display all the register values, flags and all the
; intructions on the screen  ( except segment and debug registers )
;
;
refresh_screen PROC 

  local old_esi :dword
  local count1 :dword
  local line_count :byte
  local current_instruc :byte
  local brkpt_flag :byte
  local InstCursor_flag :byte
  local screen_ptr :dword
  local displacement_dest_EIP :long
  local displacement_src_EIP :long

  ;----- print I3HERE status -----
  mov ah,boarder_color
  mov edi,(ScreenWidth*35+61)
  draw_char 'I'
  draw_char '3'
  draw_char '='
  .if _i3here
    draw_char 'O'
    draw_char 'N'
    draw_char ' '
  .else
    draw_char 'O'
    draw_char 'F'
    draw_char 'F'
  .endif

  ; print the nine registers on the screen 
  mov edi,(ScreenWidth*1+66)
  xor esi,esi
;  mov _reg_order,0
RegPrint_LOOP:
comment #
  .if esi==1   ;;change order of regs!
    .if _reg_order
      mov esi,4
    .else
      mov esi,2
    .endif
  .elseif esi==2
    mov esi,3
  .elseif esi==3
    mov esi,1
    inc _reg_order
  .endif
#
  mov ebx,registers_save.prg_eax[esi*4]
  mov ah,registers_color
  mov edx,BacklogRegPTR_head
  .if BacklogRegPTR_tail != EDX
    sub edx, SIZEOF program_reg
    jge @f
    mov edx,SIZEOF registers_saved_backlog - SIZEOF program_reg
@@:
    .if ( EBX != Dword PTR registers_saved_backlog[edx+esi*4] ) \
      && ( ESI != 8 )
      mov ah,RegistersHiLight_color   ;;register has changed!
    .endif
  .endif
  .if which_window == REGS_W
    movzx ecx,reg_selected
    .if esi == ecx
      mov ah,selected_color
    .endif
  .endif
  mov cl,8
  call print_hexz
  inc esi
  add edi,80-8
  cmp esi,9
  jb RegPrint_LOOP

  ; Do not change the flag sequence! flag_map_table depends
  ; on this sequence!!!     
  ; print the eight flags 
  _f_setcolor 0
  mov edi,(ScreenWidth*1+78)
  mov al,'0'
  test registers_save.prg_eflags,0000000000001b
  jz @f
  mov al,'1'
@@:
  call _draw_char
  _f_setcolor 1
  mov edi,(ScreenWidth*2+78)
  mov al,'0'
  test registers_save.prg_eflags,0000001000000b
  jz @f
  mov al,'1'
@@:
  call _draw_char
  _f_setcolor 2
  mov edi,(ScreenWidth*3+78)
  mov al,'0'
  test registers_save.prg_eflags,0000010000000b
  jz @f
  mov al,'1'
@@:
  call _draw_char
  _f_setcolor 3
  mov edi,(ScreenWidth*4+78)
  mov al,'0'
  test registers_save.prg_eflags,0100000000000b
  jz @f
  mov al,'1'
@@:
  call _draw_char
  _f_setcolor 4
  mov edi,(ScreenWidth*5+78)
  mov al,'0'
  test registers_save.prg_eflags,0000000000100b
  jz @f
  mov al,'1'
@@:
  call _draw_char
  _f_setcolor 5
  mov edi,(ScreenWidth*6+78)
  mov al,'0'
  test registers_save.prg_eflags,0000000010000b
  jz @f
  mov al,'1'
@@:
  call _draw_char
  _f_setcolor 6
  mov edi,(ScreenWidth*7+78)
  mov al,'0'
  test registers_save.prg_eflags,0001000000000b
  jz @f
  mov al,'1'
@@:
  call _draw_char
  _f_setcolor 7
  mov edi,(ScreenWidth*8+78)
  mov al,'0'
  test registers_save.prg_eflags,0010000000000b
  jz @f
  mov al,'1'
@@:
  call _draw_char

  ;NEW : v1.06 : Now prints al='x'
  mov ah,registers_color
  mov edi,(ScreenWidth*9+78)
  mov al,bptr registers_save.prg_eax
  call _draw_char

  ; plot the stack frame 
  mov edi,(ScreenWidth*(ScreenHeight-16)+61)
  mov esi,Frame_Ptr

stlplol:

  .if ( esi == registers_save.prg_esp)
    mov edx,offset stk_ptrmesg
    call plot_string
  .elseif ( esi == registers_save.prg_ebp)
    mov edx,offset ebp_ptrmesg
    call plot_string
  .else
    mov edx,offset stk_blankit
    call plot_string
  .endif

  push fs
  mov fs,word ptr registers_save.prg_ss
  call getdword  ;@ FS:ESI
  pop fs
  .if !carry?
    mov ebx,eax
    mov ah,registers_color
    mov cl,8
    call print_hex
  .else
    mov ah,registers_color
    mov edx,Offset Bad_stack_mesg
    call plot_string
  .Endif
  sub edi,ScreenWidth+8+6
  add esi,4
  cmp edi,(ScreenWidth*16+67)
  jae stlplol

  ; stack frame plotting finished 

  ;******************** plot the six Segment regsiters ***********************

  mov screen_ptr,(62 + ScreenWidth*10 )
  mov ah,registers_color
  xor esi,esi
plot_segloop:
  add screen_ptr, ScreenWidth
  mov edi,screen_ptr
  mov edx,2
plot_segloop01:
  push edx
  mov edx,offset ES_symb
  add edx,esi
  call plot_string
  draw_char '='
  mov ebx,registers_save.prg_es[esi]
  mov cl,4
  ror ebx,16
  call print_hex
  movzx ecx,word ptr registers_save.prg_es[esi]
  lsl ebx,ecx
  jz @f
  sub edi,4
  mov edx,offset nul_sel_measg
  call plot_string
@@:
  add esi,4
  cmp esi,4*6
  pop edx
  jae exit01
  dec edx
  jz plot_segloop
  draw_2char '  '
  jmp plot_segloop01
exit01:

  ;plot the data window
  xor ebx,ebx
  mov ah,heading_color
  .if which_window == DATA_W              ;;if we are active, show actual address
    movzx ebx,data_selected
    mov ah,DATA_offset_color
  .endif
  mov edi,(70+ ScreenWidth*36)                ;show off the address
  add ebx,Data_Offset
  mov cl,8
  call print_hex

  mov esi,Data_Offset
  mov edi,(61+ ScreenWidth*37)
  xor dl,dl             ;;dl = count of data

data_plot_loop:
  push fs
  mov fs,word ptr registers_save.prg_ds
  call getdword  ;@ FS:ESI
  pop fs
  push edi
  push esi
  .If !carry?              ;we can read the char
    mov ebx,eax
    mov ecx,4
    mov esi,edi
@@:
    push ecx
    neg ecx
    add ecx,4
    _d_setcolor dl

    lea edi,[esi+ecx+4*3+1]             ;draw the chars
    draw_char bl

    lea edi,[esi+ecx*2]
    add edi,ecx
    mov cl,2
    ror ebx,8
    call print_hex

    mov ah,registers_color
    draw_char ' '
    pop ecx
    inc dl
    dec ecx
    jnz @b
  .Else         ;we cannot read the char
    mov ecx,4
    mov esi,edi
    add dl,4
@@:
    dec dl
    dec ecx
    _d_setcolor dl    ;draw the chars

    lea edi,[esi+ecx+4*3+1]
    draw_char '?'

    lea edi,[esi+ecx*2]
    add edi,ecx
    draw_2char ''     ;draw the hexes
    mov ah,registers_color
    draw_char ' '
    inc ecx
    loop @b
    add dl,4
  .Endif
  pop esi
  pop edi
  add esi,4
  add edi,80
  cmp edi,(ScreenWidth*(ScreenHeight-2)+61)
  jbe data_plot_loop
  mov maxdgroup_select,dl

  ; plot the intructions 
  ; plot the intructions 
  ; plot the intructions 
  ; plot the intructions 
  ; plot the intructions 

Plot_The_Instructions:

  xor eax,eax ;Program_BaseOffset
  .if ( screen_EIP_value < EAX )
    mov screen_EIP_value,eax
  .endif

  mov current_memory_operand_address,-1
  mov count1,0
  mov displacement_src_EIP,-1
  mov displacement_dest_EIP,-1
  mov esi,screen_EIP_value
  mov line_count,0
  mov InstCursor_flag,FALSE

  mov eax,esi
  mov [old_esi],eax
  mov brkpt_flag,FALSE
  call remove_BreakPoint          ; removes break point at EAX
  jne @f
  mov brkpt_flag,TRUE
@@:

back_more:

  .if selected_line > (ScreenHeight-12)
    mov selected_line,(ScreenHeight-12)
    mov edi,offset string_buffer
    call Decode_instruction
    mov screen_EIP_value,esi

  .elseif selected_line < 0
    inc selected_line
    mov edi,offset string_buffer
    mov old_esi,esi
    mov cl,8
tryagn:
    dec cl
    jz stptry
    xor ebx,ebx ;Program_BaseOffset
    cmp screen_EIP_value , ebx
    je stptry
    dec screen_EIP_value
    mov esi,screen_EIP_value
    mov edi,offset string_buffer
    call Decode_instruction
    cmp esi,old_esi
    jne tryagn
stptry:
    mov esi,screen_EIP_value
    jmp back_more
  .endif

  ; Put back break point if is here
  .if brkpt_flag == TRUE
    mov eax,old_esi
    mov byte ptr [eax],0CCh
  .endif
  ; finished adjusting screen to display current EIP value within in it range 

  .if Step_flag == 1
    mov eax,registers_save.prg_eip
    .if eax < esi
      mov screen_EIP_value,eax
      mov esi,eax
    .endif
    .if eax > screen_ending_EIP
      mov screen_EIP_value,eax
      mov esi,eax
    .endif
    mov selected_EIP,eax
  .endif

mainloop:

  mov screen_ending_EIP,esi

  mov ah,registers_color
  .if Step_flag == 1
    .if registers_save.prg_eip == esi
      mov al,line_count
      mov selected_line,al
      or InstCursor_flag,TRUE
      .if which_window == CODE_W
	mov ah,selected_color
      .endif
      mov Step_flag,FALSE
    .endif
  .else
    mov al,selected_line
    .if line_count == al
      mov selected_EIP,esi
      or InstCursor_flag,TRUE
      .if which_window == CODE_W
	mov ah,selected_color
      .endif
    .endif
  .endif

  ; if current selected instruction is on a break point then temperarily
  ; restore its original opcode so the instruction can be decoded
  ; and displayed.

  push eax
  mov brkpt_flag,FALSE
  mov eax,ESI
  call remove_BreakPoint          ; removes break point at EAX
  pop eax
  jne @f
  mov brkpt_flag,TRUE
  .if ah == selected_color
    mov ah,selected_brkpt_color
  .else
    mov ah,brkpt_color
  .endif
@@:

  ; plot the line's instruction address left of screen

  push eax
  .if ah == registers_color
    mov ah,cs_eip_color
  .endif
  mov edi,(ScreenWidth*1 +1 )
  add edi,count1
  add count1,ScreenWidth
  mov ebx,esi
  mov cl,8
  call print_hex
  pop eax

  ;-- copy string buffer to screen 
  .if registers_save.prg_eip == esi
    mov al,' '
    call _draw_char
    mov al,INSTR_POINTER_CHAR
    call _draw_char
    call _draw_char
    mov al,' '
    call _draw_char
  .else
    draw_horz ' ',4
  .endif

  mov old_esi ,esi

  ; plot the instuction 

  push edi  ;preserve output pos on screen.
  mov edi,offset string_buffer
  push eax  ;preserve Color byte

  call Decode_instruction   ;BUG! mega buggy!

  ;print only 40 chars worth

  callp strlen,edi
  .if eax>=40
    add edi,40
    mov eax,1
  .else
    add edi,eax   ;point to NULL
    mov ebx,80
    sub ebx,eax
    mov eax,ebx
  .endif
@@:
  mov bptr[edi],' '
  inc edi
  dec eax
  jnz @b

  pop eax  ;restore color byte
  pop edi  ;restore screen pos.

  push esi
  mov esi,offset string_buffer
  mov ecx,40
@@:
  mov al,[esi]
  inc esi
  call _draw_char
  dec ecx
  jnz @b
  pop esi

  mov ecx,old_esi   ; get old EIP value
  mov ebx,registers_save.prg_eip
  .if (ecx == ebx) && (JMP_Flag)

  .if (JMP_Address == ECX )
    draw_2char 'JM'  ;this will happen if we jump to the same addr 
    draw_2char 'P '  ;  ie: LOOP $
    draw_2char '< '
  .else
    .if ecx > JMP_Address
      draw_2char 'JM'
      draw_2char 'P '
      draw_2char ' '  ;up
    .else
      draw_2char 'JM'
      draw_2char 'P '
      draw_2char ' '  ;down
    .endif
  .endif

  .else
    draw_horz ' ',6
  .endif

  ; plot the effective address of the mod r/m field 
  push fs
  .IF (AH == selected_brkpt_color) || (AH == selected_color)

    or InstCursor_flag,TRUE
    pushad
    mov edi,24
    .if (MR_Flag == TRUE)
      mov ah,back_color
      draw_horz '',35        ; clear last MR address display
      mov edi,24
      mov ah,back_color_EA
      draw_char ' '
      xor edx,edx
      mov dl,MR_Segment
      shl dl,2  ;Dwords
      mov fs,ds:registers_save.prg_es[edx]
      xor ecx,ecx  ;Program_Addr
      add edx,offset ES_symb
      call plot_string

      draw_2char ':['
      mov ebx,MR_Address
      mov cl,8
      call print_hex

      push ebx
      draw_2char '] '
      draw_2char '= '
      pop esi

      mov ecx,eax    ;preserve ah (colour)
      call getdword  ;@ FS:ESI
      mov ebx,eax
      .if carry?
	mov eax,ecx  ;restore ah (color)
	jmp its_no_good
      .endif
      add esi,4
      call getdword  ;@ FS:ESI+4
      xchg ecx,eax   ;restore ah (color)
      .if !carry?
	push ebx
	push ecx

        push eax
        mov eax,MR_Address
        mov current_memory_operand_address,eax
        xor eax,eax
        mov al,MR_Segment
        shl eax,2  ;*4 (dwords used later)
        mov current_memory_operand_seg,eax
        pop eax

        .if MR_Type == MR_INT
@@:
          ;integer print.
	draw_char '0'
        .if MR_Size == 48
	  mov ebx,ecx
	  mov cl,4
	  rol ebx,16
	  call print_hex
	  draw_char ':'
	.endif
	pop ecx
	pop ebx
        .if (MR_Size == 32) || (MR_Size == 48)
	  mov cl,8
	  call print_hex
        .elseif (MR_Size == 64)
	  mov cl,8
	  push ebx
	  mov ebx,ecx
	  call print_hex
	  pop ebx
	  mov cl,8
	  call print_hex
        .elseif MR_Size == 16
	  mov cl,4
	  rol ebx,16
	  call print_hex
	.else
	  mov cl,2
	  rol ebx,24
	  call print_hex
	.endif

        .else  ;MR_FLOAT;
          ;float (do as INT for now)  BUG!
          jmp @b
        .endif

      .else
its_no_good:
	mov edx,offset inv_adr_mesg
inval_addre:
	call plot_string
      .endif
      draw_char ' '
    .else
      mov ah,back_color
      draw_horz '',35
    .endif
    popad

  .ENDIF
  pop fs

  ; Put back break point if is here
  .if brkpt_flag == TRUE
    mov eax,screen_ending_EIP
    mov byte ptr [eax],0CCh
  .endif

  inc line_count
  cmp line_count,CODE_WINDOW_HEIGHT
  jb mainloop

  ; If the selected instruction was not displayed then
  ; replot the screen with the selected instruction at the top.

  .If InstCursor_flag == FALSE
    mov selected_line,0
    mov eax,registers_save.prg_eip
    mov selected_EIP,eax
    mov screen_EIP_value,eax
    jmp Plot_The_Instructions
  .Endif

  ret

  inv_adr_mesg db 'illegal address$'
;  inv_sel_mesg db ':   illegal selector$'
  Bad_stack_mesg db '$'
  nul_sel_measg db 'null$'

refresh_screen ENDP

.code
; Calls Handle_Debug_exception from a non-exception handler (ie: INT handler)
Call_Handle_Debug_Exception macro
  local return

  push ss
  push esp
  add dword ptr[esp],4*4    ;remove SS+EIP+CS+Eflags on stack
  push dword ptr[esp+4*4]   ;Eflags
  push dword ptr[esp+4*4]   ;CS
  push dword ptr[esp+4*4]   ;EIP
  push dword ptr 0      ;error code
  push dword ptr 0      ;ret CS
  push dword ptr 0      ;ret EIP
  call Handle_Debug_Exception
  add esp,3*4
  push eax
  mov eax,[esp+1*4]       ;EIP
  mov [esp+6*4],eax
  mov eax,[esp+2*4]       ;CS
  mov [esp+7*4],eax
  mov eax,[esp+3*4]       ;Eflags
  mov [esp+8*4],eax
  pop eax
  add esp,5*4             ;BUG!! ignoring SS:ESP on stack
  sti
  iretd
endm

;
;      ISR for terminate hooking  INT21h AH=4Ch
;
;  Used to trap any INT21h AH=4Ch. so can notify the user that the program
; has terminated
;
;
terminate_Hooker PROC 
  cli
  .IF ( ah == 4Ch ) && (cs:DebuggerTerminated == FALSE)

    push ds
    mov ds,cs:seldata
    .if _cpl==0
      push eax
      xor eax,eax                 ;disable debug registers
      mov DR7,eax
      pop eax
    .endif
    mov JustTerminated,1
    pop ds
    sub dword ptr [esp],2    ;move back to over INT 21h

    Call_Handle_Debug_Exception  ;does not return

  .ENDIF

  jmp cs:saved_int21h

terminate_Hooker ENDP

exit_code db ' Program terminated with exit code INT 21h AH=4Ch $'

;
;
;
;       PRINTS A MESSAGE IN THE SCREEN IN A BOX and waits for a key.
;Expects:
;              EDX = points to a string that ends with a '$'
;
; carage return characters 10 are allowed.
;
;
print_message_box PROC 
  local height :byte
  local lenth :byte
  local ok_pos:dword

  push edx
  mov height,6
  mov lenth,0
  mov cl,0
  mov ok_pos,0
@@:
  mov al,[edx]
  add edx,2
  cmp al,0
  je @b
  dec edx
  .if al == 10
    add height,2
    add ok_pos,ScreenWidth * 2
    mov cl,0
  .endif
  .if cl > lenth
    mov lenth,cl
  .endif
  inc cl
  cmp al,'$'
  jne @b
  add lenth,6
  movzx edi,lenth
  sub edi,ScreenWidth
  neg edi
  shr edi,1
  add edi,ScreenWidth* (ScreenHeight/2 - 3)
  push edi
  mov ah,mesg_box_color
  push edi
  add edi,ScreenWidth
  draw_vert '',height
  mov edi,[esp]   ;pop edi
		  ;push edi
  draw_char ''
  draw_horz '',lenth
  draw_char ''
  add edi,ScreenWidth-1
  draw_vert '',height
  pop edi
  add edi,ScreenWidth+1
  mov ch,height
@@:
  push edi
  draw_horz ' ',lenth
  pop edi
  add edi,ScreenWidth
  dec ch
  jnz @b
  dec edi
  draw_char ''
  draw_horz '',lenth
  draw_char ''
  pop edi
  add edi,ScreenWidth*3 + 3
  pop edx
  mov ah,mesg_box_text_color
  add ok_pos,edi
  call plot_string
  mov edi,ok_pos
  add edi,ScreenWidth*3
  movzx eax,lenth
  shr eax,1
  lea edi,[edi+eax-3]
  mov ah,(mesg_box_color and 0f0h) or 8
  mov edx,offset mesg_OK_
  call plot_string
  sub edi,ScreenWidth+5
  mov ah,0A1h
  mov edx,offset mesg_OK
  call plot_string
  mov ah,(mesg_box_color and 0f0h) or 8
  draw_char ''

  xor eax,eax  ;Zero_addr     ; clear the keyboard buffer
  mov dx,[eax+41ch]
  mov [eax+41ah],dx
@@:
  call getkey
  cmp al,1ch     ;Enter key?
  jnz @b
  call Debuggers_Video
  ret
  mesg_OK db ' OK $'
  mesg_OK_ db '$'
print_message_box ENDP

init_kbd proc
  in al,0a1h
  mov ah,al
  in al,021h
  mov saved_mask,ax

  ifdef debug_kbd
    push ds
    mov ds,cs:seldata
    mov bptr ds:[0b8000h],'X'
    pop ds
  endif

  mov al,-1
  out 0a1h,al
  mov al,0ffh - 2  ;enable KBD only
  out 021h,al

  mov kbd_head,0
  mov kbd_tail,0

  mov using_kbd,1

  sti

  ret
init_kbd endp

uninit_kbd proc

  cli

  ifdef debug_kbd
    push ds
    mov ds,cs:seldata
    mov bptr ds:[0b8000h],'x'
    pop ds
  endif

  mov using_kbd,0

  mov ax,saved_mask
  out 021h,al
  mov al,ah
  out 0a1h,al

  ret
uninit_kbd endp

kbd_buf_size equ 128
kbd_buf db kbd_buf_size dup (?)
kbd_head db 0
kbd_tail db 0

using_kbd db 0
ifdef debug_keymain
  debug_keymain_pos dd 0
endif

insert_key proc uses ebx ecx
  ;al=new key
  xor ebx,ebx
  mov bl,kbd_head
  inc bl
  .if bl>=kbd_buf_size
    xor bl,bl
  .endif
  .if bl == kbd_tail
    ret  ;buffer full
  .endif
  mov cl,bl
  mov bl,kbd_head
  add ebx,offset kbd_buf
  mov [ebx],al
  mov kbd_head,cl
  ret
insert_key endp

getkey proc uses ebx ecx
  xor ebx,ebx
@@:
  mov bl,kbd_tail
  .if bl == kbd_head
    jmp @b  ;wait for a key
  .endif
  xor ecx,ecx
  mov ecx,offset kbd_buf
  add ecx,ebx
  mov al,[ecx]
  inc bl
  .if bl>=kbd_buf_size
    xor bl,bl
  .endif
  mov kbd_tail,bl
  ret
getkey endp

;
;
;
;      SETS UP THE VIDEO SCREEN FOR THE DEBUGGER
;
;
;
Debuggers_Video PROC 

  pushad

  .IF users_screen_flag

    cli

    call save_CompleteVideoState

    mov ax,3
    int_10h

    mov ax,1112h              ;  Text Mode 80x50
    xor bx,bx
    int_10h
    mov ax,1200h
    mov bx,20h
    int_10h

    sti

  .ENDIF

  ; disable character blinking
  mov dx,3DAh
  in al,dx
  mov dl,0C0h
  mov al,10h or 20h
  out dx,al
  inc dl
  in al,dx
  and al,NOT 8
  dec dl
  out dx,al

  ; turn off cursor 
  mov dx,3D4h
  mov ax,200Ah
  out dx,ax

  ; draw the screen 
  mov edi,0B8000h
  mov ax,back_color shl 8
  mov ecx, ScreenWidth * ScreenHeight
  cld
  _winnt
  rep stosw

  mov ah,boarder_color
  mov edi,(0+ 80*1 )
  draw_vert '',39
  draw_char ''
  draw_horz '',59
  draw_char ''
  mov edi,(0+ 80*0 )
  draw_char ''
  draw_horz '',59
  draw_char ''
  draw_horz '',13
  draw_char ''
  draw_horz '',4
  draw_char ''
  mov edi,(0+ 80*41 )
  draw_vert '',8
  mov edi,(60+ 80*41 )
  draw_vert '',8
  mov edi,(60+ 80*11 )
  draw_vert '',29
  mov edi,(60+ 80* 1 )
  draw_vert '',9
  draw_char ''
  draw_horz '',13
  draw_char ''
  draw_horz '',4
  draw_char ''
  mov edi,(79+ 80*1 )
  draw_vert '',9
  mov edi,(79+ 80*11 )
  draw_vert '',38
  mov edi,(74+ 80*1 )
  draw_vert '',9

  mov edi,(60+ ScreenWidth*14)
  draw_char ''
  draw_horz '',18
  draw_char ''

  mov edi,(60+ 80*35)
  draw_char ''
  draw_horz '',18
  draw_char ''

  mov edi,(61+ 80*36)
  mov edx,offset dat_mesg
  call plot_string

  mov edi,(64+ ScreenWidth*15 )
  mov edx,offset stk_mesg
  call plot_string

  ;* plot integer register names *
  mov edi,(80*1+62)
  mov edx,offset EAX_symb
  mov ah,registers_color
;  mov _reg_order,0
@@:
comment #
  .if edx==offset EAX_symb+4*1   ;;change order of regs!
    .if _reg_order
      mov edx,offset EAX_symb+4*4
    .else
      mov edx,offset EAX_symb+4*2
    .endif
  .elseif edx==offset EAX_symb+4*2
    mov edx,offset EAX_symb+4*3
  .elseif edx==offset EAX_symb+4*3
    mov edx,offset EAX_symb+4*1
    inc _reg_order
  .endif
#
  call plot_string
  add edi,80 - 3
  add edx,1
  cmp edx,offset EAX_symb+9*4
  jb @b

  mov ah,flag_registers_color
  mov edi,(80*1+76)
  draw_2char 'c='   ; DRAW CARRY FLAG STATE 
  mov edi,(80*2+76)
  draw_2char 'z='   ; DRAW ZERO  FLAG STATE 
  mov edi,(80*3+76)
  draw_2char 's='   ; DRAW SIGN  FLAG STATE 
  mov edi,(80*3+76)
  draw_2char 's='   ; DRAW SIGN  FLAG STATE 
  mov edi,(80*4+76)
  draw_2char 'o='   ; DRAW OVERFLAW FLAG STATE 
  mov edi,(80*5+76)
  draw_2char 'p='   ; DRAW PARITY FLAG STATE 
  mov edi,(80*6+76)
  draw_2char 'a='   ; DRAW AUX FLAG STATE 
  mov edi,(80*7+76)
  draw_2char 'i='   ; DRAW INTERRUPT FLAG STATE 
  mov edi,(80*8+76)
  draw_2char 'd='   ; DRAW DIRECTION FLAG STATE 
;NEW : v1.06 : prints 'AL=x'
  mov edi,(80*9+75)
  draw_2char 'al'   ; AL ASCII VALUE 
  draw_char  '='

  mov users_screen_flag , FALSE
  popad
  ret
Debuggers_Video ENDP

;
;
;  The debugger's low level keyboard handler ( used only during debugging )
;
;
keyboard_ISR PROC 

  .if cs:using_kbd == 0
    jmp cs:saved_IRQ1
  .endif

  push ds
  push es
  push eax
  mov ax,cs:seldata
  mov ds,ax
  mov es,ax

  in al,60h             ;get scan code from periferal port A
  call insert_key

  mov al,20h  ; Send EOI cmd to 8259
  out 20h,al
  pop eax
  pop es
  pop ds
  sti
  iretd

keyboard_ISR ENDP

;
;
;    Floating Point Error Exception Handler.
;
;
DEVICE_Unavailable_Exception PROC

  crash 7
  showexc '7'

  call Switch2Stack

  push edx
  mov edx,offset bad_fpu_mesg
  jmp Close_the_fatal_fault

  bad_fpu_mesg db 'Device Not Available  exception (7) $'

DEVICE_Unavailable_Exception ENDP

;
;
;    Floating Point Error Exception Handler. (exception #10h)
;
;
FPU_Exception PROC 

  crash 10h
  showexc 'v'

  call Switch2Stack

  .IF ( FPU_installed )
    push eax
    xor eax,eax
    fstsw ax
    test al,80h                 ; test Error Summary Status
    pop eax
    jz EXIT_INT
    push edx              ; save EDX
    mov edx,offset fpu_mesg
    jmp Close_the_fatal_fault
  .ENDIF

EXIT_INT:

  call RestoreStack   ;v1.00 Beta #3 : missed this one

  jmp cs:saved_int16

  fpu_mesg db '  Floating Point Exception (16)$'

FPU_Exception ENDP

_replace_first db 0
_replace_first_data db ?
_replace_first_offset dd ?

;
;
;    This is the INT 3 breakpoint exception handler.
;
; caused from opcode CCh
;
;
BreakPoint_Exception PROC

  crash 3
  showexc '3'

  call Switch2Stack
  push ds
  pushad
  mov ax,cs:seldata
  mov ds,ax

  mov dx,ds:[41ch]    ;clear DOS kbd buffer
  mov ds:[41ah],dx

  cmp special_brkpt,TRUE
  je special_CCh
nospecial_CCh:
  mov eax,[esp+4*9]._exc._eip      ; get EIP from stack
  push es
  push ds
  pop es
  dec eax

  call remove_BreakPoint          ; removes break point at EAX
  pop es
  jne not_a_brkpt

  dec dword ptr [esp+4*9]._exc._eip         ; decreament  EIP on stack

  .if program_is_running == TRUE
    popad
    pop ds
    or byte ptr [esp+1]._exc._eflags,1   ; set TF on stack

    call Handle_Debug_Exception

    call RestoreStack

    retf
  .else
    popad
    pop ds

    call RestoreStack

    retf                                       ; set to debugging mode (again)
  .endif

not_a_brkpt:
  ;check if I3HERE is enabled (NEW : v1.06b)
  cmp _i3here,OFF
  je @f

  cmp byte ptr [eax],0CCh
  je normal_CCh
  dec eax
  cmp word ptr [eax],03cdh
  je normal_INT_3

@@:
  popad
  pop ds

  call RestoreStack

  retf

normal_CCh:
  .if program_is_running == TRUE
    sub dword ptr [esp+4*9]._exc._eip,1       ; decreament  EIP on stack
    jmp exit
  .endif
  jmp exit

normal_INT_3:
  .if program_is_running == TRUE
    sub dword ptr [esp+4*9]._exc._eip,2       ; decreament  EIP on stack
    jmp exit
  .endif
  popad
  pop ds

  call RestoreStack

  retf

special_CCh:
  mov ebx,dword ptr [esp+4*9]._exc._eip      ; look to see if on a special
  dec ebx
  mov eax,special_brkpt_EIP
  cmp ebx,eax
  jne nospecial_CCh
  mov special_brkpt,FALSE
  dec dword ptr [esp+4*9]._exc._eip
  mov dl,special_brkpt_save
  mov [eax],dl                ; delete the 0CCh

exit:
  popad
  pop ds
  or byte ptr [esp+1]._exc._eflags,1   ; set TF on stack

  call Handle_Debug_Exception

  call RestoreStack

  retf

BreakPoint_Exception ENDP

;
;
;    The General Protection handler  ( Interrupt 13h )
;
;
GeneralProtection_Exception PROC

  showexc 'd'

  call Switch2Stack

  ; Read the ISR (Interrupt Service Register) to see if a IRQ is waiting
  ; to be serviced.
  ;
  push eax
  mov al,00001011b    ; OCW3 to read ISR on next read
  out 20h,al          ; write to base I/O address of 8259A
  in al,20h           ; read ISR
  and al,al
  pop eax
  jz non_V86_exec     ; Brach if a IRQs is not awaiting

  call RestoreStack   ;v1.00 Beta #3 : missed this one

  crash 13h

  jmp cs:saved_int13

non_V86_exec:

  .IF cs:Testing_Addr == TRUE
    push ds
    mov ds,cs:seldata
    mov Testing_Addr,FALSE
    pop ds
    mov dword ptr [esp]._exc._eip,Test_Location_End  ; skip intruction that caused

    call RestoreStack

    retf          ;by PQ : FIXED
  .ENDIF

  crash 13h

  push edx
  mov edx,offset GP_mesg
  jmp Close_the_fatal_fault

  align 4

  GP_mesg db 'Instruction Caused a General Protection Exception $'

GeneralProtection_Exception endp

;
;
;    The Invalid Opcode handler  ( Interrupt 6 )
;
;
;
InvalidOpcode_Exception PROC

  crash 6
  showexc '6'

  call Switch2Stack

  push edx
  mov edx,offset badI_mesg
  jmp Close_the_fatal_fault

  badI_mesg db 'Program executed an Invalid Opcode $'

InvalidOpcode_Exception ENDP

;
;
;    The Divide by Zero handler  ( Interrupt 0 )
;
;
;
DivideError_Exception PROC 

  crash 0
  showexc '0'

  call Switch2Stack

  push edx            ; save EDX
  mov edx,offset divide0_mesg
  jmp Close_the_fatal_fault

  divide0_mesg db '  Division By Zero Error$'


DivideError_Exception ENDP

;
;
;    The Page Fault handler  ( Interrupt 14h )
;
;
;
Page_Fault_Exception PROC 

  showexc 'e'

  call Switch2Stack

  ; Read the ISR (Interrupt Service Register) to see if an IRQ is waiting
  ; to be serviced for VCPI server.

  push eax
  mov al,00001011b    ; OCW3 to read ISR on next read
  out 20h,al          ; write to base I/O address of 8259A
  in al,20h           ; read ISR
  and al,al
  pop eax
  jz skip_8259pf      ; Brach if a IRQs is not awaiting

  call RestoreStack   ;v1.00 Beta #3 : missed this one

  crash 14h

  jmp cs:saved_int14

skip_8259pf:

  .IF cs:Testing_Addr == TRUE
    push ds
    mov ds,cs:seldata
    mov Testing_Addr,FALSE
    pop ds
    mov dword ptr [esp]._exc._eip,Test_Location_End  ; skip intruction that caused

    call RestoreStack

    retf          ;by PQ : FIXED
  .ENDIF

  crash 14h

  push edx
  mov edx,offset PF_mesg
  jmp Close_the_fatal_fault

  PF_mesg db 'Instruction caused a Page fault $'

Page_Fault_Exception ENDP


;
;
; This rotine displays the exception error message and stuff
; Used by the above CPU exception routines
;
;
Close_the_fatal_fault PROC    ;Note : EDX is on the stack!
  push ds
  mov ds,cs:seldata

  .if _cpl==0
    push eax
    xor eax,eax               ;disable debug registers
    mov DR7,eax
    pop eax
  .endif

  mov JustFatalFaulted,1
  mov JustFatalStr,edx
  mov Step_flag,TRUE

  pop ds
  pop edx
  or byte ptr [esp+1]._exc._eflags,1    ; set TF on stack
  call Handle_Debug_Exception           ; set to debugging mode (again)

  call RestoreStack

  retf
Close_the_fatal_fault ENDP

hardwareInstruc_mesg db ' Instruction Fault on Breakpoint Register '
DRx_mesg1 db '    $'
hardwareData_mesg db '  Data Trap on Breakpoint Register '
DRx_mesg2 db '    $'

;
;
;     THE MAIN  DEBUG EXCEPTION HANDLER     ( INTERRUPT ONE )
;
;
Debug_Exception PROC 

  crash 1
  showexc '1'

  call Switch2Stack

  pushad
  push ds
  push es
  mov ax,cs:seldata
  mov ds,ax
  mov es,ax
  .IF cs:Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    pop es
    pop ds
    popad

    call RestoreStack

    retf          ;by PQ :FIXED for PMODE/w  ; return  to intruction on in EA test mode
  .ENDIF

  ;  GET DEBUG EXCEPTION STATUS from DR6 
  .if _cpl==0
    mov eax,DR6
    mov ebx,DR7
  .else
    xor eax,eax
    xor ebx,ebx
  .endif

  mov DRx_mesg1,'0'
  mov DRx_mesg2,'0'
  test al,1
  jz brkpt1
  test bl,3
  jz brkpt1
  shr ebx,16
  jmp found_brkptReg

brkpt1:
  mov DRx_mesg1,'1'
  mov DRx_mesg2,'1'
  test al,2
  jz brkpt2
  test bl,0ch
  jz brkpt2
  shr ebx,20
  jmp found_brkptReg

brkpt2:
  mov DRx_mesg1,'2'
  mov DRx_mesg2,'2'
  test al,4
  jz brkpt3
  test bl,030h
  jz brkpt3
  shr ebx,24
  jmp found_brkptReg

brkpt3:
  mov DRx_mesg1,'3'
  mov DRx_mesg2,'3'
  test al,8
  jz no_brkpt
  test bl,0c0h
  jz no_brkpt
  shr ebx,28
found_brkptReg:
  test bl,03
  jz RW0
  push offset hardwareData_mesg
  jmp RW1
RW0:
  push offset hardwareInstruc_mesg
RW1:
  call Debuggers_Video
  ;v1.00 Beta #4 : some of the following was wrong
  mov eax,[esp+4*11]._exc._eip          ; get EIP form stack
  mov selected_EIP,eax
  mov Step_flag,TRUE
  mov registers_save.prg_eip,eax
  call refresh_screen
  pop edx
  call print_message_box
  or dword ptr [esp+4*10]._exc._eflags,010100h    ; Set TF and RF
  jmp Step_debug

no_brkpt:
  test eax,4000h
  jz normal_INT1

Step_debug:
  .if _cpl==0   ;v1.00 Beta #4 (was not protecting the instruction)
    xor eax,eax
    mov DR6,eax               ; must clear the DR6 bits
  .endif
normal_INT1:
  pop es
  pop ds
  popad

  call Handle_Debug_Exception

  call RestoreStack

  retf

Debug_Exception ENDP

;
;
;     THE GENARAL DEBUG EXCEPTION HANDLER for exceptions from  breakpoints
; , TF or  any breakpoint registers.
;
;   This is the main routine of the whole debugger.
;
;
Handle_Debug_Exception PROC 

  push ds
  mov ds,cs:seldata

  mov DebuggerInUse,TRUE

  pop registers_save.prg_ds
  mov registers_save.prg_eax, eax

  mov eax,[esp+4]._exc._eip             ;+4 cause of RET on stack
  mov registers_save.prg_eip ,eax
  mov eax,[esp+4]._exc._cs
  mov registers_save.prg_cs ,eax
  mov eax,[esp+4]._exc._eflags
  mov registers_save.prg_eflags,eax

  mov registers_save.prg_ebx, ebx
  mov registers_save.prg_ecx, ecx
  mov registers_save.prg_edx, edx
  mov registers_save.prg_edi, edi
  mov registers_save.prg_esi, esi
  mov registers_save.prg_ebp, ebp

  mov eax,[esp+4]._exc._esp
  mov registers_save.prg_esp, eax
  mov eax,[esp+4]._exc._ss
  mov registers_save.prg_ss , eax

  mov registers_save.prg_es , es
  mov registers_save.prg_fs , fs
  mov registers_save.prg_gs , gs

  mov eax,registers_save.prg_eax

  pushad
  push fs
  push es

  push ds           ; Load ES with data selector
  pop es

  .if _replace_first
    dec _replace_first
    mov al,_replace_first_data
    mov ebx,_replace_first_offset
    mov [ebx],al
  .endif

  cld

  .IF ( FPU_installed )
    fsave registers_save.fpu_envir    ; save 108 bytes
  .ENDIF

  .if _mmx
    db 0fh,77h  ;emms   ;reset FPU status
  .endif

  ;

  mov eax,registers_save.prg_eip
  mov selected_EIP,eax
  mov Step_flag,TRUE

  .if Keep_Frame_Ptr == FALSE
    mov eax,registers_save.prg_esp
    mov Frame_Ptr,eax
  .elseif
    mov Keep_Frame_Ptr,FALSE
  .endif

  call init_kbd

  ;FIX : v1.00a : this was in terminate_hooker() before init_kbd() was called
  .if JustTerminated
    dec JustTerminated
    mov users_screen_flag,FALSE
    .If program_is_running
      mov users_screen_flag,TRUE
    .Endif
    call Debuggers_Video
    mov edx,offset exit_code
    call print_message_box
  .elseif users_screen_flag == TRUE
    call Debuggers_Video
  .endif

  call refresh_screen

  mov program_is_running,FALSE

  .if JustFatalFaulted
    mov edx,JustFatalStr
    call print_message_box
  .endif

  .if IntroMessageNotShown == TRUE
    mov edx,offset intro_mesg
    call print_message_box
    mov IntroMessageNotShown,FALSE
  .endif

main_loop:

  call refresh_screen

  cmp Until_Here,0
  jnz Run_Until_Here      ;enter our state machine

  ;modified for window system
key_waitloop:

  test Key_flags,CTL      ; look at CTL flag
  jz @@no_ctrl
  call Display_DRx_info

  movzx edx,which_window
  mov edx,[Menu_ctrl_bar+edx*4]
  jmp disp_menu_bar

@@no_ctrl:
  call Display_387_info
  test Key_flags,ALT      ; look at ALT flag
  jz @@no_alt

  movzx edx,which_window
  mov edx,[Menu_alt_bar+edx*4]
  jmp disp_menu_bar

@@no_alt:
  test Key_flags,SHF      ; look at SHiFt flag
  jz @@no_shift

  movzx edx,which_window
  mov edx,[Menu_shift_bar+edx*4]
  jmp disp_menu_bar

@@no_shift:
  movzx edx,which_window
  mov edx,[Menu_bar+edx*4]

disp_menu_bar:
  mov edi,(0 + 80*49 )
  mov ah,menu_color
  call plot_string
skip_disp:

  ;

  call getkey

  ifdef debug_keymain
    pushad
    mov bl,al
    mov cl,2
    mov edi,debug_keymain_pos
    add debug_keymain_pos,3
    mov ah,selected_color
    ror ebx,8
    .if debug_keymain_pos>=6*3
      mov debug_keymain_pos,0
    .endif
    call print_hex
    popad
  endif

  ;modi
  .if al == 38h                 ; set for 'Alt'
    or Key_flags,ALT
  .elseif al == (38h or 80h)
    and Key_flags,Not ALT       ; clear 'Alt'
  .elseif al == 1Dh             ; set for 'Ctrl'
    or Key_flags,CTL
  .elseif al == (1Dh or 80h)
    and Key_flags,Not CTL       ; clear 'Ctrl'
  .elseif (prev_key_code != 0E0h)
    .if (al == 2Ah) || (al == 36h)    ; set for 'Shift'
      or Key_flags,SHF
    .elseif (al == (2Ah or 80h)) || (al == (36h or 80h))
      and Key_flags,Not SHF           ; clear 'Shift'
    .endif 
  .endif

  ; if ALT+CRL then turn off key repeat rate
  ;
  ; mov fast_scroll,TRUE

  mov prev_key_code,al

  test al,80h
  jnz key_waitloop
  mov ah,al

  mov al,Key_flags

  ;new dispatcher
  movzx ebx,which_window
  mov ebx,[Cmd_Tables+ebx*4]
  xor edx,edx
@@:
  .repeat
    mov cx,[ebx].tbl_mask
    not cx
    and cx,ax

    .if cx == [ebx].tbl_key
      jmp [ebx].tbl_addr        ;ax = key, cx=masked key
    .endif
    add ebx,sizeof tbl
  .until [ebx].tbl_key == 0

  .if edx == 0
    mov ebx,offset Shared_Table
    inc edx    ;set edx
    jmp @b     ;;try again for shared cmd table
  .endif
  jmp main_loop

  ;command tables for main_loop
  tbl struc
    tbl_key dw 0    ;;key to match
    tbl_addr dd 0   ;;addr to jump
    tbl_mask dw 0   ;;ignore these bits, if on
  tbl ends

  Cmd_Tables label ptr
  dd Code_Table
  dd Reg_Table
  dd Flag_Table
  dd Data_Table

  Shared_Table label ptr          ;;shared by all windows
  tbl <ALT+F4,back_step,CTL>
  tbl <ALT+F5,user_screen,CTL>
  tbl <ALT+X_KEY,exit_debugger,CTL>
  tbl <F7,step_intruc,CTL>
  tbl <F8,large_steping,CTL>
  tbl <F9,run_program,CTL>
  tbl <F1,show_help,ALT>
  tbl <CTL+F2,goto_start,ALT>
  tbl <SHF+CSR_UP,data_scroll_up>
  tbl <SHF+CSR_DN,data_scroll_dn>
  tbl <SHF+PGUP,data_pgup>
  tbl <SHF+PGDN,data_pgdn>
  tbl <ALT+KEYPAD_PLUS,Frame_Down>
  tbl <ALT+KEYPAD_MINUS,Frame_Up>
  tbl <ALT+KEYPAD_STAR,Frame_ESP>
  tbl <ALT+KEYPAD_SLASH,Frame_EBP>
  tbl <ALT+I_KEY,toggle_i3here>
  tbl <ALT+M_KEY,toggle_show_mmx>
  tbl <ALT+F_KEY,toggle_show_mmx>
  tbl <0,0,0>

  Code_Table label tbl
  tbl <TAB_KEY,move_to_regs>
  tbl <CTL+TAB_KEY,move_to_dgroup>
  tbl <SHF+TAB_KEY,move_to_dgroup>
  tbl <SPACE_KEY,setdgroup_memoprerand_data>
  tbl <SHF+SPACE_KEY,setdgroup_memoprerand>
  tbl <CSR_UP,sel_up>
  tbl <CSR_DN,sel_dn>
  tbl <PGDN,page_Down>
  tbl <PGUP,page_Up>
  tbl <F2,set_brkpt>
  tbl <F4,Run_Until_Here>
  tbl <CTL+N_KEY,here>
  tbl <CTL+O_KEY,show_current_inst>
  tbl <PERIOD,show_current_inst>
  tbl <NUM_0,chg_code_offset,CTL>
  tbl <NUM_1,chg_code_offset,CTL>
  tbl <NUM_2,chg_code_offset,CTL>
  tbl <NUM_3,chg_code_offset,CTL>
  tbl <NUM_4,chg_code_offset,CTL>
  tbl <NUM_5,chg_code_offset,CTL>
  tbl <NUM_6,chg_code_offset,CTL>
  tbl <NUM_7,chg_code_offset,CTL>
  tbl <NUM_8,chg_code_offset,CTL>
  tbl <NUM_9,chg_code_offset,CTL>
  tbl <A_KEY,chg_code_offset,CTL>
  tbl <B_KEY,chg_code_offset,CTL>
  tbl <C_KEY,chg_code_offset,CTL>
  tbl <D_KEY,chg_code_offset,CTL>
  tbl <E_KEY,chg_code_offset,CTL>
  tbl <F_KEY,chg_code_offset,CTL>
  tbl <BS_KEY,chg_code_offset_del,CTL>
  tbl <KEYPAD_PLUS,inc_code_offset,CTL+SHF>
  tbl <KEYPAD_MINUS,dec_code_offset,CTL+SHF>
  tbl <0,0,0>

  Reg_Table label tbl
  tbl <TAB_KEY,move_to_flag>
  tbl <CTL+TAB_KEY,move_to_code>
  tbl <SHF+TAB_KEY,move_to_code>
  tbl <CSR_UP,reg_up>
  tbl <CSR_DN,reg_dn>
  tbl <NUM_0,chg_reg,SHF>
  tbl <NUM_1,chg_reg,SHF>
  tbl <NUM_2,chg_reg,SHF>
  tbl <NUM_3,chg_reg,SHF>
  tbl <NUM_4,chg_reg,SHF>
  tbl <NUM_5,chg_reg,SHF>
  tbl <NUM_6,chg_reg,SHF>
  tbl <NUM_7,chg_reg,SHF>
  tbl <NUM_8,chg_reg,SHF>
  tbl <NUM_9,chg_reg,SHF>
  tbl <A_KEY,chg_reg,SHF>
  tbl <B_KEY,chg_reg,SHF>
  tbl <C_KEY,chg_reg,SHF>
  tbl <D_KEY,chg_reg,SHF>
  tbl <E_KEY,chg_reg,SHF>
  tbl <F_KEY,chg_reg,SHF>
  tbl <BS_KEY,chg_reg_del,SHF>
  tbl <KEYPAD_PLUS,inc_reg,SHF+CTL>
  tbl <KEYPAD_MINUS,dec_reg,SHF+CTL>
  tbl <0,0,0>

  Flag_Table label tbl
  tbl <TAB_KEY,move_to_dgroup>
  tbl <CTL+TAB_KEY,move_to_regs>
  tbl <SHF+TAB_KEY,move_to_regs>
  tbl <CSR_UP,flag_up>
  tbl <CSR_DN,flag_dn>
  tbl <SPACE_KEY,toggle_flag>
  tbl <ENTER_KEY,toggle_flag>
  tbl <NUM_0,reset_flag>
  tbl <NUM_1,set_flag>
  tbl <0,0,0>

  Data_Table label tbl
  tbl <PERIOD,data_show_current_inst>
  tbl <TAB_KEY,move_to_code>
  tbl <CTL+TAB_KEY,move_to_flag>
  tbl <SHF+TAB_KEY,move_to_flag>
  tbl <CSR_UP,data_up>
  tbl <CSR_DN,data_dn>
  tbl <CSR_LFT,data_left>
  tbl <CSR_RGT,data_right>
  tbl <PGDN,data_pgdn>
  tbl <PGUP,data_pgup>
  tbl <NUM_0,chgdgroup,CTL>
  tbl <NUM_1,chgdgroup,CTL>
  tbl <NUM_2,chgdgroup,CTL>
  tbl <NUM_3,chgdgroup,CTL>
  tbl <NUM_4,chgdgroup,CTL>
  tbl <NUM_5,chgdgroup,CTL>
  tbl <NUM_6,chgdgroup,CTL>
  tbl <NUM_7,chgdgroup,CTL>
  tbl <NUM_8,chgdgroup,CTL>
  tbl <NUM_9,chgdgroup,CTL>
  tbl <A_KEY,chgdgroup,CTL>
  tbl <B_KEY,chgdgroup,CTL>
  tbl <C_KEY,chgdgroup,CTL>
  tbl <D_KEY,chgdgroup,CTL>
  tbl <E_KEY,chgdgroup,CTL>
  tbl <F_KEY,chgdgroup,CTL>
  tbl <BS_KEY,chgdgroup_del,CTL>
  tbl <KEYPAD_PLUS,incdgroup,CTL>
  tbl <KEYPAD_MINUS,decdgroup,CTL>
  tbl <0,0,0>


  ;; Code Window Management 

continue_debugging:

  .IF ( FPU_installed )
    frstor registers_save.fpu_envir     ; load 108 bytes
  .ENDIF

  call uninit_kbd

  pop es
  pop fs
  popad

  mov ds,registers_save.prg_ds
  push eax
  mov eax,cs:registers_save.prg_eflags
  mov [esp+8]._exc._eflags,eax
  mov eax,cs:registers_save.prg_cs
  mov [esp+8]._exc._cs,eax
  mov eax,cs:registers_save.prg_eip
  mov [esp+8]._exc._eip,eax
  pop eax

  mov DebuggerInUse,FALSE

  ret

  ;
sel_up:
  dec selected_line
  jmp main_loop

  ;
sel_dn:
  inc selected_line
  jmp main_loop

  ;
page_Up:
  sub selected_line,(ScreenHeight-10)
  jmp main_loop

  ;
page_Down:
  mov eax,screen_ending_EIP
  mov screen_EIP_value,eax
  jmp main_loop

  ;
setdgroup_memoprerand_data:

  mov eax,current_memory_operand_address
  cmp eax,-1
  je @f
  mov esi,eax
  push fs
  mov eax,offset registers_save.prg_es
  add eax,current_memory_operand_seg
  mov fs,word ptr[eax]
  call getdword  ;@ FS:ESI
  pop fs
  .if !carry?
    mov Data_Offset,eax
  .endif
@@:
  jmp main_loop


  ;
setdgroup_memoprerand:

  mov eax,current_memory_operand_address
  cmp eax,-1
  je @f
  mov Data_Offset,eax
@@:
  jmp main_loop

  ;
large_steping:
  mov eax,registers_save.prg_eip
  call remove_BreakPoint          ; removes break point at EAX

  call CheckVGAport

  mov esi,eax
  mov edi,offset string_buffer
  call Decode_instruction
     ;ESI = offset of next opcode
  cmp dword ptr string_buffer,06c6c6163h          ; look for "call"
  je skip_small_step
  cmp dword ptr string_buffer,0706f6f6ch          ; look for "loop"
  je skip_small_step
;LOOK FOR REPx
  and dword ptr string_buffer,0ffffffh
  cmp dword ptr string_buffer,00706572h           ; look for "rep"
  jne step_intruc

  ;Must detect instruction after REPx
@@:
  callp Decode_instruction
  ;see if it's a prefix
  cmp DO_Prefix,1
  je @b

skip_small_step:
  mov special_brkpt_EIP,esi
  mov dl,[esi]
  mov special_brkpt_save,dl
  mov byte ptr [esi],0CCh           ; insert the CC
  mov special_brkpt,TRUE
  mov program_is_running,TRUE
  call Restore_Video      ; goto users screen
  and byte ptr[registers_save.prg_eflags+1],0feh  ;clear TF
  mov BacklogRegPTR_head,0                        ;clear backlog
  mov BacklogRegPTR_tail,0
  jmp continue_debugging

  ;
step_intruc:
  call Update_register_LOG

  mov eax,registers_save.prg_eip
  call remove_BreakPoint          ; removes break point at EAX

  call CheckVGAport

  ; if an INT n instruction then insert special break point
  ; except if INT 21h AH=4Ch then don't insert a special break point;
  ;
  ; otherwise simply jmp to continue_debugging

  .if (byte ptr [eax] == 0CDh) && ( (byte ptr [eax+1] != 21h) || (byte ptr [registers_save.prg_eax+1] != 04Ch) )
    lea esi,[eax + 2]
    jmp skip_small_step
  .endif
  jmp continue_debugging

  ;
run_program:
  mov BacklogRegPTR_head,0            ; clear backlog
  mov BacklogRegPTR_tail,0
  call Restore_Video
  mov eax,registers_save.prg_eip
  mov ecx,Number_brkpts
  mov edi,offset BreakPoint_EIP
  _winnt
  repne scasd
  je continue_debugging         ; don't run a debugger break point
  .if byte ptr [eax] == 0CCh              ; don't run a users break point
    inc registers_save.prg_eip
  .elseif word ptr [eax] == 03CDh
    add registers_save.prg_eip,2
  .endif
  mov program_is_running,TRUE
  and byte ptr[registers_save.prg_eflags+1],0feh   ;clear TF
  jmp continue_debugging

  ;
exit_debugger:

  ;uninit debugger

  call uninit_kbd

  .if _cpl==0
    xor eax,eax               ;disable debug registers
    mov DR7,eax
  .endif

  call Restore_Video      ; Goto normal users mode on exit

  ;
  ; Restore a few interrupt handlers
  ;
  mov bl,1
  mov edx,dword ptr saved_IRQ1
  mov cx,word ptr saved_IRQ1+4
  call setIRQvector
  mov edx,dword ptr saved_int31h
  mov cx,word ptr saved_int31h[4]
  mov bl,31h
  call SetIntVector
  mov edx,dword ptr saved_int21h
  mov cx,word ptr saved_int21h[4]
  mov bl,21h
  call SetIntVector
  mov edx,dword ptr saved_int0
  mov cx,word ptr saved_int0[4]
  mov bl,0
  call SetExcVector
  mov edx,dword ptr saved_int1
  mov cx,word ptr saved_int1[4]
  mov bl,1
  call SetExcVector
  mov edx,dword ptr saved_int3
  mov cx,word ptr saved_int3[4]
  mov bl,3
  call SetExcVector
  mov edx,dword ptr saved_int6
  mov cx,word ptr saved_int6[4]
  mov bl,6
  call SetExcVector
  mov edx,dword ptr saved_int7
  mov cx,word ptr saved_int7[4]
  mov bl,7
  call SetExcVector
  mov edx,dword ptr saved_int13
  mov cx,word ptr saved_int13[4]
  mov bl,13
  call SetExcVector
  mov edx,dword ptr saved_int14
  mov cx,word ptr saved_int14[4]
  mov bl,14
  call SetExcVector
  mov edx,dword ptr saved_int16
  mov cx,word ptr saved_int16[4]
  mov bl,16
  call SetExcVector

  ;
  ; restore fpu emulation flag to origonal state
  ;
  .if _cpl==0
    smsw ax
    and al, NOT 4
    .if (fpu_emulation_flag == TRUE )
      or al, 4
    .endif
    lmsw ax
  .endif

  mov DebuggerTerminated,TRUE    ; let int 21h handler know were are
  mov DebuggerInUse,FALSE        ; really terminating

  cli
  mov dx,ds:[41ch]               ; clear the keyboard buffer
  mov ds:[41ah],dx
  sti

  mov ax,4C00h
  int 21h           ; Terminate to Operating system

  ;
user_screen:
  call Restore_Video

@@:
  call getkey
  .if al == 38h                 ; set for 'Alt'
    or Key_flags,ALT
  .elseif al == (38h or 80h)
    and Key_flags,Not ALT       ; clear 'Alt'
  .endif
  test al,80h               ; loop if release code
  jnz @b
  call Debuggers_Video
  jmp main_loop

here:
  mov eax,selected_EIP
  mov registers_save.prg_eip,eax
  jmp main_loop

show_help:
  mov edx,offset Help_msg
  call print_message_box
  jmp main_loop

goto_start:
  call Debuggers_Video
  mov BacklogRegPTR_head,0
  mov BacklogRegPTR_tail,0
  mov Step_flag,TRUE

  mov esi,offset origonal_registers
  mov edi,offset registers_save
  mov ecx,(SIZEOF registers_save)/4
  _winnt
  rep movsd

  ;ensure selected line is put at top.
  mov selected_line,0
  mov eax,registers_save.prg_eip
  mov selected_EIP,eax
  mov screen_EIP_value,eax

  call refresh_screen
  add esp,4*(8+2)       ;must unpop crap on stack (not needed anymore)    
  jmp load_all_regs

Run_Until_Here:
  cmp Until_Here,0
  jz ruh_begin
  cmp Until_Here,1
  jz ruh_run
  cmp Until_Here,2
  jz ruh_end

ruh_begin:
  mov eax,selected_EIP
  cmp eax,registers_save.prg_eip
  je main_loop                ; cannot do anything if same already

  mov Until_Here_EIP,eax
  mov Until_Here,1
  jmp set_brkpt

ruh_run:
  mov Until_Here,2
  jmp run_program

ruh_end:
  mov Until_Here,0
  mov eax,Until_Here_EIP
  mov selected_EIP,eax
  jmp set_brkpt

show_current_inst:
  mov selected_line,0
  mov eax,registers_save.prg_eip
  mov selected_EIP,eax
  mov screen_EIP_value,eax
  jmp main_loop

data_show_current_inst:
  mov eax,registers_save.prg_eip
  mov data_selected,0
  mov Data_Offset,eax
  jmp main_loop

move_to_code:
  mov which_window,CODE_W
  jmp main_loop

chg_code_offset:
  call _scan2hex
;;  test al,CTL
;;  jz main_loop                ;;disable this test if non-CTL op is ok

  mov selected_line,0
  ror ecx,4
  mov ebx,selected_EIP
  shld ebx,ecx,4
  mov selected_EIP,ebx
  mov screen_EIP_value,ebx
  jmp main_loop

chg_code_offset_del:
  mov   selected_line,0
  mov   ebx,selected_EIP
  shr   ebx,4
  mov   selected_EIP,ebx
  mov   screen_EIP_value,ebx
  jmp   main_loop

dec_code_offset:
  mov eax,-1
  jmp @f

inc_code_offset:
  mov eax,+1
@@:
  ;       mov   selected_line,0      ;;* enable this if we want to start
  ;       mov   ebx,selected_EIP     ;;  counting from selected_line
  mov ebx,screen_EIP_value            ;;  instead of screen_EIP_value

  add ebx,eax
  .if (ebx==-1)                 ; if new EIP value wraps around then force to zero
    xor ebx,ebx
  .endif
  mov selected_EIP,ebx
  mov screen_EIP_value,ebx
  jmp main_loop

  ; The Break Point mangaging routine 
  ;                          F2 key
set_brkpt:
  mov eax,selected_EIP
  mov ecx,Number_brkpts
  mov edi,offset BreakPoint_EIP
  _winnt
  repne scasd
  je Deleate_brkpt
  mov eax,-1
  mov ecx,Number_brkpts
  mov edi,offset BreakPoint_EIP
  _winnt
  repne scasd
  je insert_a_brkpt

  ; show that no more break points can be used
  mov edx,offset brkpts_are_full_mesg
  call print_message_box
  jmp main_loop

  brkpts_are_full_mesg db 'No more than ',Number_brkpts_string,' Breakpoints can be assigned $'

Deleate_brkpt:
  sub edi,offset BreakPoint_EIP+4

  ; take away the break point 
  mov BreakPoint_EIP[edi],-1
  shr edi,2
  mov dl,BreakPoint_oldopcode[edi]
  mov eax,selected_EIP
  mov [eax],dl                ; restore byte in the instruction
  jmp main_loop

insert_a_brkpt:
  sub edi,offset BreakPoint_EIP+4
  mov eax,selected_EIP
  mov dx,[eax]                ; save byte in the instruction
  cmp dl,0cch                 ; not allowed to put brk pts on top of brk pts
  je stupid_person
  cmp dx,03CDh
  je stupid_person
  mov BreakPoint_EIP[edi],eax
  shr edi,2
  mov BreakPoint_oldopcode[edi],dl
  mov byte ptr [eax],0CCH     ; put in a INT 3

  jmp main_loop

stupid_person:
  mov edx,offset mesg_1234
  call print_message_box
  jmp main_loop
  mesg_1234 db 'Are you stupid?  You can''t put a Breakpoint on a Breakpoint $'

  ;
back_step:
  mov eax,BacklogRegPTR_head
  .if BacklogRegPTR_tail == EAX
    jmp main_loop
  .endif
  sub eax, SIZEOF program_reg
  jge @f
  mov eax,SIZEOF registers_saved_backlog - SIZEOF program_reg
@@:
  mov BacklogRegPTR_head,eax

  ; copy all regs into back log 
  mov esi,BacklogRegPTR_head
  mov BacklogRegPTR_head,eax
  add esi,offset registers_saved_backlog
  mov edi,offset registers_save
  mov ecx,(SIZEOF program_reg ) /4
  _winnt
  rep movsd

  add esp,4*(8+2)       ;must unpop crap on stack (not needed anymore)
;  jmp load_all_regs

  load_all_regs: ; PROC 
    .IF ( FPU_installed )
      frstor registers_save.fpu_envir       ; load 108 bytes
    .ENDIF

    mov ebx,registers_save.prg_ebx
    mov ecx,registers_save.prg_ecx
    mov edx,registers_save.prg_edx
    mov edi,registers_save.prg_edi
    mov esi,registers_save.prg_esi
    mov ebp,registers_save.prg_ebp

    mov eax,registers_save.prg_ss
    mov [esp+4]._exc._ss,eax        ;+4 cause of RET on stack
    mov eax,registers_save.prg_esp
    mov [esp+4]._exc._esp,eax
    mov eax,registers_save.prg_eip  ;
    mov [esp+4]._exc._eip,eax       ; FIX : v1.02 : These 2 registers
    mov eax,registers_save.prg_cs   ;   were not being updated
    mov [esp+4]._exc._cs,eax        ;   -fixes back steping and others

    mov eax,registers_save.prg_eax

    mov es,registers_save.prg_es
    mov fs,registers_save.prg_fs
    mov gs,registers_save.prg_gs

    mov ds,registers_save.prg_ds

    jmp Handle_Debug_Exception

    ;
    ; note: it's safe to recursivly call the Handle_Debug_Exception  procedure
    ; without poping the saved registers becase we are restoring the
    ; oringinal stack pointer, esp.
    ; NOTE : this is not true anymore since we are using a locked DPMI
    ;        stack and things work a lot differently now  **Peter Quiring
    ;

 ; load_all_regs ENDP

  ;; Register Window Management 
reg_up:
  .if reg_selected == 0
    mov reg_selected,8
  .else
    dec reg_selected
  .endif
  jmp main_loop

reg_dn:
  .if reg_selected == 8
    mov reg_selected,0
  .else
    inc reg_selected
  .endif
  jmp main_loop

chg_reg:
  call _scan2hex
;;  test al,SHF               ;;disable this if non-shift operation is ok
;;  jz main_loop
  movzx ebx,reg_selected
  ror ecx,4
  shld registers_save.prg_eax[ebx*4],ecx,4
  mov Keep_Frame_Ptr,TRUE
  add esp,4*(8+2)       ;must unpop crap on stack (not needed anymore)    
  jmp load_all_regs

chg_reg_del:
;;  test al,SHF               ;;disable this if non-shift operation is ok
;;  jz main_loop
  movzx ebx,reg_selected
  shr registers_save.prg_eax[ebx*4],4
  mov Keep_Frame_Ptr,TRUE
  add esp,4*(8+2)       ;must unpop crap on stack (not needed anymore)    
  jmp load_all_regs

inc_reg:
;;  test al,SHF       ;;enable this if non-shift operation is a must
;;  jz   main_loop
  movzx ebx,reg_selected
  inc registers_save.prg_eax[ebx*4]
  mov Keep_Frame_Ptr,TRUE
  add esp,4*(8+2)       ;must unpop crap on stack (not needed anymore)    
  jmp load_all_regs

dec_reg:
;;  test al,SHF       ;;enable this if shift operation is a must
;;  jz   main_loop
  movzx ebx,reg_selected
  dec registers_save.prg_eax[ebx*4]
  mov Keep_Frame_Ptr,TRUE
  add esp,4*(8+2)       ;must unpop crap on stack (not needed anymore)    
  jmp load_all_regs

move_to_regs:
  mov which_window,REGS_W
  jmp main_loop

  ;; Stack Frame Window Management 

Frame_Up:
  add Frame_Ptr,4
  jmp main_loop

Frame_Down:
  sub Frame_Ptr,4
  jmp main_loop

  Frame_ESP :
  mov eax,registers_save.prg_esp
  mov Frame_Ptr,eax
  jmp main_loop

Frame_EBP:
  mov eax,registers_save.prg_ebp
  mov Frame_Ptr,eax
  jmp main_loop

  ;; Flag Window Management 
flag_up:
  .if flag_selected == 0 
    mov flag_selected,7
  .else
    dec flag_selected
  .endif
  jmp main_loop

flag_dn:
  .if flag_selected == 7
    mov flag_selected,0
  .else
    inc flag_selected
  .endif
  jmp main_loop

  flag_map_table label word
  dw 0000000000001b,0000001000000b,0000010000000b,0100000000000b
  dw 0000000000100b,0000000010000b,0001000000000b,0010000000000b

toggle_flag:
  movzx esi,flag_selected
  movzx eax,flag_map_table[esi*2]
  xor registers_save.prg_eflags,eax
  jmp main_loop

set_flag:
  movzx esi,flag_selected
  movzx eax,flag_map_table[esi*2]
  or registers_save.prg_eflags,eax
  jmp main_loop

reset_flag:
  movzx esi,flag_selected
  movzx eax,flag_map_table[esi*2]
  not eax
  and registers_save.prg_eflags,eax
  jmp main_loop

move_to_flag:
  mov which_window,FLAG_W
  jmp main_loop

  ;; Data Window Management 
move_to_dgroup:
  mov which_window,DATA_W
  jmp main_loop

data_scroll_up:
  sub Data_Offset,4
  jmp main_loop

data_scroll_dn:
  add Data_Offset,4
  jmp main_loop

data_pgup:
  sub Data_Offset,30h
  jmp main_loop

data_pgdn:
  add Data_Offset,30h
  jmp main_loop

data_up:
  mov bl,4
  jmp short data_upleft
data_left:
  mov bl,1
data_upleft:
  sub data_selected,bl
  jns main_loop
  add data_selected,4
  sub Data_Offset,4
  jmp main_loop

data_dn:
  mov bl,4
  jmp short data_dnright
data_right:
  mov bl,1
data_dnright:
  mov al,data_selected
  add al,bl
  .if al >= maxdgroup_select
    sub al,4
    add Data_Offset,4
  .endif
  mov data_selected,al
  jmp main_loop

chgdgroup:
  call _scan2hex
  test al,CTL
  jnz chgdgroup_Offset

;;  test al,SHF             ;;disable this test if non-shift operation is ok
;;  jnz chgdgroup_value
;;  jmp main_loop

chgdgroup_value:
  movzx esi,data_selected
  add esi,Data_Offset

  push fs
  mov fs,word ptr registers_save.prg_ds
  call getbyte
  pop fs
  .if !carry?               ;we can read the char
    shl al,4
    or al,cl
    call setbyte
  .endif
  jmp main_loop

chgdgroup_Offset:
  ror ecx,4
  movzx ebx,data_selected
  add ebx,Data_Offset
  shld ebx,ecx,4
  mov Data_Offset,ebx
  mov data_selected,0
  jmp main_loop

chgdgroup_del:
  movzx ebx,data_selected
  add ebx,Data_Offset
  shr ebx,4
  mov Data_Offset,ebx
  mov data_selected,0
  jmp main_loop

decdgroup:
  xor dl,dl
  jmp inc_decdgroup
incdgroup:
  mov dl,1
inc_decdgroup:

  test al,CTL
  jnz incdgroup_Offset

incdgroup_value:
  movzx esi,data_selected
  add esi,Data_Offset

  push fs
  mov fs,word ptr registers_save.prg_ds
  call getbyte
  pop fs
  .if !carry?
    .if dl
      inc al
    .else
      dec al
    .endif
    call setbyte
  .endif
  jmp main_loop

incdgroup_Offset:
  .if dl
    inc Data_Offset
  .else
    dec Data_Offset
  .endif
  jmp main_loop

toggle_i3here:
  xor _i3here,ON
  jmp main_loop

toggle_show_mmx:
  xor _show_mmx,ON
  jmp main_loop

Handle_Debug_Exception ENDP

nofilemsg db 'QDebug : ',QDEBUG_VERSION,' Build ',build_str,' by : Peter Quiring',13,10
  db '  Usage : QDEBUG filename[.exe] [optional args]',13,10,'$'

error_nofile:
  mov edx,offset nofilemsg
  jmp errormsg32

errormsg32:
  mov ah,9
  int 21h
  mov ax,4c00h
  int 21h

filename db 128 dup (?)
_dossel dw ?      ;selector for DOS RAM
_esiz dd ?        ;enviroment size

debugger_entry proc
  ;lock Code/Data
  ;INT 31h/600h  BX:CX=addr SI:DI=size
  cld
  mov ax,600h
  mov ecx,_debugger_addr
  mov ebx,ecx
  shr ebx,16
  mov edi,_debugger_size
  mov esi,edi
  shr esi,16
  int 31h  ;assume lock successful

  ;es => PSP
  mov ax,ds
  mov seldata,ax
  mov al,es:[80h]  ; command tail length
  mov esi,81h
@@:
  .if !al
    jmp error_nofile
  .endif
  .if byte ptr es:[esi]==' '  ;skip over leading spaces
    dec al
    inc esi
    jmp @b
  .endif
  mov edi,offset filename
@@:
  .if (!al) || (byte ptr es:[esi] == ' ')
    jmp @f
  .endif
  mov bl,es:[esi]
  mov [edi],bl
  inc esi
  inc edi
  dec al
  jmp @b
@@:
  ;FIX : v1.06a : Adding an extra '.EXE' fails.
  cmp bptr[edi-4],'.'  ;ext. already there?
  je @f
  mov ebx,'EXE.'       ;add .EXE  ;FIX : v1.06b : was using EAX and it was used later
  mov [edi],ebx
  add edi,4
@@:
  mov byte ptr[edi],0

  xor cl,cl
  .if al
    mov edi,81h
@@:
    mov bl,es:[esi]
    mov es:[edi],bl
    inc esi
    inc edi
    inc cl
    dec al
    jnz @b
  .endif
  mov es:[80h],cl

  ;Make filename canonical (TRUENAME)
  ;need some DOS mem first

  mov ax,100h
  mov bx,128*2/16  ;# paragraphs
  int 31h
  jc cant_canon

  mov _dossel,dx

  push es
  mov es,dx
  mov esi,offset filename
  mov ecx,128/4
  xor edi,edi
  rep movsd
  pop es

  sub esp,sizeof callstruct
  mov bptr[esp+1].callstruct._eax,60h  ;AH=60h
  mov [esp].callstruct._ss,0
  mov [esp].callstruct._sp,0
  mov [esp].callstruct._ds,ax
  mov [esp].callstruct._es,ax
  mov [esp].callstruct._esi,0
  mov [esp].callstruct._edi,128
  xor ecx,ecx
  mov edi,esp
  mov bx,21h
  mov ax,300h
  push es
  push ss
  pop es
  int 31h
  pop es
  jc cant_canon   ;BUG! add,esp ignored! (does not matter, lose 4 bytes mem)
  add esp,sizeof callstruct

  ;get canonalized filename
  push ds
  push es
  push ds
  pop es
  mov ds,_dossel
  mov edi,offset filename
  mov ecx,128/4  ;copy the whole thing
  mov esi,128
  rep movsd
  pop es
  pop ds

  ;release DOS mem
  mov ax,101h
  mov dx,_dossel
  int 31h

  ;copy to enviroment segment
  mov bx,es:[44]  ;get enviroment selector
  mov ax,6
  int 31h
  jc cant_canon

  shl ecx,16
  mov cx,dx  ;ECX = enviroment
  mov edx,ecx
  mov esi,ecx  ;bakup
  xor ecx,ecx
  ;search for double 00
  xor eax,eax
l1:
  cmp [edx],ax
  jz gotit
  inc ecx  ;enviroment size
  inc edx
  jmp l1
gotit:
  add ecx,4  ;skip over 00/word
  mov _esiz,ecx  ;enviroment size to copy
  add ecx,128+15  ;for filename
  shr ecx,4      ;paras

  mov ax,100h
  mov bx,cx
  int 31h
  jc cant_canon

  xor edi,edi
  mov di,ax
  shl edi,4   ;convert to linear addr

  mov ecx,_esiz
  push es
  push ds
  pop es
  rep movsb   ;copy old enviroment to new enviroment
  mov esi,offset filename
  mov ecx,128
  rep movsb   ;copy canonical filename
  pop es

  mov bx,es:[44]   ;get old environment sel

  mov es:[44],dx   ;place in PSP  (new environment sel)

  mov dx,bx
  mov ax,101h
  int 31h   ; free old environment segment

cant_canon:
  mov edx,offset filename
  jmp le_loader

debugger_entry endp

_new_enviro dw ?

; The following is simply used to detect QDebug.
; I use DPMI 0a00h but the entry point given does not do anything.

new_int31h proc
  cmp ax,0a00h
  .if zero?
    cmp dword ptr ds:[esi],'BEDQ' ;"QDEBUG"
    jne cont
    cmp word ptr ds:[esi+4],'GU'
    jne cont
    cmp byte ptr ds:[esi+6],0
    jne cont
    push cs     ;FIX : v1.00 beta #6 : Was using seldata before.
    pop es
    mov edi,offset nullproc
    mov eax,'QBUG'  ;NEW : v1.04 : to verify the QDEBUG is really loaded
    and byte ptr[esp+4*2],0feh   ;clear carry on stack
    iretd
  .endif
cont:
  jmp cs:saved_int31h
new_int31h endp    

nullproc proc
  retf
nullproc endp

msg_exc label byte
  db 'Debugger has caused a fatal exception, system halted!',13
  db 'Exception: ',2,0,13
  db 'Error Code: ',8,7 dup (0),13
  db 'EAX: ',8,7 dup (0),'  EBX: ',8,7 dup (0),'  ECX: ',8,7 dup (0),'  EDX: ',8,7 dup (0),13
  db 'ESI: ',8,7 dup (0),'  EDI: ',8,7 dup (0),'  EBP: ',8,7 dup (0),13
  db ' CS: ',4,3 dup (0),'  EIP: ',8,7 dup (0),13
  db ' SS: ',4,3 dup (0),'  ESP: ',8,7 dup (0),13
  db ' DS: ',4,3 dup (0),'  ES: ',4,3 dup (0),'  FS: ',4,3 dup (0),'  GS: ',4,3 dup (0),13
  db 'EFLAGS: ',8,7 dup (0),13
  db 'CR0: ',8,7 dup (0),' CR2: ',8,7 dup (0),13
  db 'Code  Bytes :',16 dup(2,0,' '),13
  db '     EIP->  :',16 dup(2,0,' '),13
  db 'Stack Bytes :',16 dup(2,0,' '),13
  db '     ESP->  :',16 dup(2,0,' '),13
  db ' Test :',2,0,13
  msg_exc_size equ ($ - (offset msg_exc))

dump_ds dd ?
dump_es dd ?
dump_cnt db ?

dump:
  push ds
  mov ds,cs:seldata
  pop dump_ds
  mov dump_es,es
  push ds
  pop es

  ;setup regs in thingy
  mov edi,offset msg_exc
  mov al,cl  ;exc #
  call e_addnum
  mov eax,[esp+8*4]._exc._errcode
  call e_addnum      ;Error code
  mov eax,[esp].callstruct._eax
  call e_addnum
  mov eax,[esp].callstruct._ebx
  call e_addnum
  mov eax,[esp].callstruct._ecx
  call e_addnum
  mov eax,[esp].callstruct._edx
  call e_addnum
  mov eax,[esp].callstruct._esi  ;FIX : v1.05 : next 3 were in wrong order
  call e_addnum
  mov eax,[esp].callstruct._edi
  call e_addnum
  mov eax,[esp].callstruct._ebp
  call e_addnum
  mov eax,[esp+8*4]._exc._cs
  call e_addnum    ;CS
  mov eax,[esp+8*4]._exc._eip
  call e_addnum    ;EIP
  mov eax,[esp+8*4]._exc._ss
  call e_addnum    ;SS
  mov eax,[esp+8*4]._exc._esp
  call e_addnum    ;ESP
  mov eax,dump_ds
  call e_addnum    ;DS
  mov eax,es
  call e_addnum    ;ES
  mov eax,fs
  call e_addnum    ;FS
  mov eax,gs
  call e_addnum    ;GS
  mov eax,[esp+8*4]._exc._eflags
  call e_addnum    ;Eflags
  mov eax,cr0
  call e_addnum    ;CR0
  mov eax,cr2
  call e_addnum    ;CR2

  mov esi,[esp+8*4]._exc._eip
  sub esi,16
  mov dump_cnt,32
  mov bx,word ptr registers_save.prg_cs
  push fs
  mov fs,bx
@@:
  call getbyte     ;plot next few instructions
  inc esi
  call e_addnum
  dec dump_cnt
  jnz @b
  pop fs

  mov esi,[esp+8*4]._exc._esp
  sub esi,16
  mov dump_cnt,32
  mov bx,word ptr registers_save.prg_ss
  push fs
  mov fs,bx
@@:
  call getbyte    ;plot some bytes on stack
  inc esi
  call e_addnum
  dec dump_cnt
  jnz @b
  pop fs

  mov al,Testing_Addr
  call e_addnum

  mov esi,offset msg_exc
  mov edi,0b8000h
  mov ecx,8*1024/4
  mov eax,07200720h  ;spaces
  rep stosd
  mov edi,0b8000h
  mov ecx,msg_exc_size
  mov ebx,80*2
@@:
  .if bptr[esi]==13
    add edi,ebx
    inc esi
    mov ebx,80*2
  .else
    movsb
    inc edi
    sub ebx,2
  .endif
  dec ecx
  jnz @b

  ;attempt to Exit (message box will appear)
  mov ax,4c00h
  int 21h

  cli
  jmp $  ;crash 'n' burn!  (HANG)

e_addnum proc
  ;searches thru ds:edi for 1,4 or 8 and puts EAX there in ASC2
  ;destroys : eax,bx,cx,dx
top:
  cmp bptr[edi],2
  jz doit
  cmp bptr[edi],4
  jz doit
  cmp bptr[edi],8
  jz doit
  inc edi
  jmp top
doit:
  xor ecx,ecx
  mov cl,[edi]
  add edi,ecx
  mov ebx,ecx
cnt:
  mov dl,al
  and dl,0fh
  .if dl<10
    add dl,'0'
  .else
    add dl,'A'-10
  .endif
  dec edi
  mov [edi],dl
  shr eax,4
  dec cl
  jnz cnt
  add edi,ebx
  ret
e_addnum endp

;NEW : v1.10 Beta #3 : MMX support!
print_mmx proc
  ;in : EAX -> MMX # (64bits)
  ;     EDX -> output string
  pushad

  mov cl,8
  mov ebx,[eax+4]   ;the high DWORD 1st
  call _print_hex

  add edx,8
  mov bptr[edx],':'
  inc edx

  mov ebx,[eax]
  call _print_hex

  add edx,8

  mov bptr[edx],'$'

  popad
  ret
print_mmx endp

include loadle.asm

END debugger_entry
