
include callp.inc

include string.asm

.data
align 4
__ZERO real8 0.0
__ONE real8 1.0
__ten real8 10.0
__rnd_0 label word    ;round towards 0
    db 7fh,1111b
__rnd_up label word   ;round up
    db 7fh,1011b
__rnd_dw label word   ;round down
    db 7fh,0111b
__cw_def label word   ;default rounding (to nearest or even)
    db 7fh,0011b 
__EXP_MAX real8 709.7827128933839
MAX_FTOA real8 +1.0e8
MIN_FTOA real8 -1.0e8
pos_nan db '+NAN',0
neg_nan db '-NAN',0
pos_inf db '+INF',0
neg_inf db '-INF',0
_estr db 'e+00',0

include math.asm

.code
fint macro @@QWORDPTR               ;integrerize float number
    fld     @@QWORDPTR              ;load value to get integer part
    frndint                         ;round to integrer
    fstsw   ax                      ;store flags
    fistp   dptr [__t_rint]           ;store (rounded) integrer
    fwait

    .if ah & 2  ;mask C1
      mov eax,dptr [__t_rint]
      dec eax
    .else
      mov eax,dptr [__t_rint]
    .endif
endm

frnd macro @@QWORDPTR, @@DIGITS     ;round "dizimas periodicas"
    push eax
    push ebx
    push ecx
    push edx         ;save regs
    mov     edx, @@DIGITS
    inc     edx                     
    callp    _pow,10,edx            ;pow(10, digits+1)
    mov     ecx, eax                ;save power of 10 in ecx
    fld     @@QWORDPTR              ;load value
    fint    @@QWORDPTR              ;integrerize
    mov     [__t_d1], eax           ;move integrer to temp buffer
    fisub   [__t_d1]                ;subtract whole part
    mov     [__t_d1], ecx           ;move power of 10 to temp buffer
    fimul   [__t_d1]                ;mul fractional part by power
    fstp    [__t_rrnd]              ;store powered fractional part
    fint    __t_rrnd                ;integrerize powered fractional part
    xor     edx, edx                ;clear edx
    mov     ebx, 10                 ;divide by 10
    div     ebx
    xor     ebx,ebx
    cmp     edx, 9                  ;set ebx to 1 if remainder=9
    sete    bl
    mov     [__t_d1], ebx           ;move 1 or 0 to temp buffer
    fild    [__t_d1]                ;load it
    mov     [__t_d1], ecx           ;move power of 10 to temp buffer
    fidiv   [__t_d1]                ;divide 1 or 0 by power of 10
    fstp    [__t_rrnd]              ;store fractional number to add
    fld     @@QWORDPTR              ;reload original value
    fadd    __t_rrnd                ;add 0.0000xxxx1 or not
    fstp    @@QWORDPTR              ;store rounded value
    pop edx
    pop ecx
    pop ebx
    pop eax
endm

chk_nan_inf proc private
  ;check for NAN and INF in st
  fxam
  fstsw ax
  ffree st
  fwait
  and ah,1000111b   ;mask C? flags

  .if ah == 001b
    callp strcpy,edi,offset pos_nan
    mov eax,1
    ret
  .endif
  .if ah == 011b
    callp strcpy,edi,offset neg_nan
    mov eax,1
    ret
  .endif
  .if ah == 101b
    callp strcpy,edi,offset pos_inf
    mov eax,1
    ret
  .endif
  .if ah == 111b
    callp strcpy,edi,offset neg_inf
    mov eax,1
    ret
  .endif
  xor eax,eax
  ret
chk_nan_inf endp

nibblecount proc private
  push eax
  push ebx
  push edx

  xor ecx, ecx
  mov ebx, 10

@@NCloop:
  xor edx, edx
  div ebx
  cmp eax, 0
  je @@NCend
  inc ecx
  jmp @@NCloop

@@NCend:
  pop edx
  pop ebx
  pop eax
  ret
nibblecount endp

;This is not an ANSI C pow (this is an integer POW)

_pow PROC private uses ebx ecx edx,a1:dword,a2:dword      ;power(number, power)
  mov ecx, a2
  cmp ecx, 0
  .if carry? || zero?
    mov eax,1
    ret
  .endif

  mov ebx, a1
  mov eax, ebx
  xor edx, edx
  jmp start
@@:
  mul ebx
start:
  dec ecx
  jnz @b
  ret
_pow ENDP

ftoa proc, a:REAL8, string:dword, decimals:dword
  fld a
  fcomp MAX_FTOA
  fstsw ax
  fwait
  sahf
  jbe @f
  jmp _etoa
@@:
  fld a
  fcomp MIN_FTOA
  fstsw ax
  fwait
  sahf
  jae @f
  jmp _etoa
@@:
  callp _ftoa_,a,string,decimals
  ret
_etoa:
  callp etoa,a,string,decimals
  ret
ftoa endp

_ftoa_ proc private, a:REAL8, string:dword, decimals:dword

    local _sign:byte
    local __t_r1:real8,__t_w1:word,__t_d1:dword
    local __t_rint:real8,__t_rrnd:real8

    pushad

    fld a
    mov edi,string
    call chk_nan_inf
    .if eax
      popad
      mov eax,string
      ret
    .endif

    fldcw __rnd_0   ;setup RC

    mov     [_sign], 0              ;clear sign marker

    fint    a                       ;`integrerize' number
    mov     edi, [string]           ;load EDI with string    

    cmp     eax, 0                  ;below zero?
    jge     @@FTOAabovezero         ;NO=>goto FTOAabovezero
    mov     [_sign], 1              ;negative number
    neg     eax                     ;clear sign bit
    xor bptr[a+7],80h               ;remove sign
    mov     [edi], bptr '-'         ;put minus on start of edi

@@FTOAabovezero:
    mov     edx, decimals
    frnd    a , edx                 ;round .499999999 to .5

    fint    a                       ;integrerize rounded positive number
    call    nibblecount             ;get # of digits
    inc     ecx                     ;increase (nibblecount returns #-1)

    add     edi, ecx                ;add digit count to EDI
    movzx   ebx, _sign
    add     edi, ebx                ;if negative one more char is needed
    push    ecx                     ;save for further use
    push    edi                     ;save for further use

    mov     bptr [edi], '.'         ;put the point
    dec     edi                     ;decrease

    mov     ebx, 10                 ;divider
@@FTOAloop1:
    xor     edx, edx                ;divide eax by 10 until
    div     ebx                     ;ecx decreases from max    
    add     edx, '0'                ;number of digits to 0.
    mov     [edi], bptr dl          ;save number MOD 10+30h
    dec     edi                     ;so it's ASCII code
    dec     ecx                     ;decrease count
    jnz     @@FTOAloop1

    pop     edi                     ;restore string pos at point
    pop     ecx                     ;restore digit count
    inc     edi                     ;goto after point

    ;*********************** [FRACTIONAL] ***********************

    mov     ecx, decimals           ;make ECX a count of decimals desired
    test ecx,ecx
    jnz @f
      mov al,'0'
      stosb
      jmp nodec
@@:
    fint    a                       ;`integrerize' float number
    mov     [__t_d1], eax           ;move int number to temp location
    fld     a                       ;load float number
    fisub   dptr [__t_d1]           ;subtract whole part so only frac is left
    
    mov     __t_d1, 10
    mov     ebx, 10          

@@FTOAloop2:
    fimul   dptr [__t_d1]           ;multiplicate by 10
    fst     qptr [__t_r1]           ;save mul'ed result
    fwait
    fint    __t_r1                  ;`integrerize' it

    xor     edx, edx                ;clear edx
    div     ebx                     ;divide by 10 and get remainder

    add     dl, '0'                 ;add 30h to value
    mov     [edi], dl               ;save on string

    inc     edi                     ;increase string index
    dec     ecx                     ;decrease 'precision' counter
    jnz     @@FTOAloop2             

nodec:
    ffree   st(0)                   ;kill st(0)

    mov     bptr [edi], 0           ;put '\0' at end of string
    xor     eax, eax

    fldcw __cw_def   ;setup RC to default
    fwait
    popad
    mov eax,string
    ret
_ftoa_ endp

etoa proc, a:REAL8, string:dword, decimals:dword
  ;print decimal part then 'e' then exponential part

  local _ws:byte  ;whole part sign
  local __t_r1:real8,__t_w1:word,__t_d1:dword
  local __t_rint:real8,__t_rrnd:real8

  pushad

  fld a
  mov edi,string
  call chk_nan_inf
  .if eax
    popad
    mov eax,string
    ret
  .endif

  fld a
  ftst         ;cmp with 0.0  ;must account for decimals
  fstsw ax
  ffree st
  fwait
  sahf
  .if zero?
    callp _ftoa_,a,edi,decimals     ;0.000000
    callp strlen,edi
    add edi,eax
    callp strcpy,edi,offset _estr
    popad
    mov eax,string
    ret
  .endif
  mov _ws,0
  .if carry?  ;negative #
    mov _ws,1
    xor bptr[a+7],80h  ;remove sign bit
  .endif

  fldcw __rnd_dw    ;make sure frndint rounds towards down
  
  callp log10,a     ;get exponent part
  fstp __t_r1
  fwait
  frnd __t_r1, 1    ;round .9999999 to 1
  fld __t_r1
  frndint           ;chop decimal part
  fst __t_r1        ;save for later
  fistp __t_w1      ;and here trunc.
  fwait

  callp pow,__ten,__t_r1   ;find 10 ** tmp
  fld a
  fxch
  fdivp st(1),st     ;find 'a' / (10 ** tmp) which will leave the dec part
  fstp __t_r1        ;save dec part
  fwait
  
  .if _ws  ;put in neg #
    mov al,'-'
    stosb
  .endif
  callp _ftoa_,__t_r1,edi,decimals
  callp strlen,edi
  add edi,eax

  fldcw __cw_def       ;reset cw

  mov al,'e'
  stosb
  mov bx,__t_w1
  .if bx & 8000h
    neg bx
    mov al,'-'
    stosb
  .else
    mov al,'+'
    stosb
  .endif
  .if bx<10     ;make sure there are at least 2 digits (as BC)
    mov al,'0'
    stosb
  .endif
  callp num2str,bx,edi,10

  popad
  mov eax,string

  ret
etoa endp

print_float proc
  ;Input : EAX -> ptr to REAL10
  ;      : EDX -> ptr to output string

  local __t_r1:real8

  pushad

  finit  ;Reset everything

  fld REAL10 ptr [eax]
  fstp REAL8 ptr [__t_r1]

  callp etoa,__t_r1,edx,30

  callp strlen,edx
  add eax,edx
  mov byte ptr[eax],'$'

  popad
  ret
print_float endp


