include src\qlib.inc
include src\alloc.inc
include errno.inc
include alloc.inc
include string.inc

.code

;reallocs a block of RAM
;this may return a new block addr and it will copy the old block to the new one
realloc proc,hnd:dword,siz:dword
  ;1st: attempts to see if next block is free and then simply enlarges
  ;     the block as needed
  ;ELSE alloc a new block and copies to it and then releases old block

  cmp hnd,0
  jne start1

  cmp siz,0
  je bad
  callp malloc,siz                     ;NULL pointer so use malloc()
  ret
start1:
  cmp siz,0
  jne @f
  ; realloc block to zero? Probably not valid in normal C...
  ; to avoid errors, I will free up the block.
  callp free,hnd
bad:
  xor eax,eax                          ;can not malloc 0 bytes
  ret
corrupt:
  popad
  mov errno,ECONTR   ;memory blocks destroyed
  xor eax,eax
  ret
@@:
  pushad

  add siz,3        ;FIX : v2.11 Beta#4 : make sure it's DWORD aligned!
  and siz,0ffffffffh-3

  mov eax,hnd
  sub eax,sizeof heads     ;FIX : v2.00 Beta #4 : this was after .if
  ifdef __MEM_CHK__
    cmp [eax].heads.magic,MB_SIG
    jne corrupt
  endif
@@:
  mov ebx,[eax].heads.siz
  cmp ebx,siz                          ;requested same size?
  jne @f
    popad
    mov eax,hnd                          ;nothing to do
    ret
@@:
  .if ebx>siz  ;FIX : v2.10 Beta #1 : This cmp was reversed!
    ;make block smaller
    mov ecx,ebx
    sub ecx,siz
    .if ecx < MB_MINSIZE
      ;don't make the new block too small
      popad
      mov eax,hnd
      ret
    .endif
    ;split hnd into 2 blocks!
    mov edx,ebx   ;size of current block
    mov ebx,siz
    mov [eax].heads.siz,ebx
    mov cl,[eax].heads.flgs
    and [eax].heads.flgs,MB_FREE  ;FIX : v2.11 Beta #1 : remove LAST flag if there
    mov ebx,eax
    add ebx,sizeof heads
    add ebx,siz
    mov [ebx].heads.magic,MB_SIG
    or cl,MB_FREE   ;set as free
    mov [ebx].heads.flgs,cl
    mov [ebx].heads.prev,eax
    sub edx,siz
    sub edx,sizeof heads
    mov [ebx].heads.siz,edx
    test [ebx].heads.flgs,MB_LAST
    jnz done1
    ;FIX : v2.11 Beta #1 : fix prev of next block and check if it's free
    mov edx,ebx
    add edx,[ebx].heads.siz
    add edx,sizeof heads
    test [edx].heads.flgs,MB_FREE
    jz notfree
    ;it's free so we gotta join these two blocks (EDX to EBX)
    ifdef __MEM_SIG__
      mov [edx].heads.magic,0
    endif
    mov eax,[edx].heads.siz
    mov cl,[edx].heads.flgs
    and cl,MB_LAST
    add eax,sizeof heads
    add [ebx].heads.siz,eax
    or [ebx].heads.flgs,cl
    test cl,cl
    jnz done1
    mov edx,ebx
    add edx,[ebx].heads.siz
    add edx,sizeof heads
notfree:
    mov [edx].heads.prev,ebx
done1:
    popad
    mov eax,hnd
    ret
  .endif

  ;make block bigger (if possible)
  ; finished here v2.00 Beta #4
  test [eax].heads.flgs,MB_LAST
  jnz _else ;this is the last one so I can not make it bigger

  ; EAX=hnd EBX=sizeof(hnd)
  mov ecx,eax
  add ecx,sizeof heads  ;FIX : v2.03 Beta #4 : this was missing
  add ecx,ebx                          ;add size of current block
  ; ECX=NextBlk
  ifdef __MEM_CHK__
    cmp [ecx].heads.magic,MB_SIG
    jne corrupt
  endif
  test [ecx].heads.flgs,MB_FREE
  jz _else                             ;next block is not free

  mov edx,[ecx].heads.siz
  add edx,sizeof heads
  add edx,ebx
  ; EDX = sizeof(NextBlk)+sizeof(heads)+sizeof(hnd)
  ;if edx >= siz then we can expand current block into next block
  cmp edx,siz
  jb _else                             ;next blk is not big enough

  mov ebx,edx
  sub ebx,siz
  sub ebx,sizeof heads
  ; EBX=new sizeof(NextBlk)
  .if (carry?) || (ebx<MB_MINSIZE)  ;don't make too small
    ;combine two blocks into one only
    mov [eax].heads.siz,edx
    mov bl,[ecx].heads.flgs
    and bl,MB_LAST                     ;remove Free flag
    or [eax].heads.flgs,bl             ;set last flag if NextBlk was last
    test bl,MB_LAST
    jnz @f
    mov ebx,eax
    add ebx,edx
    add ebx,sizeof heads
    mov [ebx].heads.prev,eax
@@:
    popad
    mov eax,hnd
    ret
  .endif

  ;make another block
  ifdef __MEM_SIG__
    mov [ecx].heads.magic,0
  endif
  mov cl,[ecx].heads.flgs
  and cl,MB_LAST                     ;remove Free flag
  mov edx,siz
  mov [eax].heads.siz,edx
  mov [eax].heads.flgs,0
  add edx,eax
  add edx,sizeof heads    ;FIX : v2.10 Beta #1 : this was missing
  mov [edx].heads.magic,MB_SIG
  mov [edx].heads.flgs,MB_FREE
  or [edx].heads.flgs,cl             ;set last flag if needed
  mov [edx].heads.siz,ebx
  mov [edx].heads.prev,eax
  test cl,MB_LAST ;cl   ;check for MB_LAST
  jnz @f
  mov ebx,edx
  add ebx,[edx].heads.siz
  add ebx,sizeof heads
  mov [ebx].heads.prev,edx
@@:
  popad
  mov eax,hnd
  ret
_else:    ;alloc a new block and copy to it
  callp malloc,siz
  test eax,eax
  jne @f
    popad
    xor eax,eax  ;NULL    ;FIX : v2.10 Beta #1 : this was missing
    ret
@@:
  mov edx,eax
  mov ebx,hnd
  mov eax,[ebx-sizeof heads].heads.siz
;  .if eax > siz   ;should not happen unless I'm testing...
;    mov eax,siz
;  .endif
  callp memcpy,edx,ebx,eax       ;copy the whole old block to the new block
  callp free,ebx
  mov [esp].callstruct._eax,edx        ;Save new pointer into EAX on stack
  popad
  ret
realloc endp

_endseg

end


