;LZ compression v1.01  (limpel-ziv algorithm)
; by : Peter Quiring
; NOTE : This may be a unique twist to the LZW compression algo.

; Optimization Notes:
;   DH = suffix

.code
align 4
write_code proc private,d:word
  xor eax,eax
  mov ax,d

  mov cl,bo   ;# bits to shift right
  sub cl,nb2  ;# bits needed to shift left
  jz noshift  ;opt (not necessary)
  .if carry?
    neg cl
    rol eax,cl
  .else
    ror eax,cl
  .endif
noshift:

  xchg ah,al   ;-+
  ror eax,16   ; |
  xchg ah,al   ; |
  ror eax,16   ;convert to -straight- format

  or [edi],eax
  inc edi
  dec dlen

  mov al,bo
  add al,nb
  cmp al,16
  .if carry?
    mov wptr[edi+1],0    ;1 byte only
  .else
    inc edi              ;2 bytes
    dec dlen
    mov wptr[edi],0
  .endif

  and al,7
  mov bo,al

  ;is there enough space on output buffer?
  cmp dlen,COMP_OFLOW  ;Flags check after this CMP!
  ;Note : this is not always checked if two or more writes are in a row.

  ret
write_code endp

lookup_code macro
  xor eax,eax
  mov ax,prefix
  xor dl,dl  ;flag (first?)
  shl eax,3      ;EAX = prefix*8
  cmp [ht+eax].chash.first,-1
  je gc4
  xor ebx,ebx
  inc dl     ;set flag (not first)
  mov bx,[ht+eax].chash.first

  align 4  ;crazy?
gc2:
  mov eax,ebx
  shl eax,3    ;EAX = bx*8
  cmp [ht+eax].chash.char,dh      ;is char==suffix?
  jne gc3
    clc                          ;string already in table
    mov ax,bx                    ;put found code in AX
    jmp gc6
   
gc3:
  cmp [ht+eax].chash.next,-1      ;more left with this prefix?
  jne gc5
gc4:
    stc                          ;not found
    jmp gc6

gc5:
  mov bx,[ht+eax].chash.next    ;get next code
  jmp gc2                      ;try again

gc6:
endm

add_code macro
  mov bx,code
  test dl,dl  ;test flag (first use of this prefix?)
  jnz ac1
    mov [ht+eax].chash.first,bx
    jmp ac2

ac1:
  mov [ht+eax].chash.next,bx
ac2:
  cmp bx,MAX_CODE
  je ac3

  ;setup next hash entry
  mov eax,ebx
  shl eax,3    ;EAX = EBX*8

  mov [ht+eax].chash.first,-1
  mov [ht+eax].chash.next,-1
  mov [ht+eax].chash.char,dh

  inc code

ac3:
endm

getbyte macro
  xor eax,eax
  lodsb
  dec slen   ;Flags check after this DEC!
endm

init_table macro
  mov nb,9                    ;Set code size to 9
  mov nb2,7                   ;# bits to shift left
  mov code,FIRST_CODE         ;Set next code to use
  mov max_code,200h           ;10bit
  or eax,-1                   ;Unused flag
  mov ecx,256*sizeof chash/4  ;Clear first 256 entries
  push edi
  mov edi,offset ht           ;Point to first entry
  rep stosd                   ;Clear it out
  pop edi
endm

align 4
_lz_comp proc dest:dword,src:dword
  pushad

  mov edi,dest
  mov esi,src

  mov al,COMP_LZ
  stosb         ;store type
  mov eax,slen
  stosd         ;store uncompressed size
;  sub dlen,5   ;does not matter since COMP_OFLOW is needed anyway
  mov dptr[edi],0     ;clear init bits
  mov bo,0            ;current bit offset
restart:
  init_table
  getbyte
  .if zero?  ;len zero?
    callp write_code,ax
    jmp codone
  .endif
do1:       
  mov prefix,ax
  getbyte
  mov dh,al
  .if zero?
    callp write_code,prefix  ;write prefix
    callp write_code,dh  ;write last suffix
    jmp codone
  .endif
  lookup_code  ;see if prefix:suffix is in hash table
  jnc do1      ;not new string (prefix)
  add_code     ;add prefix:suffix to hash table (inc code)
  callp write_code,prefix
  jb bad  ;not enough space available.
  xor ah,ah
  mov al,dh
  ;check if code overloaded
  mov bx,max_code
  cmp code,bx
  jne do1
  shl max_code,1
  cmp max_code,MAX_CODE
  jne do2
  inc nb
  dec nb2
  jmp do1
do2:
  ; end of this block  (send reset code and restart hash table)
  callp write_code,dh           ;write suffix
  callp write_code,CLR_CODE     ;write clear code
  jmp restart

codone:  ;done!
  callp write_code,EOF_CODE   ;write EOF flag
  .if bo
    inc edi ;to get last part
  .endif
  sub edi,dest
  mov [esp+4*7],edi  ;save EAX for ret val (size of compressed data)
  popad
  ret

bad:
  popad
  mov eax,ERROR
  ret
_lz_comp endp
