;LZ decompression v1.01  (limpel-ziv algorithm)
; by : Peter Quiring

.code
align 4
read_code proc private
  mov eax,[esi]
  inc esi
  dec slen

  xchg ah,al   ;-+
  ror eax,16   ; |
  xchg ah,al   ; |
  ror eax,16   ;convert to Big Endian format

  mov cl,bo   ;# bits to shift right
  sub cl,nb2  ;# bits needed to shift left
  jz noshift  ;opt (not necessary)
  .if carry?
    neg cl
    ror eax,cl
  .else
    rol eax,cl
  .endif
noshift:

  and eax,maskbits

  mov bl,bo
  add bl,nb
  cmp bl,16
  .if !carry?
    inc esi              ;2 bytes
    dec slen
  .endif

  and bl,7
  mov bo,bl
  ret
read_code endp

dadd_code macro
  xor ebx,ebx
  mov bx,code                   ;Get new code
  shl ebx,2            ;*4
  mov al,suffix                 ;get suffix char
  mov [ht+ebx].dhash.suffix,al  ;save it
  mov ax,oc                     ;get prefix code
  mov [ht+ebx].dhash.prefix,ax  ;save it
  inc code                      ;set next code
endm

align 4
_lz_decomp proc,dest:dword,src:dword
  pushad
  mov bo,0
  mov esi,src
  mov edi,dest
restart:
  mov nb,9
  mov nb2,7
  mov code,FIRST_CODE
  mov maskbits,1ffh
  call read_code
  cmp ax,CLR_CODE
  je restart
  cmp ax,EOF_CODE
  je dedone
  mov cc,ax
  mov oc,ax
  mov fc,al
  stosb      ;code after CLR_CODE must be 0-255
l1:
  call read_code
  mov cc,ax
  mov ic,ax
  cmp ax,CLR_CODE
  je restart
  cmp ax,EOF_CODE
  je dedone
  cmp ax,code
  jb l11
    mov ax,oc
    mov cc,ax
    mov al,fc
    push ax
    inc stack_cnt
l11:
  cmp cc,255               ;code or char?
  jbe l15

  xor ebx,ebx
  mov bx,cc
  shl ebx,2            ;*4
  mov al,[ht+ebx].dhash.suffix
  push ax
  inc stack_cnt
  mov ax,[ht+ebx].dhash.prefix ;get prefix
  mov cc,ax                    ;save it
  jmp l11

l15:
  mov ax,cc
  mov fc,al
  mov suffix,al
  push ax
  inc stack_cnt
  mov ecx,stack_cnt
  jecxz l18

l17:
  pop ax
  stosb  ;write char
  dec ecx
  jnz l17

l18:
  mov stack_cnt,ecx    ;clear stack_cnt
  dadd_code
  mov ax,ic
  mov oc,ax
  mov bx,code
  cmp bx,max_code
  jb l1
    cmp nb,12
    je l1   ;continue to use 12bit until CLR_CODE is used (which should be soon)
    inc nb
    dec nb2
    shl max_code,1
    stc
    rcl maskbits,1
    jmp l1

dedone:
  sub edi,dest  ;EDI = total undecompressed
  mov [esp+4*7],edi  ;save EAX on return
  popad
  ret
_lz_decomp endp
