 ;The following put/get to/from _v_buffer (temparea)

.code

;Gets an image from temp buffer
;Performs clipping to view port
g_get proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local sadd:dword   ;src add
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_xb,sadd,dadd,esi,edi,1  ;Fast!

  add edi,buf
  add esi,_v_buffer
  add esi,saddr

  ;time to copy image
line:
  mov ecx,xl
  copyECX
  add esi,sadd
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,ERROR
  ret
g_get endp

;Puts an image into temp buffer
;Performs clipping to view port
g_put proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local sadd:dword   ;src add
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_xb,dadd,sadd,edi,esi,1  ;Fast!

  add edi,_v_buffer
  add edi,saddr
  add esi,buf

  ;time to copy image
line:
  mov ecx,xl
  copyECX
  add esi,sadd
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,ERROR
  ret
g_put endp

;Puts an image into temp buffer except color #0
g_put0 proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local sadd:dword   ;src add
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_xb,dadd,sadd,edi,esi,1      ;Fast!

  add edi,_v_buffer
  add edi,saddr
  add esi,buf

  ;time to copy image
  .if cl==1
    mov ebx,0ffh
  .elseif cl==2
    mov ebx,0ffffh
  .elseif cl==3
    mov ebx,0ffffffh
  .else
    mov ebx,-1
  .endif
  mov edx,ecx
line:
  mov eax,xl
  copyECX0 edx,eax,1   ;edx=_v_bypp,eax=counter,1=Do not preserve ECX
  add esi,sadd
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,ERROR
  ret
g_put0 endp

;Puts a bit-packed-mono image into temp buffer except color #0
g_putb0 proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword,clr:dword
  local sadd:dword   ;src add
  local saddrot:byte ;src add (rotation optimization)
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_xb,dadd,sadd,edi,esi,1,1   ;Not Fast!  Do not shift ESI,SADD

  add edi,_v_buffer
  add edi,saddr

  ;Convert sadd => bitpack format
  mov eax,sadd
  shr sadd,3
  and al,7
  mov saddrot,al

  ;Convert ESI => bitpack format
  mov ebx,esi
  and bl,7
  shr esi,3
  add esi,buf

  ; bh = 2 ^ bl
  mov bh,1
@@:
  .if bl
    dec bl
    shl bh,1
    jmp @b
  .endif

  mov edx,ecx
  ;time to copy image
line:
  mov eax,xl
  copyECXb0 edx,eax,1   ;edx=_v_bypp,eax=counter,1=Do not preserve ECX
  add esi,sadd
  mov bl,bh
  mov cl,saddrot
  rol bh,cl
  cmp bh,bl
  .if carry?
    inc esi
  .endif
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,ERROR
  ret
g_putb0 endp
