include src\qlib.inc
include src\video.inc
include video.inc

.code
putpixel macro
  ;;EDI = pointer
  ;;ESI = max loc.
  ;;EDX = min loc.
  ;;EAX = color
  ;;CL = _v_bypp
  ;;Do not modify EDI (can't use string instructions)

  cmp edi,esi
  jae @f
  cmp edi,edx
  jl @f

  .if cl == 1
    mov [edi],al
  .elseif cl == 2
    mov [edi],ax
  .elseif cl == 3  ;;(24bit)
    mov [edi],ax
    ror eax,8
    mov [edi+2],ah
    rol eax,8
  .else  ;;4  (32bit)
    mov [edi],eax
  .endif
@@:
endm

g_line proc,x1:dword,y1:dword,x2:dword,y2:dword,clr:dword
  local cnt:dword,acc:dword
  local deltax:dword,deltay:dword,dirx:dword,diry:dword
  local _edx:dword

  ;Detect horz/vert lines for speed

  pushad

  mov ebx,_v_buffer
  mov ecx,_v_bypp

  mov edi,ebx
  mov eax,y1
  imul _v_xb
  add edi,eax
  mov eax,x1
  imul ecx
  add edi,eax

  mov eax,_v_win_y2
  imul _v_xb
  mov esi,eax
  add esi,ebx
  mov eax,_v_win_x2
  imul ecx
  add esi,eax

  mov eax,_v_win_y1
  imul _v_xb
  mov _edx,eax
  add _edx,ebx
  mov eax,_v_win_x1
  imul ecx
  mov edx,_edx
  add edx,eax

  mov acc,0

  mov eax,x2
  sub eax,x1
  mov ebx,ecx
  jns @f
  neg eax
  neg ebx
@@:
  mov deltax,eax
  mov dirx,ebx

  mov eax,y2
  sub eax,y1
  mov ebx,_v_xb
  jns @f
  neg eax
  neg ebx
@@:
  mov deltay,eax
  mov diry,ebx

  cmp eax,deltax
  jge yls

xls:
  mov eax,clr
  putpixel
  mov ebx,deltax
  mov cnt,ebx
xl1:
  dec cnt
  js done
  add edi,dirx
  mov ebx,deltay
  add acc,ebx
  mov ebx,acc
  cmp ebx,deltax
  jb noincy
  mov ebx,deltax
  sub acc,ebx
  add edi,diry
noincy:
  putpixel
  jmp short xl1



yls:
  mov eax,clr
  putpixel
  mov ebx,deltay
  mov cnt,ebx
yl1:
  dec cnt
  js done
  add edi,diry
  mov ebx,deltax
  add acc,ebx
  mov ebx,acc
  cmp ebx,deltay
  jb noincx
  mov ebx,deltay
  sub acc,ebx
  add edi,dirx
noincx:
  putpixel
  jmp short yl1
done:

  popad
  xor eax,eax

  ret
g_line endp

align 4
g_hline proc,x1:dword,y1:dword,x2:dword,col:dword
  callp g_line,x1,y1,x2,y1,col
  xor eax,eax
  ret
g_hline endp

align 4
g_vline proc,x1:dword,y1:dword,y2:dword,col:dword
  callp g_line,x1,y1,x1,y2,col
  xor eax,eax
  ret
g_vline endp

_endseg

end
