comment ^
included by video.asm
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Mouse Driver  v1.33
 by : Peter Quiring
 date: April 10,96
 updated: May 1,96
 updated: Oct 18,96
 updated: Dec 5,96  (added support for text modes - easy)
                    (added mouse_setcursor_text(color) )
 updated: Mar 12,97 (supports text modes properly)
 updated: Jan 3,98 (supports bitpacked pointers)
                   (renamed mouse_setcursor_text() => mouse_setcolor()
                     which also works for mono-bitpacked ptrs)
 updated: Feb 5,98 Improved VESA support.

 Generic mouse handler. (for 24/16/8 bit modes and Text modes)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!^

maxsiz equ 32    ;maximum size of cursor (x and y) must be a power of 2
_update_stk_siz equ (6*16)   ;must be a multipy of 6

.data?  ;starts DWORD aligned
  _update_stk db (_update_stk_siz) dup (?)

.data
align 4
ptrclr dd ?      ;pointer color (only if ptrtyp=1 or 2 or in Text mode)
mptr dd 0        ;Mouse PTR offset
userproc dd 0    ;callback routine
userproc_s dd 0  ;callback routine

prevx dw 0
prevy dw 0
xpos dw 0        ;Mouse x before ratio shift
ypos dw 0        ;Mouse y before ratio shift
hpx dw 0         ;hot point x
hpy dw 0         ;hot point y
mouse_con dw 0   ;cursor on?
but dw 0         ;button states
minx dw 0
miny dw 0
maxx dw (319)    ;These are absolute min that maxx,maxy could be
maxy dw (199) 
mx dw 0          ;Mouse x after ratio shift
my dw 0          ;Mouse y after ratio shift
ptrx dw 1        ;size x
ptry dw 1        ;size y
m_paws db 0      ;special printing mouse thingy
ptrtyp db 0      ;pointer type
                 ;  0=normal
                 ;  1=single color (byte packed) [Obsolete]
                 ;  2=single color (bit packed)  (NEW : v2.07 Beta #4)
backbuf dd 0     ;temp buffer  ;*4 for color-depths
oldbank db 0     ;backup of vesa_current_bank
oldplane_wr db 0 ;backup of modex_plane_wr
oldplane_rd db 0 ;backup of modex_plane_rd
inited db 0
once db 0        ;set the 1st time mouse_hand is used
inuse db 0       ;set while mouse handler is in use (to prevent glitches)
erased db 0      ;Mouse Ptr erased (to prevent being erased twice)
_update_head dd 0     ;Update needed?  head pointer
_update_tail dd 0     ;tail pointer
xratio db 1
yratio db 1
ptrtmp g_mousehead <>

.code

mouse_hand  proto

mouse_init proc
  pushad
  mov ax,0
  int 33h
  cmp ax,0
  jnz @f
  popad
  mov eax,ERROR
  ret
@@:
  .if inited
bad:
    popad
    mov eax,ERROR
    ret
  .endif
  mov inited,1

  push cs
  pop es
  mov edx,offset mouse_hand
  mov cx,0ffh  ;all movement & buttons cause a callback
  mov ax,0ch
  int 33h   ;PMODE/W extender INT
  mov es,seldata

  ;setup self-uninit
  callp atexit,offset mouse_uninit

  ;setup X/Y
  mov ax,wptr[_v_x]
  dec ax
  mov maxx,ax
  mov ax,wptr[_v_y]
  dec ax
  mov maxy,ax

  .if backbuf == 0
    callp malloc,maxsiz*maxsiz*4
    mov backbuf,eax
    cmp eax,NULL
    jz bad
  .endif

  popad
  xor eax,eax
  ret
mouse_init endp

mouse_uninit proc ;will self-uninit during atexit procedure
  pushad

  ;disable callback thingy
  push dptr 0  ;32bit !!!
  pop es
  xor edx,edx
  xor ecx,ecx  ;no movement & buttons cause a callback
  mov ax,0ch
  int 33h
  mov es,seldata

  mov inited,0
  popad
  ret
mouse_uninit endp

;mask for callbacks
; CX = : bit # : cause because...
;          0     cursor moved
;          1     left pressed
;          2     left released
;          3     right pressed
;          4     right released
;        5-15    not used
          ;5,6=middle button (if 3 button)

align 4
mouse_setcursor proc uses ebx,_cur:dword
  ;ONLY called when mouse is off or from the callback
  mov ebx,_cur
  mov mptr,ebx
  add mptr,sizeof g_mousehead
  xor eax,eax
  mov ax,[ebx].g_mousehead.x
  cmp ax,maxsiz     ;FIX : v2.03 Beta #4 : this was 'and'?
  jbe @f
  mov ax,maxsiz
@@:        
  mov ptrx,ax
  mov ax,[ebx].g_mousehead.y
  cmp ax,maxsiz     ;FIX : v2.03 Beta #4 : this was 'and'?
  jbe @f
  mov ax,maxsiz
@@:
  mov ptry,ax
  mov ax,[ebx].g_mousehead.hx
  mov hpx,ax
  mov ax,[ebx].g_mousehead.hy
  mov hpy,ax
  mov al,[ebx].g_mousehead.flg
  mov ptrtyp,al
  xor eax,eax
  ret
mouse_setcursor endp

align 4
mouse_setcolor proc,_color:dword
  mov eax,_color
  mov ptrclr,eax
  ret
mouse_setcolor endp

align 4
mouse_getcolor proc
  mov eax,ptrclr
  ret
mouse_getcolor endp

include mptr.asm

align 4
mouse_setpos proc,x:dword,y:dword
  pushad
  push mouse_con
  call mouse_off

  inc inuse

  mov eax,x
  mov cl,xratio
  sal eax,cl   ;signed shift left
  mov xpos,ax
  mov eax,y
  mov cl,yratio
  sal eax,cl
  mov ypos,ax
  call update
  pop ax
  .if ax
    call mouse_on
  .endif

  dec inuse

  popad
  ret
mouse_setpos endp

align 4
mhandler proc private
  ;Called to Update mouse
  ;Input : BX=buttons  SI,DI=mouse movement
  local moved:byte

  inc inuse   ;This PROC must not be interrupted

  mov but,bx

  .if once  
    mov ax,prevx
    mov prevx,si
    sub si,ax
    mov ax,prevy
    mov prevy,di
    sub di,ax
  .else
    mov prevx,si
    mov prevy,di
    xor si,si
    xor di,di
    inc once  ;set once
  .endif

  test mouse_con,1
  jz @f
  .if (si!=0) || (di!=0)
    pushad
    callp _erase,0
    popad
    mov moved,1 ;it moved!
  .else
@@:
    mov moved,0
  .endif

;change X/Y values
  add xpos,si
  add ypos,di
  call update

  .if userproc
    mov edi,userproc_s
    mov ax,mx
    mov [edi].mouse_user.x,ax
    mov ax,my
    mov [edi].mouse_user.y,ax
    mov ax,but
    mov [edi].mouse_user.but,ax
    call [userproc]  ;this is good for changing the cursor shape for new areas
  .endif
  .if (mouse_con)&&(moved)
    callp _print,0
  .endif 
exit_hand:

  dec inuse

  ret
mhandler endp

_update_push macro
  local t1
  ;;push onto update stack
  mov eax,_update_head
  add eax,6
  cmp eax,_update_stk_siz
  jne t1
  xor eax,eax
t1:
  cmp eax,_update_tail
  je done  ;table FULL (mouse update ignored!)  That's bad :(
  mov ecx,offset _update_stk
  mov [ecx+eax],bx
  mov [ecx+eax+2],si
  mov [ecx+eax+4],di
  mov _update_head,eax
endm

_update_pop macro
  local t1
  ;;pop onto update stack
  mov eax,_update_tail
  cmp eax,_update_head
  je done
  add eax,6
  cmp eax,_update_stk_siz
  jne t1
  xor eax,eax
t1:
  mov ecx,offset _update_stk
  mov bx,[ecx+eax]
  mov si,[ecx+eax+2]
  mov di,[ecx+eax+4]
  mov _update_tail,eax
endm

_update_add macro
  ;;add onto update stack
  mov ecx,offset _update_stk
  cmp bx,[ecx+eax]
  jne __ADDENTRY
  ;add SI and DI to last entry
  add [eax+2],si
  add [eax+4],di
endm

align 4
;FIX : v2.11 b2 : was not private
;FIX : v2.11 b5 : 'INC INUSE' was inside loop!
mhandler_chk proc private
  ;undos the whole update table
  inc inuse
undo:
  _update_pop
  call mhandler
  jmp undo
done:
  dec inuse   ;IF disabled!
  ret
mhandler_chk endp

align 4
mouse_hand proc private
  ;entry : ax=mask w/ condtion that cause this call
  ;      : bx=buttons (bit 0=left,bit 1=right)
  ;      : cx=horz pos  (I ignore)
  ;      : dx=vert pos  (")
  ;      : si=horz counts (mickeys)
  ;      : di=vert " (")

  pushad
  pushf
  push ds
  push es
  push fs
  push gs
  mov ax,cs:seldata  ;use AX since Win95 trashes it anyways
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
  cld
  mov ax,901h  ;Enable IF and return IF status
  int 31h
  mov dx,ax
  ; FIX : Ver 1.1 : Ignore ax cause Win95 does not return it properly!!!
  ;       instead use BX which is easier anyways!

  .if (inuse)
    ;Can't use _erase or _print so I gotta 'push'
    ;  mouse info onto _update_stk (stack)
    mov eax,_update_head
    cmp eax,_update_tail
    je __ADDENTRY
    ;Try to add to last entry if mouse button status is the same
    _update_add
    jmp done
__ADDENTRY:
    _update_push
    jmp done
  .endif
  push dx
  call mhandler
  call mhandler_chk  ;Check stack for any updates?
  pop dx
done:
  mov ax,dx
  int 31h    ;Restore IF
  pop gs
  pop fs
  pop es
  pop ds
  popf
  popad
  retf
mouse_hand endp

align 4
mouse_setspd proc,xr:byte,yr:byte  ; (1-4 , 1-4)
  local x:word,y:word
  pushad
  push mouse_con
  call mouse_off

  inc inuse
  cli

  mov ax,xpos
  mov cl,xratio
  sar ax,cl   ;signed shift
  mov x,ax
  mov ax,ypos
  mov cl,yratio
  sar ax,cl
  mov y,ax

  mov al,xr
  dec al
  and al,3
  ;al=0-3
  mov xratio,al

  mov al,yr
  dec al
  and al,3
  ;al=0-3
  mov yratio,al

  mov ax,x
  mov cl,xratio
  sal ax,cl   ;signed shift
  mov xpos,ax
  mov ax,y
  mov cl,yratio
  sal ax,cl
  mov ypos,ax

  call update
  pop ax
  .if ax
    call mouse_on
  .endif

  dec inuse
  sti

  popad
  ret
mouse_setspd endp

align 4
mouse_setwin proc,x1:dword,y1:dword,x2:dword,y2:dword
  pushad
  push mouse_con
  call mouse_off
;x
  mov eax,x1
  mov minx,ax
  mov eax,x2
  mov maxx,ax
;y
  mov eax,y1
  mov miny,ax
  mov eax,y2
  mov maxy,ax

  call update
  pop ax
  .if ax
    call mouse_on
  .endif
  popad
  ret
mouse_setwin endp

;update x/y with maxx/maxy and ratios
align 4
update proc private
  mov ax,xpos
  mov cl,xratio
  sar ax,cl
  cmp ax,minx
  jge @f
  mov ax,minx
  sal ax,cl
  mov xpos,ax
  sar ax,cl
@@:
  cmp ax,maxx
  jle @f
  mov ax,maxx
  sal ax,cl
  mov xpos,ax
  sar ax,cl
@@:
  mov mx,ax

  mov ax,ypos
  mov cl,yratio
  sar ax,cl
  cmp ax,miny
  jge @f
  mov ax,miny
  sal ax,cl
  mov ypos,ax
  sar ax,cl
@@:
  cmp ax,maxy
  jle @f
  mov ax,maxy
  sal ax,cl
  mov ypos,ax
  sar ax,cl
@@:
  mov my,ax

  ret
update endp

align 4
mouse_on proc
  .if !ptrx || !ptry      ;mouse ptr not setup???
    mov eax,ERROR
    ret
  .endif
  pushad
  cli
  .if !mouse_con
    .if userproc
      mov edi,userproc_s
      mov ax,mx
      mov [edi].mouse_user.x,ax
      mov ax,my
      mov [edi].mouse_user.y,ax
      mov ax,but
      mov [edi].mouse_user.but,ax
      call [userproc]
    .endif
    callp _print,0
    inc mouse_con   ;set to 1
  .endif
  sti
  popad
  ret
mouse_on endp

align 4
mouse_off proc
  pushad
  cli
  .if mouse_con
    mov mouse_con,0
    callp _erase,0
  .endif
  sti
  popad
  ret
mouse_off endp

align 4
mouse_setuser proc,func:dword,us:dword
  .if (func==NULLPROC) || (func==0)
    mov userproc,0
  .else
    mov eax,func
    mov userproc,eax
    mov eax,us
    mov userproc_s,eax
  .endif
  xor eax,eax
  ret
mouse_setuser endp

align 4
mouse_loadcursor proc,nam:dword
  local h:word

  pushad
  mov mptr,0
  callp open,nam,O_BINARY or O_RDONLY
  cmp eax,ERROR
  jnz @f
  popad
  mov eax,ERROR
  ret
@@:
  mov h,ax
  callp read,ax,offset ptrtmp,sizeof g_mousehead
  .if eax!=sizeof g_mousehead
bad:
    callp free,mptr
    mov mptr,0
    callp close,h
    popad
    mov eax,ERROR
    ret
  .endif
  mov esi,offset ptrtmp
  cmp dptr[esi],01a525450h  ;PTR,26
  jnz bad
  movzx eax,[esi].g_mousehead.x
  movzx ebx,[esi].g_mousehead.y
  movzx ecx,[esi].g_mousehead.bypp
  mov dl,[esi].g_mousehead.flg

  .if (dl != 2) && (dl)
    jmp bad
  .endif

  mov ptrtyp,dl
  .if !dl
    mov ptrclr,0  ;not used
  .else
    .if _v_bypp==1
      mov ptrclr,31 ;default White colour
    .else
      mov ptrclr,0ffffffffh  ;White colour
    .endif
  .endif
  mov ptrx,ax
  mov ptry,bx

  mul ebx
  mul ecx
  .if ptrtyp & 2
    mov bl,al
    shr eax,3  ;/8
    test bl,7
    .if !zero?
      inc eax
    .endif
  .endif
  mov ebx,eax
  add eax,sizeof g_mousehead
  callp malloc,eax
  .if eax==ERROR
    jmp bad
  .endif
  mov mptr,eax
  mov edx,eax
  mov esi,offset ptrtmp
  mov edi,eax
  mov ecx,sizeof g_mousehead
  copyECX  ;destroys AL
  mov ecx,edx
  add ecx,sizeof g_mousehead
  callp read,h,ecx,ebx
  cmp eax,ebx
  jnz bad
  callp close,h
  popad
  mov eax,mptr
  ret
mouse_loadcursor endp

