; 16bit version for C utils
; *******************************************************
; *     File Name Split Routine                         *
; *							*
; * Fix by Sune Marcher, 02/22/98:                      *
; *   uses C strings and runs under 32bit pmode         *
; * Fix by Peter Quiring, 03/20/98:                     *
; *   changed layout for QLIB (no code change)          *
; * Fix by Peter Quiring, 03/28/98:                     *
; *   many bugs were fixed, supports long file names    *
; *******************************************************

.model small,c
.286
.code

fsplit proc full:word,path:word,nam:word,ext:word
  pusha

  cld
  mov   di,full
  mov   si,di

  ; find end of the string
  or    cx,-1          ; faster than mov ecx,-1 (2 bytes shorter)
  xor   al,al
  repnz scasb

  not   cx             ; ..
  dec   cx             ; string length in ECX

  mov   bx, cx

  or    bx,bx
  je    @@2

;Get File Extension
  xor cx,cx  ;size of extension
  mov di,ext
@@1:
  cmp   byte ptr [si+bx-1],'.'
  je    gotext
  cmp   byte ptr [si+bx-1],'\'
  je    noext
  cmp   byte ptr [si+bx-1],':'
  je    noext
  inc   cx
  dec   bx
  jnz   @@1

noext:
  add bx,cx  ;move back for FileName checking
  xor cx,cx
  inc bx  ;We are going to DEC for '.' but there is none

gotext:
  ;Copy cx bytes [si+bx] => ext
  call CopyString

  dec bx  ;DEC for '.' (removed)

;Get File Name
  mov di,nam
  xor cx,cx
  test bx,bx
  jz noname
@@2:
  cmp   byte ptr [si+bx-1],'\'
  je    @@3
  cmp   byte ptr [si+bx-1],':'
  je    @@3
  inc   cx
  dec   bx
  jnz   @@2

@@3:
noname:
  ;Copy cx bytes [si+bx] => ext
  call CopyString

;Get PATH
  mov di,path
  xor cx,cx
  test bx,bx
  jz nopath
  mov cx,bx
  xor bx,bx

nopath:
  ;Copy cx bytes [si+bx] => ext
  call CopyString

  popa
  ret
fsplit endp

CopyString proc private
  ; Input : si+bx = pointer to copy from
  ;       : di = pointer to copy to
  ;       : cx = amount to copy

  test di,di
  jz @@out

  push si
  add si,bx
  rep movsb
  xor al,al
  stosb  ;Store NULL terminator
  pop si

@@out:
  ret
CopyString endp

end
