// Creates two simply bit-packed sample mouse pointer file (8*8)

#include <qlib.h>
#include <string.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <fCNTL.H>
#include <video.h>

word a,b;
sword f;
byte bp;

byte Buf[11];

byte buf1[10*8]={
 01,01,01,01,01,01,01,01,00,00,
 01,01,01,01,01,01,01,00,00,00,
 01,01,01,01,01,00,00,00,00,00,
 01,01,01,01,01,00,00,00,00,00,
 01,01,01,01,01,01,00,00,00,00,
 01,01,00,00,01,01,01,00,00,00,
 01,00,00,00,00,01,01,01,00,00,
 01,00,00,00,00,00,01,00,00,00 };

byte buf2[8*8]={
 01,01,01,01,01,01,01,01,
 00,01,01,01,01,01,01,00,
 00,00,00,01,01,00,00,00,
 00,00,00,01,01,00,00,00,
 00,00,00,01,01,00,00,00,
 00,00,00,01,01,00,00,00,
 00,01,01,01,01,01,01,00,
 01,01,01,01,01,01,01,01 };

struct g_mousehead mh;

void writeptr(char *fn,byte *buf,byte _x);

void main (void)
{

  writeptr("gfx\\MOUSE.PTR",buf1,10);        //basic pointer
  writeptr("gfx\\HOURGLS.PTR",buf2,8);      //hour glass

  printf("Done!\n");
}

void writeptr(char *fn,byte *buf,byte _x) {
  word p;

  f=open(fn,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY, S_IWRITE);
  if (f==-1)
  {
    printf("file io error\n");
    exit(0);
  }

  strcpy(mh.head,"PTR");
  mh.head[3]=0x1a;
  mh.x=_x;   //NEW : v2.11 Beta #1 : to test out grafix better...
  mh.y=8;
  mh.bpp=0;   //ignored in bitpacked files since it can work in any depth
  mh.bypp=1;  //must be 1 
  mh.flg=2;   //2 = bitpacked!
  mh.hx=0;
  mh.hy=0;

  write(f,&mh,sizeof(mh));

  p=0;
  bp=1;
  Buf[p]=0;
  for (a=0;a<_x*8;a++) {
    *(Buf+p) |= *(buf+a) ? bp : 0;
    bp <<= 1;
    if (bp==0) {bp=1;p++;Buf[p]=0;}
  }

  write(f,Buf,_x);
  close(f);
}

