;QLIB Compress test program

include qlib.inc
include string.inc
include stdio.inc
include conio.inc
include process.inc

include compress.inc

typ equ COMP_LZ

debug equ

.data
bufstart equ $
  bufi label byte
;  db 64 dup ('A')
;  db 0
  db 'TESTING TESTING 123...'
  db 0    ;NULL : so I just print one line
  db 'TESTING TESTING 123..x'
  db 'TESTING TESTING 123...'
  db 'TESTING TESTING 123..y'
  db 'TESTING TESTING 123...'
  db 'TESTING TESTING 123..z'
  db 'TESTAAAAAAAAAAAAA.....'
  db 8192 dup ('A')
  db 'TESTING TESTING 123..1'
  db 'TESTING TESTING 123..2'
  db 'TESTING TESTING 123..3'
  db 'TESTING TESTING 123..4'
bufsiz equ ($-bufstart)
  bufo db (bufsiz+COMP_OFLOW) dup (?)   ;compressed data
  newdata db bufsiz dup (0)             ;uncompressed data

  siz dd ?       ;size of compressed data

.code

main proc
  call clrscr

  callp printf,"Compression test\n\n"

  callp printf,"Compression Type:"
  if typ eq COMP_LZ
    callp printf,"LZ\n"
  elseif typ eq COMP_LZW
    callp printf,"LZW\n"
  elseif typ eq COMP_STORE
    callp printf,"STORE\n"
  else
    callp printf,"???\n"
    callp exit,0
  endif

  callp CompressBuffer,offset bufo,bufsiz+COMP_OFLOW,offset bufi,bufsiz,COMP_NOSTORE,typ
  mov siz,eax
  callp printf,"Compressed data size      :%i\n",eax
  callp printf,"Uncompressed data size    :%i\n",bufsiz
  
  callp DecompressBuffer,offset newdata,bufsiz,offset bufo
  .if eax==ERROR
    callp printf,"New Uncompressed data size: ERROR\n"
  .else
    callp printf,"New Uncompressed data size:%i\n",eax
  .endif

;  mov eax,offset newdata   ;unrem these to corrupt the data
;  mov [eax],ax             ;just to prove the check is working

  callp printf,"\nbufi data:%s\n",offset bufi
  callp printf,"New  data:%s\n\n",offset newdata

  callp memcmp,offset bufi,offset newdata,bufsiz
  .if eax
    callp printf,"Data corrupted!!!! Compression failed!!\n\n"
  .else
    callp printf,"Compression successful\n\n"
  .endif

ifdef debug
  callp printf,"sample bufo data:\n"
  mov esi,offset bufo
  mov ecx,siz
  .if ecx>50
    mov ecx,50
  .endif
  xor eax,eax
@@:
  lodsb
  callp printf,"%02xh,",al
  dec ecx
  jnz @b
  callp putch,8
  callp putch,' '  ;remove last ,
endif

  ret
main endp

end
