#include <qlib.h>
#include <except.h>
#include <stdio.h>
#include <process.h>

// Demonstrates the Pure Virtual Function handler

class A;
void test_virtual( A *p );

// class A has a pure virtual function...
class A {
  public:
    A( void ) {
      // this call to test_virtual will fail because
      // the entire vtable has not been built and there
      // are still calls to _purecall
      test_virtual( this );
    }
    virtual void func( void ) = 0;
};

// class B implement this virtual function...
class B : public A {
  public:
    B( void ) {
      // this call to test_virtual will succeed because
      // by this time the vtable is properly created
      test_virtual( this );
    }
    virtual void func( void ) {
      return;
    }
};

// this function simply calls the virtual function...
void test_virtual( A* p ) {
  p->func();
}

void do_vir(void) {
  B test;  //create class B, whose constructor will call a pure virtual
           //function
}

void new_handler(void) {
  printf("Error : A pure virtual function has been called\n");
  printf("This program will now terminate...\n");
  exit(0);
}

void main( void ) {
  SetExceptHandler(EH_PURE_VIRTUAL,new_handler);
  do_vir();
}


