/************************************************************************

  File:		timestmp.h
  Function:	Definition of timedata structure for time and date
  Version:	1.00
  Author:	R. Sjoberg (SJOBRG@MIT-OZ)
  History:	10/16/83 - original V1.00

************************************************************************/

struct timedata {
    int tim_yr;		/* year, range 1980 and higher */
    int tim_mon;	/* month, range 1-12 */
    int tim_dat;	/* date in month, range 1-31 */
    int tim_dow;	/* day of week index, 0 (Sun) to 6 (Sat) */
    int tim_hr;		/* hour of day, range 0-23 */
    int tim_min;	/* minute, range 0-59 */
    int tim_sec;	/* second, range 0-59 */
};

/* NOTE:  If day of week (tim_dow) is not available, the value in
 *	  this field should be -1
 */

/* The following are defined in timestmp.c */

extern char *timemon[];	/* names of months, suitable for use with
			   tim_mon field (3-char abbreviations) */

extern char *timedow[];	/* day of week names, suitable for use with
			   tim_dow field (3-char abbreviations) */
