#include	"va.h"
#include	"vadef.h"
#include	"edit.h"

#if MSDOS & LATTICE

#define	CDCGA	0			/* color graphics card		*/
#define	CDMONO	1			/* monochrome text card		*/

/* getboard:	Determine which type of display board is attached.
		Current known types include:

		CDMONO	Monochrome graphics adapter
		CDCGA	Color Graphics Adapter
		CDEGA	Extended graphics Adapter
*/

/* getboard:	Detect the current display adapter
		if MONO		set to MONO
		   CGA		set to CGA
		   EGA		set to CGA
*/

	int boardSEG;	/* Segment of screen memory */
static	int mode;	/* mode of screen image */
static	int xcursor;	/* xcoord. of cursor */
static	int ycursor;	/* ycoord. of cursor */
static	int page;	/* display page nr */
static	int curch;	/* cursor h value */
static	int curcl;	/* cursor l value */
static	byte screen[16384];	/* old screen */
static	byte lowmem[30];	/* 0000:0449h 30 bytes video stuff */

int getboard()
{	union REGS rg;

	int type;	/* board type to return */

	type = CDCGA;
	int86(0x11, &rg, &rg);
	if ((((rg.x.ax >> 4) & 3) == 3))
		type = CDMONO;

	switch (type) {
		case CDCGA:
			boardSEG = 0xb800;
			break;
		case CDMONO:
			boardSEG = 0xb000;
			break;
	}
}/*getboard*/

getpage()
{	union REGS rg;

	rg.h.ah = 0xf;
	int86(0x10,&rg,&rg);	/* get current display page and mode */
	page = rg.h.bh;
	mode = rg.h.al;
}/*getpage*/

putpage()
{	union REGS rg;

	/* check mode only if diff then set */
	rg.h.ah = 0xf;
	int86(0x10,&rg,&rg);
	if (rg.h.al == mode) {
		/* nothing */
	} else {
		rg.h.ah = 0;
		rg.h.al = mode;
		int86(0x10,&rg,&rg);	/* set mode */
	}

	/* set display page if different */
	rg.h.ah = 0xf;
	int86(0x10,&rg,&rg);
	if (rg.h.bh == page) {
		/* nothing */
	} else {	
		rg.h.ah = 0x5;
		rg.h.al = page;
		int86(0x10,&rg,&rg);	/* set active page */
	}
}/*putpage*/

putcursor()
{	union REGS rg;

	rg.h.ah = 0x1;
	rg.h.ch = curch;
	rg.h.cl = curcl;
	int86(0x10,&rg,&rg);	/* set cursor size */

	rg.h.ah = 0x2;
	rg.h.bh = page;
	rg.h.dh = ycursor;
	rg.h.dl = xcursor;
	int86(0x10,&rg,&rg);	/* set cursor position */
}/*putcursor*/

getcursor()
{	union REGS rg;

	rg.h.ah = 0x3;
	rg.h.bh = page;
	int86(0x10,&rg,&rg);	/* get cursor position and size */
	curch = rg.h.ch;
	curcl = rg.h.cl;
	xcursor = rg.h.dl;
	ycursor = rg.h.dh;
}/*getcursor*/

/* getlowmem*/
getlowmem()
{
	peek(0,0x449,lowmem,30);
}/*getlowmem*/

/* putlowmem */
putlowmem()
{
	poke(0,0x449,lowmem,30);
}/*putlowmem*/

/* copy current screen into screen[] */
pushscreen()
{
	getlowmem();
	getboard();
	peek(boardSEG,0,screen,16384);
	getpage();	/* get display page and mode */
	getcursor();
}/*getscreen*/

/* fill current screen with contents of screen[] */
popscreen()
{
	putpage();	/* put display page and mode */
	putcursor();	
	poke(boardSEG,0,screen,16384);
	putlowmem();
}/*putscreen*/

/* called from note with empty note, we must insert original screen */
insscreen()
{	register int	r,c;
	register char *ptr,*lptr;
	int	ch,len;

	switch (mode) {
		case 0:
		case 1:
			len = 40;
			break;
		case 2:
		case 3:
		case 7:
			len = 80;
			break;
		default:
			TTbeep();
			return;
	}
	ptr = screen;
	for (r=0; r<25; r++) {
		for (c=0; c<len; c++) {
			ch = *ptr;
			ptr += 2;
			/* blank out non printables */
			if (ch =='\r') ch = ' ';
			if ( (ch < ' ') || (ch > '~') ) ch = ' ';
			inschar(ch);
		}
		/* take of trailing spaces */
		lptr = &(editroot->curline->line[len-1]);
		for (c=len-1; c>=0; c--) {
			if (*lptr != ' ') break;
			(editroot->curline->length)--;
			*lptr = '\0';
			lptr--;
		}
		goeol();
		inschar('\r');
	}
}/*insscreen*/
#endif
