/****************************************************************************/
/*																																					*/
/* UW_GLOBX.H 																															*/
/*																																					*/
/* This module contains all the externs used by the UltraWIN library.       */
/*																																					*/
/*																													Kevin Huck			*/
/*																													Boyd Gafford		*/
/*																																					*/
/****************************************************************************/
#include <conio.h>

extern int	 				Num_windows;				/* number of open windows on desk!	*/
#ifdef M_I86
extern uchar	far		*Screen;										/* ponter to physical screen loc		*/
#else
extern uchar	far	*Screen;													/* ponter to physical screen loc		*/
#endif
extern uchar	 			V_cols;							/* columns on the video screen			*/
extern uchar				V_rows;							/* rows on the video screen					*/
extern int 		 			V_mode;							/* old video mode!									*/

extern int		 			DV_seg;							/* Desqview variables								*/
extern int		 			DV_off;
extern int		 			DV_flag;
extern int		 			DV_upd;

extern uchar 	 			Dflt_att; 					/* default colors for windows				*/
extern uchar 	 			Dflt_bdr_att;

extern int		 			Stack[64];
extern int		 			Stack_ptr;					/* stack to save wn states					*/
extern int		 			Csr_visible;				/* is the cursor visible						*/
extern int		 			Csr_in_use;					/* is the cursor used by a popup?		*/

extern EVENT	 			Event;							/* the global event variable        */
extern int		 			Mouse_exists;				/* is the mouse available or not?		*/

extern WINDOW	 			*First_window;			/* manager first window pointer			*/
extern WINDOW	 			*Last_window;				/* manager last window pointer			*/

extern int		 			(*Idle_func)();			/* global function pointer					*/
#ifdef __cplusplus
extern int		 			(*Vld_func)(...);		/* global function pointer					*/
extern int		 			(*Gets_hook_func)(...);		/* global function pointer					*/
#else
extern int		 			(*Vld_func)();			/* global function pointer					*/
extern int		 			(*Gets_hook_func)();/* global function pointer					*/
#endif
extern uchar        Fgnd, Bkgnd;					/* fore/background for graphics mode*/
extern int          Graphics;						/* set to 1 if graphics mode				*/
extern int          X_res, Y_res;				/* x, y, res for graphics mode      */
extern int         Font_rows, Font_spacing;		/* rows in font, font spacing	*/
extern int          Gseg, Goff;					/* graphics screen segment, offset  */
extern int          Bytes_per_row;				/* bytes per graphics row						*/
extern int         Ega, Vga, EgaVga;	  /* 1 if present	(mutually exclusive)*/
extern int G_csrx, G_csry, G_csr_char, G_opt;
extern PRINT        *Printers[MAX_PRINTERS];	 /* printer que structure ptrs  */

extern int          Uw_timers[4];						 /* user timers - decrement to 0*/
extern int          Sys_timer[2], Sound_timer;/* system/sound timers         */
extern int          Clock_init; 							 /* 1 if we have clock vector		*/
extern int          Sound_on; 								 /* 1 when sound is on					*/
extern ulong        Tics;										 /* total clock interrupts			*/

/**** END OF FILE ****/
