/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n)
{
fraction k;
fraction l;
fraction kl;

double pbP    [MXR][MXC*TWOCOL];matrix mP    ={MXR,MXC*TWOCOL,&pbP    [0][0]};
double pblP   [MXR][MXC*TWOCOL];matrix mlP   ={MXR,MXC*TWOCOL,&pblP   [0][0]};
double pbk_lP [MXR][MXC*TWOCOL];matrix mk_lP ={MXR,MXC*TWOCOL,&pbk_lP [0][0]};
double pbkl_P [MXR][MXC*TWOCOL];matrix mkl_P ={MXR,MXC*TWOCOL,&pbkl_P [0][0]};

double pk_lP_mns_kl_P[MXR][MXC*TWOCOL];
matrix mk_lP_mns_kl_P={MXR,MXC*TWOCOL,&pk_lP_mns_kl_P[0][0]};

                 mP.rows = n;               mP.cols = 1*TWOCOL;
                mlP.rows = n;              mlP.cols = 1*TWOCOL;
              mk_lP.rows = n;            mk_lP.cols = 1*TWOCOL;
              mkl_P.rows = n;            mkl_P.cols = 1*TWOCOL;
     mk_lP_mns_kl_P.rows = n;   mk_lP_mns_kl_P.cols = 1*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  k = rndFI (5);
  l = rndFI (5);

  rndmI(&mP,5);

  clrscrn();
  printf("\n      P = ");
  printpolyI(&mP);
  printf("\n      l = %3.0f\n", l.numer);
  printf("\n     lP = ");
  smultmF(l,&mP,&mlP);
  printpolyI(     &mlP);
  printf("\n      k = %3.0f\n", k.numer);
  printf("\n  k(lP) = ");
  smultmF(k,&mlP,&mk_lP);
  printpolyI(      &mk_lP);
  getchar();

  clrscrn();
  printf("\n      k = %3.0f\n", k.numer);
  printf("\n      l = %3.0f\n", l.numer);
  kl = multF(k,l);
  printf("\n     kl = %3.0f\n", kl.numer);

  printf("\n      P = ");
  printpolyI(&mP);
  printf("\n  (kl)P = ");
  smultmF(kl,&mP,&mkl_P);
  printpolyI(    &mkl_P);
  getchar();

  clrscrn();
  printf("\n             k(lP) = ");
  printpolyI(&mk_lP);
  printf("\n             (kl)P = ");
  printpolyI(&mkl_P);
  printf("\n [k(lP)] - [(kl)P] = ");
  submF(&mk_lP, &mkl_P,&mk_lP_mns_kl_P);
  printpolyI(          &mk_lP_mns_kl_P);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n            Vector space axioms.                  ");
  printf("\n                                                  ");
  printf("\n                 k(lP) = (kl)P                    ");
  printf("\n                 *************                    ");
  printf("\n\n\n                                              ");
  printf("\n The degree of P, v : 2 ... 4.                  \n");
  printf("\n     ex : \"pgI.exe\"                           \n");
  printf("\n You can choose the degree :                    \n");
  printf("\n     ex : \"pgI.exe 2\"                           ");
  printf("\n          \"pgI.exe 4\"                         \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {    n=rndpI(4);}
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












