/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};
double pbw    [MXR][MXC*TWOCOL];matrix mw    ={MXR,MXC*TWOCOL,&pbw    [0][0]};

double pvplsw[MXR][MXC*TWOCOL];matrix mvplsw={MXR,MXC*TWOCOL,&pvplsw[0][0]};
double pupls_vplsw[MXR][MXC*TWOCOL];
matrix mupls_vplsw={MXR,MXC*TWOCOL,&pupls_vplsw[0][0]};

double puplsv[MXR][MXC*TWOCOL];matrix muplsv={MXR,MXC*TWOCOL,&puplsv[0][0]};
double puplsv_plsw[MXR][MXC*TWOCOL];
matrix muplsv_plsw={MXR,MXC*TWOCOL,&puplsv_plsw[0][0]};

double pupls_vplsw_mns_uplsv_plsw [MXR][MXC*TWOCOL];
matrix mupls_vplsw_mns_uplsv_plsw={MXR, MXC*TWOCOL,
      &pupls_vplsw_mns_uplsv_plsw[0][0]};

if(vectrow)
  {
          mu.rows = 1;               mu.cols = n*TWOCOL;
          mv.rows = 1;               mv.cols = n*TWOCOL;
          mw.rows = 1;               mw.cols = n*TWOCOL;
      mvplsw.rows = 1;           mvplsw.cols = n*TWOCOL;
      muplsv.rows = 1;           muplsv.cols = n*TWOCOL;
 mupls_vplsw.rows = 1;      mupls_vplsw.cols = n*TWOCOL;
 muplsv_plsw.rows = 1;      muplsv_plsw.cols = n*TWOCOL;

 mupls_vplsw_mns_uplsv_plsw.rows = 1;
 mupls_vplsw_mns_uplsv_plsw.cols = n*TWOCOL;
  }
else
   {
          mu.rows = n;               mu.cols = 1*TWOCOL;
          mv.rows = n;               mv.cols = 1*TWOCOL;
          mw.rows = n;               mw.cols = 1*TWOCOL;
      mvplsw.rows = n;           mvplsw.cols = 1*TWOCOL;
      muplsv.rows = n;           muplsv.cols = 1*TWOCOL;
 mupls_vplsw.rows = n;      mupls_vplsw.cols = 1*TWOCOL;
 muplsv_plsw.rows = n;      muplsv_plsw.cols = 1*TWOCOL;

 mupls_vplsw_mns_uplsv_plsw.rows = n;
 mupls_vplsw_mns_uplsv_plsw.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmI(&mu,5);
  rndmI(&mv,5);
  rndmI(&mw,5);

  clrscrn();
  printf("                                 v\n");
  printmI3(&mv);
  printf("                                 w\n");
  printmI3(&mw);
  printf("                                 v + w\n");
  addmF(&mv,&mw,&mvplsw);
  printmI3(     &mvplsw);
  getchar();

  clrscrn();
  printf("                                  u\n");
  printmI3(&mu);
  printf("                                      (v + w)\n");
  printmI3(&mvplsw);
  printf("                                  u + (v + w)\n");
  addmF(&mu,&mvplsw,&mupls_vplsw);
  printmI3(         &mupls_vplsw);
  getchar();

  clrscrn();
  printf("                                 u\n");
  printmI3(&mu);
  printf("                                 v\n");
  printmI3(&mv);
  printf("                                 u + v\n");
  addmF(&mu,&mv,&muplsv);
  printmI3(     &muplsv);
  getchar();

  clrscrn();
  printf("                                 (u + v)\n");
  printmI3(&muplsv);
  printf("                                           w\n");
  printmI3(&mw);
  printf("                                 (u + v) + w\n");
  addmF(&muplsv,&mw,&muplsv_plsw);
  printmI3(         &muplsv_plsw);
  getchar();

  clrscrn();
  printf("                                              u + (v  + w)\n");
  printmI3(&mupls_vplsw);
  printf("                                             (u +  v) + w\n");
  printmI3(&muplsv_plsw);
  printf("                             [u + (v + w)] - [(v + u) + w]\n");
  submF(&mupls_vplsw,&muplsv_plsw,&mupls_vplsw_mns_uplsv_plsw);
  printmI3(                       &mupls_vplsw_mns_uplsv_plsw);

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n            Vector space axioms.                  ");
  printf("\n                                                  ");
  printf("\n          u + (v + w) = (v + u) + w               ");
  printf("\n          *************************               ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"vbI.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"vbI.exe 2\" -> 2x1  (1x2)             ");
  printf("\n          \"vbI.exe 4\" -> 4x1  (1x4)           \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if( vectrow){vectrow = 0;}
else        {vectrow = 1;}


  AB(n,vectrow);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












