/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
double pbA[2][2*TWOCOL]=
{
   2,1,   0,1,
   0,1,   2,1,
};
matrix mA={2,2*TWOCOL,&pbA[0][0]};

double pbu[2][5*TWOCOL]=
{
  0,1,   0,1,   4,1,   4,1,   0,1,
  0,1,   4,1,   4,1,   0,1,   0,1,
};
matrix mu={2,5*TWOCOL,&pbu[0][0]};

double pbv[2][5*TWOCOL];matrix mv={2,5*TWOCOL,&pbv[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */

  clrscrn();

  printf("\n dilation (contraction) :                  \n");
  printf("\n                |  2  0 |                         ");
  printf("\n        v[n]  = |       |  u[n]                   ");
  printf("\n                |  0  2 |                         ");

  printf("\n\n                                          u[n]");
  printmF(&mu);
  gnpltvectcol2d("u",&mu);

  multmF(&mA,&mu,&mv);
  printf("\n\n                                          v[n]");
  printmF(&mv);
  gnpltvectcol2d("v",&mv);
  gnpltaxis(     "aa2d.plt");

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
  printf("  * open the file aa2d.plt with Gnuplot. Gnuplot draw u and v. \n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n        dilation (contraction) :                  ");
  printf("\n        **********************                    ");
  printf("\n\n                                                ");
  printf("\n               Square ABCD.                       ");
  printf("\n\n                                                ");
  printf("\n                |  k  0 |                         ");
  printf("\n        v[n]  = |       |  u[n]                      ");
  printf("\n                |  0  k |                         ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
/*-------------------------------- PROGRAM ---------------------------------- */
  hello();

  AB();


  printf("\n Press Return to stop\n");
  getchar();

  return 0;
}












