/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
fraction deter;
double pbpn   [MXR][MXC*TWOCOL];matrix mpn    ={MXR,MXC*TWOCOL,&pbpn   [0][0]};
double pbq    [MXR][MXC*TWOCOL];matrix mq     ={MXR,MXC*TWOCOL,&pbq    [0][0]};
double pbqT   [MXR][MXC*TWOCOL];matrix mqT    ={MXR,MXC*TWOCOL,&pbqT   [0][0]};
double pbq_s  [MXR][MXC*TWOCOL];matrix mq_s   ={MXR,MXC*TWOCOL,&pbq_s  [0][0]};
double pbpn_q [MXR][MXC*TWOCOL];matrix mpn_q  ={MXR,MXC*TWOCOL,&pbpn_q [0][0]};

                   mpn.rows=n;        mpn.cols= n   *TWOCOL;
                    mq.rows=n;         mq.cols=      TWOCOL;
                   mqT.rows=n;        mqT.cols=      TWOCOL;
                  mq_s.rows=n;       mq_s.cols=      TWOCOL;
                 mpn_q.rows=n;      mpn_q.cols=(n+1)*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
   rndmI(&mpn,6);
   rndmI(&mq, 6);

  deter = detF(&mpn);

  if(deter.numer)
  {
     copymF(&mpn, &mpn_q);
   copycolF(&mq,0,&mpn_q,((mpn_q.cols/2)-1));

   clrscrn();
   printf("  Let S = {p1, p2, ... } be a basis of Pn.\n\n");
   printmpI(&mpn,"  p");
   printf("\n  Find the coordinate vector of q,\n\n");
   printmpI(&mq,"  q");
   printf("\n  with respect to S.\n\n");
   printf("\n  We must find scalars, a, b, ... such that : \n\n");
   printapn_q(&mpn_q);
   getchar();

   clrscrn();
   printmpI(&mpn,"  p");
   printf("\n\n");
   printmpI(&mq,"  q");
   printf("\n\n   or, in terms of components :\n\n");
   printapn_qI(&mpn_q);
   getchar();

   clrscrn();
   printapn_qI(&mpn_q);
   printf("   If we equate components, we obtain the following augmented matrix :\n\n");
   printmI(&mpn_q);
   getchar();

   clrscrn();
   printf("  This reduces to :\n");
   gaussjordanF(&mpn_q);
   printmIF(    &mpn_q);
   printf("\n  The solution gives the values of a, b, ... Therefore,    \n\n");
   copycolF(&mpn_q,(((mpn_q.cols)/2)-1),&mq_s,0);
   printmvF(                            &mq_s,"  (q)s");
   getchar();

   clrscrn();
   printmpI(&mpn, "    p");
   printf("\n\n");
   printmpI(&mq,  "    q");
   printf("\n\n");
   printmvF(&mq_s," (q)s");
   printf("\n\n");
   printq_s_pnI(&mq_s,&mpn);
   printf("\n");
   addw_svnF(&mpn,&mq_s,&mqT);
   printmpI(            &mqT,"\n  ");
  }
  else{
   clrscrn();
   printf("   deter = %.0f",deter.numer);
  }
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n  Let S = {p1, p2, ... } be a basis of Pn.    \n\n");
  printf(" Find the coordinate vector of q with respect to S.\n");
  printf(" **************************************************\n");
  printf("\n The degree of p : 3 ... 4.                     \n");
  printf("\n           ex : \"ws_PI.exe\"                   \n");
  printf("\n You can choose the degree :                    \n");
  printf("\n           ex : \"ws_PI.exe 2\" ->  P1           ");
  printf("\n                \"ws_PI.exe 3\" ->  P2           ");
  printf("\n                \"ws_PI.exe 4\" ->  P3            ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n = 2;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {
  ++n;
  if(n>4){n=2;}
 }
if( n < 2){n=2;}


  gjA(n);


printf("\n Press 'X' Return to stop :\n");
} while(toupper(getchar())!='X');

  return 0;
}

