/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
fraction InnerProduct_uv;
fraction InnerProduct_vu;

double pbu    [2][2*TWOCOL];matrix mu    ={2,2*TWOCOL,&pbu    [0][0]};
double pbv    [2][2*TWOCOL];matrix mv    ={2,2*TWOCOL,&pbv    [0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,1);
  rndmF(&mv,5,1);

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);

  printf("\n  Properties of inner product in M2x2 :");
  printf("\n             (Symetry axiom)         \n");
  printf("\n             <U,V>  =  <V,U>       \n\n");

  InnerProduct_uv = innerprod_Mnm(&mu,&mv);
  printf("  <U,V> =  %6.0lf/%-6.0lf\n\n",
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);

  InnerProduct_vu = innerprod_Mnm(&mv,&mu);
  printf("  <V,U> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_vu.numer,
            InnerProduct_vu.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in M2x2 :         \n");
  printf("\n             (Symetry axiom)                    \n");
  printf("\n\n\n                                              ");
  printf("\n              <U,V>  =  <V,U>                     ");
  printf("\n              ***************                     ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{

  AB();

  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












