/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
fraction InnerProduct_uplsv_w;
fraction InnerProduct_uw;
fraction InnerProduct_vw;
fraction InnerProduct_uwplsvw;

double pbu    [2][2*TWOCOL];matrix mu    ={2,2*TWOCOL,&pbu    [0][0]};
double pbv    [2][2*TWOCOL];matrix mv    ={2,2*TWOCOL,&pbv    [0][0]};
double pbw    [2][2*TWOCOL];matrix mw    ={2,2*TWOCOL,&pbw    [0][0]};
double pbuplsv[2][2*TWOCOL];matrix muplsv={2,2*TWOCOL,&pbuplsv[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);
  rndmF(&mv,5,3);
  rndmF(&mw,5,3);

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);
  printf("                                 W");
  printmF3(&mw);
  getchar();

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);

  printf("\n\n                             U + V");
  addmF(&mu,&mv,&muplsv);
  printmF3(     &muplsv);

  InnerProduct_uplsv_w = innerprod_Mnm(&muplsv,&mw);
  printf("\n\n <U + V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_uplsv_w.numer,
            InnerProduct_uplsv_w.denom);
  getchar();

  clrscrn();
  InnerProduct_uw = innerprod_Mnm(&mu,&mw);
  printf("       <U,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_uw.numer,
            InnerProduct_uw.denom);

  InnerProduct_vw = innerprod_Mnm(&mv,&mw);
  printf("       <V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_vw.numer,
            InnerProduct_vw.denom);

  InnerProduct_uwplsvw = addF(InnerProduct_uw,InnerProduct_vw);
  printf(" <U,W> + <V,W> =  %6.0lf/%-6.0lf \n\n",
              InnerProduct_uwplsvw.numer,
              InnerProduct_uwplsvw.denom);
  getchar();

  clrscrn();
  printf("\n  Properties of inner product in M2x2 :         \n");
  printf("\n             (Additivity axiom)                 \n");
  printf("\n          <U + V,W>  =  <U,W> + <V,W>\n\n\n\n");
  printf("     <U + V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_uplsv_w.numer,
            InnerProduct_uplsv_w.denom);

  printf(" <U,W> + <V,W> =  %6.0lf/%-6.0lf \n\n",
              InnerProduct_uwplsvw.numer,
              InnerProduct_uwplsvw.denom);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in M2x2 :         \n");
  printf("\n             (Additivity axiom)                 \n");
  printf("\n\n\n                                              ");
  printf("\n          <U + V,W>  =  <U,W> + <V,W>             ");
  printf("\n          ***************************             ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












