/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int p
)
{
fraction Distance_uv;
fraction Distance_uw;
fraction Distance_wv;

double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};
double pbw[MXR][MXC*TWOCOL];matrix mw={MXR,MXC*TWOCOL,&pbw[0][0]};

   mu.rows = n;           mu.cols = p*TWOCOL;
   mv.rows = n;           mv.cols = p*TWOCOL;
   mw.rows = n;           mw.cols = p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,1);
  rndmF(&mv,5,1);
  rndmF(&mw,5,1);

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  printf("                                 w");
  printmF3(&mw);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  Distance_uv = distance_MnmP2(&mu,&mv);  /* It is the square of the distance.*/
  printf("\n\n d(u,v) =  (%.0lf/%-.0lf)**(1/2)\n\n",
            Distance_uv.numer,
            Distance_uv.denom);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  printf("                                 w");
  printmF3(&mw);
  Distance_uw = distance_MnmP2(&mu,&mw);  /* It is the square of the distance.*/
  printf("\n\n d(u,w) =  (%.0lf/%-.0lf)**(1/2)\n\n",
            Distance_uw.numer,
            Distance_uw.denom);
  Distance_wv = distance_MnmP2(&mw,&mv);  /* It is the square of the distance.*/
  printf(" d(w,v) =  (%.0lf/%-.0lf)**(1/2)\n",
            Distance_wv.numer,
            Distance_wv.denom);
  getchar();


  clrscrn();
  printf("\n         Properties of distance in Mnm :\n  ");
  printf("\n           d(u,v) =< d(u,w) + d(w,v)      \n\n");
  printf("  (%.0lf/%-.0lf)**(1/2) =<  ",
                 Distance_uv.numer,
                 Distance_uv.denom);

  printf(" (%.0lf/%-.0lf)**(1/2) + (%.0lf/%-.0lf)**(1/2)\n\n",
                 Distance_uw.numer,
                 Distance_uw.denom,
                 Distance_wv.numer,
                 Distance_wv.denom);

  printf("           %.3lf =<  %.3lf\n\n",
            sqrt(     Distance_uv.numer/     Distance_uv.denom),
            sqrt(Distance_uw.numer/Distance_uw.denom)
            +
            sqrt(Distance_wv.numer/Distance_wv.denom));
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n         Properties of distance in Mnm            ");
  printf("\n                                                  ");
  printf("\n         d(u,v)  =<  d(u,w) + d(w,v)              ");
  printf("\n         ***************************              ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x2 ... 5x5.                \n");
  printf("\n     ex : \"distMc.exe\"                        \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"distMc.exe 2 3\" -> 2x3               ");
  printf("\n          \"distMc.exe 4 5\" -> 4x5             \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;}
  }
else
 {
  n=rndpI(5);
  p=rndpI(5);
 }
   if(n<2){n=2;}
   if(p<2){p=2;}


  AB(n,p);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












