/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n)
{
fraction InnerProduct_uplsv_w;
fraction InnerProduct_uw;
fraction InnerProduct_vw;
fraction InnerProduct_uwplsvw;

double pbu   [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbv   [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv   [0][0]};
double pbw   [MXR][MXC*TWOCOL];matrix mw    ={MXR,MXC*TWOCOL,&pbw   [0][0]};
double puplsv[MXR][MXC*TWOCOL];matrix muplsv={MXR,MXC*TWOCOL,&puplsv[0][0]};

       mu.rows = n;               mu.cols = n*TWOCOL;
       mv.rows = n;               mv.cols = n*TWOCOL;
       mw.rows = n;               mw.cols = n*TWOCOL;
   muplsv.rows = n;           muplsv.cols = n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);
  rndmF(&mv,5,3);
  rndmF(&mw,5,3);

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);
  printf("                                 W");
  printmF3(&mw);
  getchar();

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);

  printf("\n\n                             U + V");
  addmF(&mu,&mv,&muplsv);
  printmF3(     &muplsv);

  InnerProduct_uplsv_w = innerprod_Mnm(&muplsv,&mw);
  printf("\n\n <U + V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_uplsv_w.numer,
            InnerProduct_uplsv_w.denom);
  getchar();

  clrscrn();
  InnerProduct_uw = innerprod_Mnm(&mu,&mw);
  printf("       <U,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_uw.numer,
            InnerProduct_uw.denom);

  InnerProduct_vw = innerprod_Mnm(&mv,&mw);
  printf("       <V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_vw.numer,
            InnerProduct_vw.denom);

  InnerProduct_uwplsvw = addF(InnerProduct_uw,InnerProduct_vw);
  printf(" <U,W> + <V,W> =  %6.0lf/%-6.0lf \n\n",
              InnerProduct_uwplsvw.numer,
              InnerProduct_uwplsvw.denom);
  getchar();

  clrscrn();
  printf("\n  Properties of inner product in Mnn :         \n");
  printf("\n             (Additivity axiom)                 \n");
  printf("\n          <U + V,W>  =  <U,W> + <V,W>\n\n\n\n");
  printf("     <U + V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_uplsv_w.numer,
            InnerProduct_uplsv_w.denom);

  printf(" <U,W> + <V,W> =  %6.0lf/%-6.0lf \n\n",
              InnerProduct_uwplsvw.numer,
              InnerProduct_uwplsvw.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in Mnn :         \n");
  printf("\n             (Additivity axiom)                 \n");
  printf("\n\n\n                                              ");
  printf("\n          <U + V,W>  =  <U,W> + <V,W>             ");
  printf("\n          ***************************             ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

