/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int p
)
{
fraction InnerProduct_u_vmnsw;
fraction InnerProduct_uv;
fraction InnerProduct_uw;
fraction InnerProduct_uvmnsuw;

double pbu   [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbv   [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv   [0][0]};
double pbw   [MXR][MXC*TWOCOL];matrix mw    ={MXR,MXC*TWOCOL,&pbw   [0][0]};
double pvmnsw[MXR][MXC*TWOCOL];matrix mvmnsw={MXR,MXC*TWOCOL,&pvmnsw[0][0]};

        mu.rows = n;               mu.cols = p*TWOCOL;
        mv.rows = n;               mv.cols = p*TWOCOL;
        mw.rows = n;               mw.cols = p*TWOCOL;
    mvmnsw.rows = n;           mvmnsw.cols = p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);
  rndmF(&mv,5,3);
  rndmF(&mw,5,3);

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);
  printf("                                 W");
  printmF3(&mw);
  getchar();

  clrscrn();
  printf("                                 V");
  printmF3(&mv);
  printf("                                 W");
  printmF3(&mw);

  printf("\n\n                             V - W");
  addmF(&mv,&mw,&mvmnsw);
  printmF3(     &mvmnsw);

  InnerProduct_u_vmnsw = innerprod_Mnm(&mu,&mvmnsw);
  printf("\n\n <U,V-W> =  %6.0lf/%.0lf \n\n",
            InnerProduct_u_vmnsw.numer,
            InnerProduct_u_vmnsw.denom);
  getchar();

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);
  printf("                                 W");
  printmF3(&mw);

  InnerProduct_uv = innerprod_Mnm(&mu,&mv);
  printf("\n\n       <U,V> =  %6.0lf/%.0lf \n\n",
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);

  InnerProduct_uw = innerprod_Mnm(&mu,&mw);
  printf("       <U,W> =  %6.0lf/%.0lf \n\n",
            InnerProduct_uw.numer,
            InnerProduct_uw.denom);

  InnerProduct_uvmnsuw = addF(InnerProduct_uv,InnerProduct_uw);
  printf(" <U,V> - <U,W> =  %6.0lf/%.0lf ",
              InnerProduct_uvmnsuw.numer,
              InnerProduct_uvmnsuw.denom);
  getchar();

  clrscrn();
  printf("\n  Properties of inner product in Mnm :         \n");
  printf("\n          <U,V-W>  =  <U,V> - <U,W>\n\n\n\n");
  printf("       <U,V-W> =  %6.0lf/%.0lf \n\n",
            InnerProduct_u_vmnsw.numer,
            InnerProduct_u_vmnsw.denom);

  printf(" <U,V> - <U,W> =  %6.0lf/%.0lf \n\n",
              InnerProduct_uvmnsuw.numer,
              InnerProduct_uvmnsuw.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in Mnm :         \n");
  printf("\n\n\n                                              ");
  printf("\n          <U,V - W>  =  <U,V> - <U,W>             ");
  printf("\n          ***************************             ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;}
  }
else
 {
  n=rndpI(5);
  p=rndpI(5);
 }
   if(n<2){n=2;}
   if(p<2){p=2;}


  AB(n,p);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

